package name.matthewgreet.example11.action;

import javax.servlet.http.HttpSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionSupport;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import name.matthewgreet.example11.dto.PrimeMinisterDTO;
import name.matthewgreet.example11.form.PrimeMinisterForm;
import name.matthewgreet.example11.util.PrimeMinisterCompositeCache;
import name.matthewgreet.strutscommons.action.AbstractFormDrivenActionSupport;
import name.matthewgreet.strutscommons.util.ListCache;
import name.matthewgreet.strutscommons.util.NA;

/**
 * Updates a prime minister using data and custom converter for dates entered as strings.  
 */
@InterceptorRef("FormDrivenStack")
@Results({
	@Result(name=ActionSupport.INPUT, type="redirectAction", params = {"namespace", "/", "actionName", "ViewPrimeMinister"}),
	@Result(name=ActionSupport.SUCCESS, type="redirectAction", params = {"namespace", "/", "actionName", "ViewPrimeMinister"})
})
public class UpdatePrimeMinisterAction extends AbstractFormDrivenActionSupport<PrimeMinisterForm> {
	private static final long serialVersionUID = -7979376337555804889L;
	
    private Logger LOG = LogManager.getLogger(UpdatePrimeMinisterAction.class);
    
	@Override
	protected PrimeMinisterForm makeForm() {
		return new PrimeMinisterForm();
	}


	@Action("/UpdatePrimeMinister")
    @Override
    public String execute() throws Exception {
    	PrimeMinisterDTO primeMinister;
    	PrimeMinisterForm form;
    	ListCache<NA,Integer,PrimeMinisterDTO> listCache;
    	HttpSession session;
    	
    	form = getModel();
    	session = getBrowserTabSession();
    	listCache = PrimeMinisterCompositeCache.getInstance(session).getMasterListCache();
    	primeMinister = listCache.getSelected();
    	primeMinister.setName(form.getName());
    	primeMinister.setDateOfBirth(form.getDateOfBirth());
    	primeMinister.setWikipediaEntry(form.getWikipediaEntry());
    	primeMinister.setTermsOfOffice(form.getTermsOfOffice());
    	primeMinister.setParty(form.getParty());
    	primeMinister.setMaxSeatsWon(form.getMaxSeatsWon());
    	primeMinister.setConstituency(form.getConstituency());
    	primeMinister.setBestConstituencyMajority(form.getBestConstituencyMajority());
    	primeMinister.setBestConstituencyYear(form.getBestConstituencyYear());
    	
    	addActionMessage(getTextProvider().getText("message.success"));
		
		return SUCCESS;
    }

	@Override
	public Logger getLogger() {
		return LOG;
	}

}
