package name.matthewgreet.example11.action;

import javax.servlet.http.HttpSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionSupport;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import com.opensymphony.xwork2.ActionContext;

import name.matthewgreet.example11.dto.PrimeMinisterDTO;
import name.matthewgreet.example11.form.PrimeMinisterForm;
import name.matthewgreet.example11.util.PrimeMinisterCompositeCache;
import name.matthewgreet.example11.view.LocaleSelectBoxDisplay;
import name.matthewgreet.example11.view.PartySelectBoxDisplay;
import name.matthewgreet.strutscommons.action.AbstractViewActionSupport;
import name.matthewgreet.strutscommons.annotation.FormField;
import name.matthewgreet.strutscommons.util.ListCache;
import name.matthewgreet.strutscommons.util.NA;


/**
 * Displays page to edit a Prime Minister record where dates and date ranges are strings.  
 */
@SuppressWarnings("deprecation")
@InterceptorRef("ViewStack")
@Results({
	@Result(name="list", type="redirectAction", params = {"namespace", "/", "actionName", "ViewPrimeMinisterList"}),
	@Result(name=ActionSupport.SUCCESS, location="/pages/PrimeMinister.jsp")
})
public class ViewPrimeMinisterAction extends AbstractViewActionSupport {
	private static final long serialVersionUID = -7979376337555804889L;
	
    private Logger LOG = LogManager.getLogger(ViewPrimeMinisterAction.class);
    
    @FormField
    private boolean refresh;
    @FormField
	private Integer recordNo;
	
	private PrimeMinisterForm form;
	
	private int listSize;
	private LocaleSelectBoxDisplay localeSelectBoxDisplay;
	private PartySelectBoxDisplay partySelectBoxDisplay;
	
	
    @Action("/ViewPrimeMinister")
    @Override
    public String execute() throws Exception {
    	PrimeMinisterDTO primeMinister;
    	ListCache<NA,Integer,PrimeMinisterDTO> listCache;
    	HttpSession session;
    	
    	session = getBrowserTabSession();
    	
    	listCache = PrimeMinisterCompositeCache.getInstance(session).getMasterListCache();
    	if (listCache.getReload()) {	// No list due to expired session
    		return "list";
    	}
    	
    	if (refresh) {
    		listCache.forceReload();
    	}
	    if (recordNo != null) {
	    	listCache.setSelectedIndex(recordNo - 1);
	    }
	    
	    listSize = listCache.getListSize();
	    recordNo = listCache.getSelectedIndex() + 1;
	    
	    localeSelectBoxDisplay = new LocaleSelectBoxDisplay();
	    localeSelectBoxDisplay.setSelectedValue(ActionContext.getContext().getLocale().getLanguage() + "_" + ActionContext.getContext().getLocale().getCountry());
	    
	    primeMinister = listCache.getSelected();
	    
	    if (form == null) {
	    	form = new PrimeMinisterForm(primeMinister);
	    }
	    
	    partySelectBoxDisplay = new PartySelectBoxDisplay();
	    partySelectBoxDisplay.setSelectedValueWithConversionError(form.getParty(), "form.party");
	    
		return SUCCESS;
    }

	@Override
	public Logger getLogger() {
		return LOG;
	}


	public boolean getRefresh() {
		return refresh;
	}
	public void setRefresh(boolean refresh) {
		this.refresh = refresh;
	}

	public int getListSize() {
		return listSize;
	}
	public Integer getRecordNo() {
		return recordNo;
	}
	public void setRecordNo(Integer recordNo) {
		this.recordNo = recordNo;
	}

	public LocaleSelectBoxDisplay getLocaleSelectBoxDisplay() {
		return localeSelectBoxDisplay;
	}

	public PrimeMinisterForm getForm() {
		return form;
	}

	public PartySelectBoxDisplay getPartySelectBoxDisplay() {
		return partySelectBoxDisplay;
	}


}
