package name.matthewgreet.example11.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.example11.dto.DateRange;
import name.matthewgreet.strutscommons.annotation.DateConversion.Style;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * <P>Defines a form field (whether on a Struts Action or model of ModelDriven Struts Action) should be parsed from 
 *    comma separated values to some collection type of {@link DateRange} and error message to display if this fails.  
 *    The date range format is '<date>~<date>', or '<date>~' for no end.  If the start is greater than the end, the 
 *    ends are swapped.  By default, DD/MM/YYYY format is used for date but this can be overridden or use user's locale 
 *    by setting format to empty string.Different separators can be set instead of comma.  Also, defines a view helper 
 *    field receives a formatted DateRange collection value.</P>
 *
 * <P>There are two modes of behaviour for conversion, depending on the type of form field.</P>
 * <TABLE>
 *   <CAPTION>Annotation Usage</CAPTION>
 *   <TR>
 *     <TH>Form field type</TH>
 *     <TH>Mode</TH>
 *     <TH>Description</TH>
 *   </TR>
 *   <TR>
 *     <TD>String</TD>
 *     <TD>Pair conversion</TD>
 *     <TD>Converts string field value to Integer collection type field named by parsedFieldName</TD>
 *   </TR>
 *   <TR>
 *     <TD>DateRange collection type</TD>
 *     <TD>Auto conversion</TD>
 *     <TD>Converts directly from request parameter</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>By default, messages are added to the actionErrors list but this can be overridden by <CODE>messageType</CODE>:</P>
 * <DL>
 *   <DT>ERROR</DT><DD>Message added to Action level error messages.  Default.</DD>
 *   <DT>FIELD</DT><DD>Message added to field error messages.</DD>
 *   <DT>MESSAGE</DT><DD>Message added to Action level info messages.</DD>
 * </DL>
 * 
 * <P>Other parameters</P>
 * <DL>
 *   <DT>format</DT><DD>If not empty string, fixed date format, using SimpleDateFormat format.  Defaults to dd/MM/yyyy.
 *                      Set to empty string to use format according to locale.</DD>
 *   <DT>localeCountry</DT><DD>If not empty string, country code for specific locale, as used in Locale.  If set, 
 *                             localeLanguage must also be set.  Ignored if format is not empty string.  Set to empty 
 *                             string to use ActionContext's locale.  Defaults to empty string.</DD>
 *   <DT>localeLanguage</DT><DD>If not empty string, language code for specific locale, as used in Locale.  If set, 
 *                             localeCountry must also be set.  Ignored if format is not empty string.  Set to empty 
 *                             string to use ActionContext's locale.  Defaults to empty string.</DD>
 *   <DT>message</DT><DD>If not empty string, text message to display.  Used if <CODE>messageKey</CODE> is empty string 
 *                       or finds no message.</DD>
 *   <DT>messageKey</DT><DD>If not empty string, message key to retrieve from Action's TextProvider.  Uses 
 *                          <CODE>message</CODE> if no key provided or no message found.</DD>
 *   <DT>parsedFieldName</DT><DD>If not empty string, name of field to contain parsed value.  Defaults to 'parsed' plus 
 *                               capitalised field name, such as 'parsedLimit'.  Only applies for pair conversion.</DD>
 *   <DT>separator</DT><DD>Separator between numbers.  Defaults to ','.</DD>
 *   <DT>style</DT><DD>Date style of a locale's date format to used, same as DateFormat date style.  Ignored if format 
 *                     is not empty string.  Defaults to SHORT.</DD>
 * </DL>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface DateRangeListConversion {
    public String format() default "dd/MM/yyyy";
    public String localeCountry() default "";
    public String localeLanguage() default "";
    public String message() default "";
    public String messageKey() default "";
    public MessageType messageType() default MessageType.ERROR;
    public String parsedFieldName() default "";
    public String separator() default ",";
    public Style style() default Style.SHORT;
}
