package name.matthewgreet.example11.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PrimeMinisterDTO implements Serializable {
	public enum Party {CONSERVATIVE, LABOUR, LIBERAL, WHIG};
	
	private static final long serialVersionUID = -6937072630784482008L;
	
	private int id;
	private String name;
	private Date dateOfBirth;
	private String wikipediaEntry;
	private List<DateRange> termsOfOffice = new ArrayList<>();
	private Party party;
	private Integer maxSeatsWon;
	private String constituency;
	private Integer bestConstituencyMajority;
	private Short bestConstituencyYear;
	
	
	public PrimeMinisterDTO() {
		super();
	}
	
	public PrimeMinisterDTO(PrimeMinisterDTO other) {
		super();
		this.id = other.id;
		this.name = other.name;
		this.dateOfBirth = other.dateOfBirth;
		this.termsOfOffice = new ArrayList<>(other.termsOfOffice);
		this.party = other.party;
		this.maxSeatsWon = other.maxSeatsWon;
		this.constituency = other.constituency;
		this.bestConstituencyMajority = other.getBestConstituencyMajority();
		this.bestConstituencyYear = other.bestConstituencyYear;
	}
	

	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public Date getDateOfBirth() {
		return dateOfBirth;
	}
	public void setDateOfBirth(Date dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}
	
	public String getWikipediaEntry() {
		return wikipediaEntry;
	}
	public void setWikipediaEntry(String wikipediaEntry) {
		this.wikipediaEntry = wikipediaEntry;
	}

	public List<DateRange> getTermsOfOffice() {
		return termsOfOffice;
	}
	public void setTermsOfOffice(List<DateRange> termsOfOffice) {
		this.termsOfOffice = termsOfOffice;
	}
	
	public Party getParty() {
		return party;
	}
	public void setParty(Party party) {
		this.party = party;
	}
	
	public Integer getMaxSeatsWon() {
		return maxSeatsWon;
	}
	public void setMaxSeatsWon(Integer maxSeatsWon) {
		this.maxSeatsWon = maxSeatsWon;
	}
	
	public String getConstituency() {
		return constituency;
	}
	public void setConstituency(String constituency) {
		this.constituency = constituency;
	}

	public Integer getBestConstituencyMajority() {
		return bestConstituencyMajority;
	}
	public void setBestConstituencyMajority(Integer bestConstituencyMajority) {
		this.bestConstituencyMajority = bestConstituencyMajority;
	}

	public Short getBestConstituencyYear() {
		return bestConstituencyYear;
	}
	public void setBestConstituencyYear(Short bestConstituencyYear) {
		this.bestConstituencyYear = bestConstituencyYear;
	}

	
	@Override
	public String toString() {
		final int maxLen = 10;
		return "PrimeMinisterDTO [id=" + id + ", " + (name != null ? "name=" + name + ", " : "")
				+ (dateOfBirth != null ? "dateOfBirth=" + dateOfBirth + ", " : "")
				+ (wikipediaEntry != null ? "wikipediaEntry=" + wikipediaEntry + ", " : "")
				+ (termsOfOffice != null
						? "termsOfOffice=" + termsOfOffice.subList(0, Math.min(termsOfOffice.size(), maxLen)) + ", "
						: "")
				+ (party != null ? "party=" + party + ", " : "")
				+ (maxSeatsWon != null ? "maxSeatsWon=" + maxSeatsWon + ", " : "")
				+ (constituency != null ? "constituency=" + constituency + ", " : "") + "bestConstituencyMajority="
				+ bestConstituencyMajority + ", bestConstituencyYear=" + bestConstituencyYear + "]";
	}
	
}