package name.matthewgreet.example11.policy;

import name.matthewgreet.example11.annotation.IntegerInnerOuterRange;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.policy.AbstractPostConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.ValidationResult;

public class IntegerInnerOuterRangeValidator extends AbstractPostConversionValidatorSupport<IntegerInnerOuterRange,Integer> {
	public enum RangeRejection {NONE, TOO_LOW, WARNING_LOW, WARNING_HIGH, TOO_HIGH}
	
	private RangeRejection rangeRejection = RangeRejection.NONE;
	

    @Override
    public MessageType getMessageType() {
    	switch (rangeRejection) {
		case NONE:			return MessageType.MESSAGE;
		case TOO_HIGH:		return getAnnotation().messageType();
		case TOO_LOW:   	return getAnnotation().messageType();
		case WARNING_HIGH:	return MessageType.WARNING;
		case WARNING_LOW:	return MessageType.WARNING;
    	}
        return MessageType.MESSAGE;
    }

    @Override
    public String getMessage() {
    	switch (rangeRejection) {
		case NONE:			return "";
		case TOO_HIGH:		return getAnnotation().tooHighMessage();
		case TOO_LOW:   	return getAnnotation().tooLowMessage();
		case WARNING_HIGH:	return getAnnotation().warningHighMessage();
		case WARNING_LOW:	return getAnnotation().warningLowMessage();
    	}
        return "";
    }

    @Override
    public String getMessageKey() {
    	switch (rangeRejection) {
		case NONE:			return "";
		case TOO_HIGH:		return getAnnotation().tooHighMessageKey();
		case TOO_LOW:   	return getAnnotation().tooLowMessageKey();
		case WARNING_HIGH:	return getAnnotation().warningHighMessageKey();
		case WARNING_LOW:	return getAnnotation().warningLowMessageKey();
    	}
        return "";
    }

    @Override
    public Class<Integer> getRecipientClass() {
        return Integer.class;
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

    @Override
    public ValidationResult validate(Integer fieldValue) throws Exception {
        int value;
        
        value = (Integer)fieldValue;
        if (value < getAnnotation().outerMin()) {
        	rangeRejection = RangeRejection.TOO_LOW;
            return ValidationResult.makeFailureResult();
        } else if (value < getAnnotation().innerMin()) {
        	rangeRejection = RangeRejection.WARNING_LOW;
            return ValidationResult.makeFailureResult();
        } else if (value > getAnnotation().outerMax()) {
        	rangeRejection = RangeRejection.TOO_HIGH;
            return ValidationResult.makeFailureResult();
        } else if (value > getAnnotation().innerMax()) {
        	rangeRejection = RangeRejection.WARNING_HIGH;
            return ValidationResult.makeFailureResult();
        } else {
            return ValidationResult.makeSuccessResult();
        }
    }

}
