package name.matthewgreet.example11.policy;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.opensymphony.xwork2.ActionContext;

import name.matthewgreet.example11.annotation.IntegerLocaleConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;

@SuppressWarnings("deprecation")
public class IntegerLocaleConverter extends AbstractDefaultConverterSupport<IntegerLocaleConversion,Integer> {
    private static final Logger LOG = LogManager.getLogger(IntegerLocaleConverter.class);
    
    @IntegerLocaleConversion
    private static boolean annotationPlaceholder;

	@Override
	protected IntegerLocaleConversion makeDefaultAnnotation() {
		try {
			return IntegerLocaleConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(IntegerLocaleConversion.class);
		}
    	catch (Exception e) {
			LOG.error("Creation of default annotation failed", e);
			return null;
		}
	}

    protected NumberFormat makeNumberFormat() {
        NumberFormat result;
        Locale locale;
        
        if (getAnnotation().localeCountry().length() > 0 && getAnnotation().localeLanguage().length() > 0) {
            locale = new Locale(getAnnotation().localeLanguage(), getAnnotation().localeCountry());
            result = DecimalFormat.getIntegerInstance(locale);
        } else {
            locale = ActionContext.getContext().getLocale();
            result = DecimalFormat.getIntegerInstance(locale);
        }
        return result;
    }

    @Override
    public String format(Integer unformattedValue) throws Exception {
        NumberFormat formatter;
        
        formatter = makeNumberFormat();
        return formatter.format(unformattedValue);
    }

    @Override
    public Class<Integer> getRecipientClass() {
        return Integer.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Integer> convert(String formValue, Class<? extends Integer> recipientClass) throws Exception {
        int parsedValue;
        Number number;
        NumberFormat formatter;
        
        try {
            formatter = makeNumberFormat();
            number = formatter.parse(formValue);
            parsedValue = number.intValue();
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (ParseException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
