package name.matthewgreet.example11.policy;

import name.matthewgreet.example11.annotation.StartsWith;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.policy.AbstractNonConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.ValidationResult;

public class StartsWithValidator extends AbstractNonConversionValidatorSupport<StartsWith> {

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

    @Override
    public ValidationResult validate(String formValue) throws Exception {
        String workingValue;
        
        workingValue = formValue;
        if (getAnnotation().trim()) {
            workingValue = workingValue.trim();
        }
        if (workingValue.startsWith(getAnnotation().startsWith())) {
            return ValidationResult.makeSuccessResult();
        } else {
            return ValidationResult.makeFailureResult();
        }
    }

}
