package name.matthewgreet.example11.policy;

import org.apache.commons.text.WordUtils;

import name.matthewgreet.example11.annotation.ToCapitalised;
import name.matthewgreet.strutscommons.policy.AbstractAdjusterSupport;

public class ToCapitalisedAdjuster extends AbstractAdjusterSupport<ToCapitalised> {

	@Override
	public String adjust(String fieldValue) throws Exception {
		return WordUtils.capitalizeFully(fieldValue);
	}

	@Override
	public boolean getProcessNoValue() {
		return false;
	}

}
