package name.matthewgreet.example11.view;

import java.util.ArrayList;
import java.util.List;

import name.matthewgreet.strutscommons.view.IntegerListSelectBoxDisplay2;
import name.matthewgreet.strutscommons.view.SelectBoxItemDisplay2;

public class OptionalMonthSelectBoxDisplay extends IntegerListSelectBoxDisplay2 {
	private String formatMonth(int month) {
		switch (month) {
		case 1:	return "January";
		case 2:	return "Febuary";
		case 3:	return "March";
		case 4:	return "April";
		case 5:	return "May";
		case 6:	return "June";
		case 7:	return "July";
		case 8:	return "August";
		case 9:	return "September";
		case 10: return "October";
		case 11: return "November";
		case 12: return "December";
		}
		return "";
	}
	
    protected List<SelectBoxItemDisplay2<Integer,Integer>> getInitialList() {
    	List<SelectBoxItemDisplay2<Integer,Integer>> result;
    	
    	result = new ArrayList<>();
    	result.add(new SelectBoxItemDisplay2<Integer,Integer>("", "", null, null));
    	for (int month = 1; month <= 12; month++) {
        	result.add(new SelectBoxItemDisplay2<Integer,Integer>(Integer.toString(month), formatMonth(month), month, month));
    	}
        return result;
    }
    

}
