package name.matthewgreet.example11.view;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
//import java.util.ArrayList;
import java.util.List;

import name.matthewgreet.example11.annotation.DateRangeConversion;
import name.matthewgreet.example11.annotation.IntegerLocaleConversion;
import name.matthewgreet.example11.dto.DateRange;
import name.matthewgreet.example11.dto.PrimeMinisterDTO;
import name.matthewgreet.example11.dto.PrimeMinisterDTO.Party;
import name.matthewgreet.strutscommons.annotation.CustomConversion;
import name.matthewgreet.strutscommons.annotation.DateConversion;
import name.matthewgreet.strutscommons.util.StrutsMiscellaneousLibrary;
import name.matthewgreet.strutscommons.policy.AbstractCustomFormatterSupport;

public class PrimeMinisterDisplay {
	public static class PartyFormatter extends AbstractCustomFormatterSupport<Party> {

		@Override
		public Class<Party> getRecipientClass() {
			return Party.class;
		}

		@Override
		public String format(Party unformattedValue) {
			return PrimeMinisterDisplay.formatParty(unformattedValue);
		}
	}
	
	private String id;
	private String name;
	@DateConversion(format = "")
	private String dateOfBirth;
	@DateRangeConversion(format = "")
	private List<String> termsOfOffice;
	@CustomConversion(validatorClass = PartyFormatter.class)
	private String party;
	@IntegerLocaleConversion
	private String maxSeatsWon;
	private String constituency;
	@IntegerLocaleConversion
	private String bestConstituencyMajority;
	private Short bestConstituencyYear;
	
	
	public String formatDateRange(DateRange unformattedValue) {
    	DateFormat dateFormat;
        String result;
        
        dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        result = "";
        if (unformattedValue.getStart() != null) {
        	result = result + dateFormat.format(unformattedValue.getStart());
        }
        result = result + "-";
        if (unformattedValue.getEnd() != null) {
        	result = result + dateFormat.format(unformattedValue.getEnd());
        }
        return result;
	}
	
	public static String formatParty(Party party) {
		switch (party) {
		case CONSERVATIVE:	return "Conservative";
		case LABOUR:		return "Labour";
		case LIBERAL:		return "Liberal";
		case WHIG:			return "Whig";
		}
		return "";
	}
	
	
	public PrimeMinisterDisplay(PrimeMinisterDTO model) {
		StrutsMiscellaneousLibrary.updateDisplay(PrimeMinisterDTO.class, model, this);
	}
	
	public String getId() {
		return id;
	}
	public String getName() {
		return name;
	}
	public String getDateOfBirth() {
		return dateOfBirth;
	}
	public List<String> getTermsOfOffice() {
		return termsOfOffice;
	}
	public String getParty() {
		return party;
	}
	public String getMaxSeatsWon() {
		return maxSeatsWon;
	}
	public String getConstituency() {
		return constituency;
	}
	public String getBestConstituencyMajority() {
		return bestConstituencyMajority;
	}
	public Short getBestConstituencyYear() {
		return bestConstituencyYear;
	}

	
	@Override
	public String toString() {
		final int maxLen = 10;
		return "PrimeMinisterDisplay [" + (id != null ? "id=" + id + ", " : "")
				+ (name != null ? "name=" + name + ", " : "")
				+ (dateOfBirth != null ? "dateOfBirth=" + dateOfBirth + ", " : "")
				+ (termsOfOffice != null
						? "termsOfOffice=" + termsOfOffice.subList(0, Math.min(termsOfOffice.size(), maxLen)) + ", "
						: "")
				+ (party != null ? "party=" + party + ", " : "")
				+ (maxSeatsWon != null ? "maxSeatsWon=" + maxSeatsWon + ", " : "")
				+ (constituency != null ? "constituency=" + constituency + ", " : "")
				+ (bestConstituencyMajority != null ? "bestConstituencyMajority=" + bestConstituencyMajority + ", "
						: "")
				+ (bestConstituencyYear != null ? "bestConstituencyYear=" + bestConstituencyYear : "") + "]";
	}
	
}