package name.matthewgreet.strutscommons.action;


import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.action.ServletResponseAware;

import com.google.gson.Gson;

/**
 * <P>Template class of Struts 2 action for serving Json data of generic type T, usually for JQuery-based pages using 
 * jQuery.getJSON.</P>
 * 
 * <P>The following is an example for generic type T:</P>
 * 
 * <PRE>
 *   public static class ProcessParamItem {
 *       &#064;JsonProperty("value")
 *       private String value;
 *       
 *
 *       public String getValue() {
 *           return value;
 *       }
 *       public void setValue(String value) {
 *           this.value = value;
 *       }
 *        
 *       public String toString() {
 *           return "ProcessParamItem [value=" + value + "]";
 *       }
 *   }
 * </PRE>
 * 
 * @param <T> Type to convert to JSON.
 */
public abstract class AbstractJsonServerAction<T> extends AbstractActionSupport implements ServletResponseAware {
	private static final long serialVersionUID = 1975928721158752124L;

	public AbstractJsonServerAction() {
		super();
	}
	
    private HttpServletResponse response;
    
    /**
     * Can be overridden to set execute result if it fails. 
     */
    protected String getErrorResultName() {
        return "error";
    }
    
    protected abstract T makeContent() throws Exception;
    
    
    @Override
    public String execute() throws Exception {
        T content;
        Gson gson;
        
        super.execute();
        content = makeContent();
        gson = new Gson();
        gson.toJson(content, response.getWriter());
        return null;
    }



    public HttpServletResponse getResponse() {
        return response;
    }
    @Override
    public void withServletResponse(HttpServletResponse response) {
        this.response = response;
    }

}
