package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <P>Defines a form field (whether on a Struts Action or model of ModelDriven Struts Action) should be converted to 
 * a boolean or Boolean type.  The value parses to true if it starts with '1', 't' or 'y' (lowercase or uppercase), 
 * otherwise false.  No error message can happen.  Also, defines a view helper field receives a formatted boolean value.  
 * This is the default converter for boolean and Boolean fields.</P>
 *
 * <P>There are two modes of behaviour for conversion, depending on the type of form field.</P>
 * <TABLE>
 *   <CAPTION>Annotation Usage</CAPTION>
 *   <TR>
 *     <TH>Form field type</TH>
 *     <TH>Mode</TH>
 *     <TH>Description</TH>
 *   </TR>
 *   <TR>
 *     <TD>String</TD>
 *     <TD>Pair conversion</TD>
 *     <TD>Converts string field value to boolean or Boolean field named by parsedFieldName</TD>
 *   </TR>
 *   <TR>
 *     <TD>boolean or Boolean</TD>
 *     <TD>Auto conversion</TD>
 *     <TD>Converts directly from request parameter</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>Other parameters</P>
 * <DL>
 *   <DT>parsedFieldName</DT><DD>If not empty string, name of field to contain parsed value.  Defaults to 'parsed' plus 
 *                               capitalised field name, such as 'parsedLimit'.  Only applies for pair conversion.</DD>
 * </DL>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface BooleanConversion {
    public String parsedFieldName() default "";
}
