package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.policy.AbstractCustomCollectionPostConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.CollectionPostConversionValidator;

/**
 * <P>Defines custom validation of a collection of converted values and error message to display if this fails.  The 
 * custom validator must implement {@link CollectionPostConversionValidator}, preferably extending  
 * {@link AbstractCustomCollectionPostConversionValidatorSupport}, and have a default public constructor.</P>
 * 
 * <P>By default, messages are added to the actionErrors list but this can be overridden by <CODE>messageType</CODE>:</P>
 * <DL>
 *   <DT>ERROR</DT><DD>Message added to Action level error messages.  Default.</DD>
 *   <DT>FIELD</DT><DD>Message added to field error messages.</DD>
 *   <DT>MESSAGE</DT><DD>Message added to Action level info messages.</DD>
 * </DL>
 * 
 * <P>Other parameters</P>
 * <DL>
 *   <DT>message</DT><DD>If not empty string, text message to display.  Used if <CODE>messageKey</CODE> is empty string 
 *                       or finds no message.</DD>
 *   <DT>messageKey</DT><DD>If not empty string, message key to retrieve from Action's TextProvider.  Uses 
 *                          <CODE>message</CODE> if no key provided or no message found.</DD>
 *   <DT>param1</DT><DD>Parameter recognised by custom validator.  Defaults to empty string.</DD>
 *   <DT>param2</DT><DD>Parameter recognised by custom validator.  Defaults to empty string.</DD>
 *   <DT>param3</DT><DD>Parameter recognised by custom validator.  Defaults to empty string.</DD>
 *   <DT>param4</DT><DD>Parameter recognised by custom validator.  Defaults to empty string.</DD>
 *   <DT>param5</DT><DD>Parameter recognised by custom validator.  Defaults to empty string.</DD>
 *   <DT>shortCircuit</DT><DD>If true and this validation fails, skips further validation.  Defaults to false.</DD>
 *   <DT>processNoValue</DT><DD>If true, can validate null value and empty collection.  Defaults to false.</DD>
 *   <DT>validatorClass</DT><DD>Class of client supplied validator.  See notes above.</DD>
 * </DL>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface CustomCollectionPostConversionValidation {
    public String message() default "";
    public String messageKey() default "";
    public MessageType messageType() default MessageType.ERROR;
    public String param1() default "";
    public String param2() default "";
    public String param3() default "";
    public String param4() default "";
    public String param5() default "";
    public boolean shortCircuit() default false;
    public boolean processNoValue() default true;
    public Class<? extends CollectionPostConversionValidator<CustomCollectionPostConversionValidation,?>> validatorClass();
}
