package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.util.StrutsMiscellaneousLibrary;

/**
 * <P>Defines a member variable of a Struts action as receiving an injected form processed by another Struts action, 
 * whether successfully or not, usually to display it.  The member variable is only set if the form's type is compatible 
 * with its type.</P>
 * 
 * <P>If any <CODE>processors</CODE> are set, the class of the Struts action that processed the form (successfully or 
 * not) must match or be a subclass one of the values.  This is useful if multiple displayed forms happen to be the same
 * type.</P>
 * 
 * <P>By default, the member variable is only set if the form's processor rejected the form.  How <CODE>reception</CODE> 
 * values affect form data reception:</P>
 * <DL>
 * <DT>NEVER</DT><DD>Never accepts form data.</DD>
 * <DT>ERROR</DT><DD>Only if form data was rejected.  Default.</DD>
 * <DT>SUCCESS</DT><DD>Only if form data was accepted.</DD>
 * <DT>ALWAYS</DT><DD>Always accepts form data.</DD>
 * </DL>
 * 
 * <P>Other parameters</P>
 * <DL>
 * <DT>disableFormatting</DT><DD>If true, disables setting of form fields from their unformatted values (unless 
 *                               {@link StrutsMiscellaneousLibrary#formatForm} is explicitly called).</DD>
 * </DL>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Form {
	/**
	 * Form validation success/fail states accepted by receiving Action.  See {@link Form}.
	 */
    public enum Reception {NEVER, ERROR, SUCCESS, ALWAYS}
    
    public boolean disableFormatting() default false;
    public Class<?>[] processors() default {};
    public Reception reception() default Reception.ERROR;
}
