package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <P>Defines a form field (whether on a Struts Action or model of ModelDriven Struts Action) should be parsed from 
 * comma separated values to some collection of String.  Different separators can be set instead of 
 * comma.  No error message can happen.  Also, defines a view helper field receives a formatted 
 * string collection value.</P>
 *
 * <P>There are two modes of behaviour for conversion, depending on the type of form field.</P>
 * <TABLE>
 *   <CAPTION>Annotation Usage</CAPTION>
 *   <TR>
 *     <TH>Form field type</TH>
 *     <TH>Mode</TH>
 *     <TH>Description</TH>
 *   </TR>
 *   <TR>
 *     <TD>String</TD>
 *     <TD>Pair conversion</TD>
 *     <TD>Converts string field value to String collection type field named by parsedFieldName</TD>
 *   </TR>
 *   <TR>
 *     <TD>String collection type</TD>
 *     <TD>Auto conversion</TD>
 *     <TD>Converts directly from request parameter</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>Other parameters</P>
 * <DL>
 *   <DT>parsedFieldName</DT><DD>If not empty string, name of field to contain parsed value.  Defaults to 'parsed' plus 
 *                               capitalised field name, such as 'parsedLimit'.  Only applies for pair conversion.</DD>
 *   <DT>separator</DT><DD>Separator between text.  Defaults to ','.</DD>
 *   <DT>trim</DT><DD>Whether to trim whitespace from each entry using the trim function.  Defaults to true.</DD>
 * </DL>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface StringCSVConversion {
    public String parsedFieldName() default "";
    public String separator() default ",";
    public boolean trim() default true;
}
