package name.matthewgreet.strutscommons.form;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * Value Object that describes the successes and failures of manually written conversion of request parameters.  
 * The values of parameters that failed conversion are placed onto the Value Stack as conversion errors. 
 */
public class ManualParameterConversionResult implements Serializable {
	private static final long serialVersionUID = 2021732767012963984L;
	
	private Set<String> processedParameterNames = new HashSet<>();
	private Set<String> failedParameterNames = new HashSet<>();
	
	
	public Set<String> getProcessedParameterNames() {
		return processedParameterNames;
	}
	public Set<String> getFailedParameterNames() {
		return failedParameterNames;
	}
	
}
