package name.matthewgreet.strutscommons.interceptor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import name.matthewgreet.strutscommons.form.FormattableForm;
import name.matthewgreet.strutscommons.util.DefaultFormFormatter;
import name.matthewgreet.strutscommons.util.FormFormatter;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;

/**
 * <P>Struts 2 Interceptor used by view Actions for writing formatted versions of forms onto the Value Stack, so they're 
 * displayed instead of the unformatted form, using any conversion annotations on form fields.  Such forms must 
 * implement {@link FormattableForm}.  Does not apply to injected forms as its conversion errors are copied.</P>
 * 
 * <P><U>Interceptor parameters:</U></P>
 * <DL>
 * <DT>disabled</DT><DD>If true, all processing for this action is disabled.  Defaults to false.</DD>
 * </DL>
 *
 * <P><U>Extending the interceptor:</U></P>
 * <P>This interceptor cannot be usefully extended.</P>
 *
 * <P> <u>Example code:</u></P>
 * <PRE>
 * &lt;action name="someAction" class="com.examples.SomeAction"&gt;
 *     &lt;interceptor-ref name="annotationValidation"/&gt;
 *     &lt;interceptor-ref name="validation"/&gt;
 *     &lt;interceptor-ref name="formFormatter"/&gt;
 *     &lt;result name="success"&gt;good_result.ftl&lt;/result&gt;
 * &lt;/action&gt;
 * <!-- END SNIPPET: example -->
 * </PRE>
 */
@SuppressWarnings("deprecation")
public class FormFormatterInterceptor extends AbstractInterceptor {
	public class FormFormatterPreResultListener implements PreResultListener {

		public void beforeResult(ActionInvocation invocation, String resultCode) {
			FormFormatter formFormatLibrary;
			
			formFormatLibrary = makeFormFormatLibrary();
			formFormatLibrary.formatForms();
		}

	}
	
    private static final long serialVersionUID = 2689404505465349761L;
    
    private boolean disabled;
    

    @SuppressWarnings("unused")
	private Logger LOG = LogManager.getLogger(FormFormatterInterceptor.class);
    

	protected FormFormatter makeFormFormatLibrary() {
		return new DefaultFormFormatter();
	}

	
	public boolean getDisabled() {
		return disabled;
	}
	
	@Override
	public String intercept(ActionInvocation invocation) throws Exception {
        if (!disabled) {
        	invocation.addPreResultListener(new FormFormatterPreResultListener());
        }
        return invocation.invoke();
	}

	
	public void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}


}
