package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.CustomCollectionConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * Template class for client supplied converters to collection-based data types.  Subclasses must implement 
 * {@link #getRecipientClass}, {@link #format} and {@link #convert}.   
 */
public abstract class AbstractCustomCollectionConverterSupport<T> extends AbstractCollectionConverterSupport<CustomCollectionConversion,T> {
    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getProcessNoValue() {
    	return getAnnotation().processNoValue();
    }
    
}
