package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.BooleanConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class BooleanConverter extends AbstractConverterSupport<BooleanConversion,Boolean> {

    @Override
    public String format(Boolean unformattedValue) throws Exception {
        if (unformattedValue.booleanValue()) {
            return "1";
        } else {
            return "";
        }
    }

    @Override
    public Class<Boolean> getRecipientClass() {
        return Boolean.class;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.MESSAGE; // Ignored
    }

    @Override
    public String getMessage() {
        return "";  // Ignored
    }

    @Override
    public String getMessageKey() {
        return "";  // Ignored
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Boolean> convert(String fieldValue, Class<? extends Boolean> recipientClass) throws Exception {
        boolean parsedValue;
        char firstCharacter;
        
        parsedValue = false;
        if (fieldValue.length() > 0) {
	        firstCharacter = fieldValue.charAt(0);
	        switch (firstCharacter) {
	        case '1':
	        case 't':
	        case 'T':
	        case 'y':
	        case 'Y':
	            parsedValue = true;
	            break;
	        }
        }
        return ConversionResult.makeSuccessResult(parsedValue);
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
