package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.CharacterConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class CharacterConverter extends AbstractConverterSupport<CharacterConversion,Character> {

    @Override
    public String format(Character unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Character> getRecipientClass() {
        return Character.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Character> convert(String formValue, Class<? extends Character> recipientClass) throws Exception {
        char parsedValue;
        
        parsedValue = formValue.charAt(0);
        return ConversionResult.makeSuccessResult(parsedValue);
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
