package name.matthewgreet.strutscommons.policy;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

import name.matthewgreet.strutscommons.annotation.DateConversion;
import name.matthewgreet.strutscommons.annotation.DateConversion.Style;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import com.opensymphony.xwork2.ActionContext;

@SuppressWarnings("deprecation")
public class DateConverter extends AbstractConverterSupport<DateConversion,Date> {
    public static int getDateFormatStyle(Style style) {
        switch (style) {
        case FULL:      return DateFormat.FULL;
        case LONG:      return DateFormat.LONG;
        case MEDIUM:    return DateFormat.MEDIUM;
        case SHORT:     return DateFormat.SHORT;
        }
        return DateFormat.SHORT;
    }
    

    protected DateFormat makeDateFormat() {
        DateFormat result;
        Locale locale;
        
        if (getAnnotation().format().length() > 0) {
            result = new SimpleDateFormat(getAnnotation().format());
        } else if (getAnnotation().localeCountry().length() > 0 && getAnnotation().localeLanguage().length() > 0) {
            locale = new Locale(getAnnotation().localeLanguage(), getAnnotation().localeCountry());
            result = DateFormat.getDateInstance(getDateFormatStyle(getAnnotation().style()), locale);
        } else {
            locale = ActionContext.getContext().getLocale();
            result = DateFormat.getDateInstance(getDateFormatStyle(getAnnotation().style()), locale);
        }
        result.setLenient(false);
        result.setTimeZone(TimeZone.getTimeZone("UTC"));
        return result;
    }

    @Override
    public String format(Date unformattedValue) throws Exception {
        DateFormat formatter;
        
        formatter = makeDateFormat();
        return formatter.format(unformattedValue);
    }

    @Override
    public Class<Date> getRecipientClass() {
        return Date.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }
    
    @Override
    public ConversionResult<Date> convert(String formValue, Class<? extends Date> recipientClass) throws Exception {
        Date parsedValue;
        DateFormat formatter;
        
        try {
            formatter = makeDateFormat();
            parsedValue = formatter.parse(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (ParseException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
