package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.EnumConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

@SuppressWarnings("rawtypes")
public class EnumConverter extends AbstractConverterSupport<EnumConversion,Enum> {

    @Override
    public String format(Enum unformattedValue) throws Exception {
        return unformattedValue.name();
    }

    @Override
    public Class<Enum> getRecipientClass() {
        return Enum.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @SuppressWarnings("unchecked")
    @Override
    public ConversionResult<Enum> convert(String formValue, Class<? extends Enum> recipientClass) throws Exception {
        Enum parsedValue;
        
        try {
            parsedValue = Enum.valueOf(recipientClass, formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (IllegalArgumentException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
