package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.FloatConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class FloatConverter extends AbstractConverterSupport<FloatConversion,Float> {

    @Override
    public String format(Float unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Float> getRecipientClass() {
        return Float.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Float> convert(String formValue, Class<? extends Float> recipientClass) throws Exception {
    	float parsedValue;
        
        try {
            parsedValue = Float.parseFloat(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
