package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor2;


/**
 * Interface for form field validators used by {@link AnnotationValidationInterceptor} and 
 * {@link AnnotationValidationInterceptor2} that don't convert from string 
 * values. 
 */
@SuppressWarnings("deprecation")
public interface NonConversionValidator<A extends Annotation> extends Policy<A> {
    /**
     * Returns whether to write any error message to action errors, field errors, or action messages. 
     */
    public MessageType getMessageType();
    
    /**
     * Returns message set by annotation.  Used if {@link #getMessageKey} is empty string or it fails to find a message. 
     */
    public String getMessage();
    
    /**
     * Returns message key set by annotation, which is used to retrieve message from Action's TextProvider if it's not 
     * empty string. 
     */
    public String getMessageKey();
    
    /**
     * Returns whether rejection by this validator should stop further validation. 
     */
    public boolean getShortCircuit();
    
    /**
     * Returns whether validator should not be skipped if the form field value is empty string. 
     */
    public boolean getProcessNoValue();
    
    /**
     * Returns result of validation of form field. 
     */
    public ValidationResult validate(String fieldValue) throws Exception;
    
}
