package name.matthewgreet.strutscommons.policy;

import java.util.Collection;
import name.matthewgreet.strutscommons.annotation.StringCSVConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class StringCSVConverter extends AbstractCollectionConverterSupport<StringCSVConversion,String> {

    @Override
    public String format(Collection<String> unformattedValues) throws Exception {
        String result, value;
        
        result = "";
        for (Object rawValue: unformattedValues) {
            value = (String)rawValue;
            if (result.length() > 0) {
                result = result + getAnnotation().separator();
            }
            result = result + value;
        }
        return result;
    }

    @Override
    public Class<String> getRecipientClass() {
        return String.class;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.MESSAGE; // Ignored
    }

    @Override
    public String getMessage() {
        return "";  // Ignored
    }

    @Override
    public String getMessageKey() {
        return "";  // Ignored
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<String> convert(String formValue, Class<?> recipientFieldClass, Class<? extends String> recipientClass) throws Exception {
        Collection<String> parsedValue;
        String[] values;
        String workingValue;
        
        parsedValue = makeCollectionForRecipient(recipientFieldClass);
        values = formValue.split(getAnnotation().separator(), -1);
        for (String value: values) {
        	if (formValue.trim().length() > 0) {
	            workingValue = value;
	            if (getAnnotation().trim()) {
	                workingValue = workingValue.trim();
	            }
	            parsedValue.add(workingValue);
        	}
        }
        return ConversionResult.makeSuccessCollectionResult(parsedValue);
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
