package name.matthewgreet.strutscommons.util;

import java.io.Serializable;
import java.util.Collection;

/**
 * <P>Strategy for lazy loading a page of records to display from their ids (or other unique key), typically found by a 
 * paired {@link IdListFinder} instance.</P>
 */
@FunctionalInterface
public interface PageByIdsFinder<K extends Serializable,T extends Serializable> extends Serializable {
    
    /**
     * Returns items from their ids.  If any records are missing, the successfully retrieved ones must still be 
     * returned.  No item should ever be null.
     */
    public Collection<T> getItems(Collection<K> keys) throws Exception;
    
    /**
     * Returns true if finder eager loads any optional details of each item.  This is usually false as loading
     * details results in poor performance or there are no optional details.  
     */
    default public boolean getLoadsDetails() {
        return false;
    }
}
