package name.matthewgreet.strutscommons.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map.Entry;

import name.matthewgreet.strutscommons.action.BrowserTabSession;
import name.matthewgreet.strutscommons.util.AbstractCompositeCache;
import name.matthewgreet.strutscommons.util.ListCache;

/**
 * Unused.
 * 
 * @param <T>
 */
public abstract class AbstractListCacheBasedDisplay<T extends Serializable> {
	private ListCache<?,?,T> listCache;
	private int recordNo;
	private int listSize;
	private int pageNo;
	private int pageSize;
	private int totalPages;

	private BrowserTabSession browserTabSession;
	private Class<? extends AbstractCompositeCache<?,T>> compositeCacheClass;
	private String tabId;
	private boolean siblingTabCountAvailable;
	private int siblingTabSize;
	private int siblingTabNo;
	
	public AbstractListCacheBasedDisplay(ListCache<?,?,T> listCache) {
		this.listCache = listCache;
	}
	
	
	public void init() throws Exception {
		boolean found;
		
		List<String> tabIds;
		recordNo = listCache.getSelectedIndex() + 1;
		listSize = listCache.getListSize();
		pageNo = listCache.getPageNo();
		pageSize = listCache.getPageSize();
		totalPages = listCache.getTotalPages();
		
		siblingTabCountAvailable = browserTabSession != null && compositeCacheClass != null && tabId != null;
		if (siblingTabCountAvailable) {
			siblingTabSize = 0;
			tabIds = new ArrayList<>(browserTabSession.getAllTabIds());
			Collections.sort(tabIds);	// Tab ids are datetime of creation
			for (String otherTabId: tabIds) {
				found = false;
				for (Entry<String,Object> entry: browserTabSession.getPrivateAttributeMap().entrySet()) {
					if (entry.getValue().getClass().isAssignableFrom(compositeCacheClass)) {
						found = true;
						continue;
					}
				}
				if (found) {
					siblingTabSize++;
					if (otherTabId.equals(tabId)) {
						siblingTabNo = siblingTabSize;
					}
				}
			}
		}
		return;
	}
	
	
	/**
	 * Sets all session data, class of composite cache used by sibling tabs, and tab id of this tab.  This must be 
	 * called before {@link #init}.
	 */
	public void setBrowserTabSessionData(BrowserTabSession browserTabSession, Class<? extends AbstractCompositeCache<?,T>> compositeCacheClass, 
			String tabId) {
		this.browserTabSession = browserTabSession;
		this.compositeCacheClass = compositeCacheClass;
        this.tabId = tabId;
	}
	
	
	protected ListCache<?, ?, T> getListCache() {
		return listCache;
	}
	public int getRecordNo() {
		return recordNo;
	}
	public int getListSize() {
		return listSize;
	}
	public int getPageNo() {
		return pageNo;
	}
	public int getPageSize() {
		return pageSize;
	}
	public int getTotalPages() {
		return totalPages;
	}
	
	public int getPageStartRecordNo() {
		return (pageNo - 1) * pageSize + 1;
	}


	/**
	 * If true, the number of browser tabs displaying pages of the same app but independent, per-tab search results are counted 
	 * and known. 
	 */
	public boolean getSiblingTabCountAvailable() {
		return siblingTabCountAvailable;
	}
	
	/**
	 * Returns the number of browser tabs displaying pages of the same app but independent, per-tab search results.  
	 * This is not perfect as users can close tabs, leaving its per-tab session data hanging around. 
	 */
	public int getSiblingTabSize() {
		return siblingTabSize;
	}
	
	/**
	 * Returns position of this tab among list of sibling tabs, browser tabs displaying pages of the same app but 
	 * independent, per-tab search results.  First is 1.  
	 */
	public int getSiblingTabNo() {
		return siblingTabNo;
	}
	
}
