package name.matthewgreet.strutscommons.view;

import java.util.Comparator;

/**
 * <P>Concrete subclass of {@link SingleSelectBoxDisplay} that formats list of numbers for display in an HTML select 
 * box.  The raw list, as set in the <CODE>model</CODE> property, should be a collection of <CODE>Integer</CODE>. See
 * {@link SingleSelectBoxDisplay}.</P>
 *
 * 
 * @deprecated Designed for forms using formatted/unformatted field pairs (pair conversion mode) and less useful for 
 * form fields set using auto conversion or default conversion mode.  Use {@link IntegerListSelectBoxDisplay2} as 
 * the base template and {@link IntegerListSelectBoxDisplay2#setSelectedFormattedValue} to set the selected item 
 * from the formatted half of a formatted/unformatted field pair.
 * 
 * @deprecated Designed for forms using formatted/unformatted field pairs (pair conversion mode) and less useful for 
 * form fields set using auto conversion or default conversion mode.  Use {@link IntegerListSelectBoxDisplay2} as the 
 * base template and {@link IntegerListSelectBoxDisplay2#setSelectedFormattedValue} to set the selected item from the 
 * formatted half of a formatted/unformatted field pair.
 */
public class IntegerListSelectBoxDisplay extends SingleSelectBoxDisplay<Integer> {
    public class NumberComparator implements Comparator<SelectBoxItemDisplay<Integer>> {
        public int compare(SelectBoxItemDisplay<Integer> o1, SelectBoxItemDisplay<Integer> o2) {
            Integer item1, item2;
            
            item1 = o1.getData();
            item2 = o2.getData();
            return item1.compareTo(item2);
        }
    }

    /**
     * Returns comparator that compares number items by value.  May be
     * overridden for a different order.
     */
    @Override
    protected Comparator<SelectBoxItemDisplay<Integer>> getSortComparator() {
        return new NumberComparator();
    }
    /**
     * Converts number to select box item value.
     */
    @Override
    protected String getValue(Integer item) {
        return item.toString();
    }

    /**
     * Converts number to select box item display text.
     */
    @Override
    protected String getText(Integer item) {
        return item.toString();
    }

}
