package name.matthewgreet.strutscommons.junit.defaultannotationvalidator;

import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionEventListener;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.util.ValueStack;

@SuppressWarnings("deprecation")
public class MockActionInvocaton implements ActionInvocation {
	private Action action;
	private ActionContext actionContext;
	private ValueStack valueStack;
	
	public MockActionInvocaton(Action action, ActionContext actionContext, ValueStack valueStack) {
		this.action = action;
		this.actionContext = actionContext;
		this.valueStack = valueStack;
	}
	
	
	@Override
	public Object getAction() {
		return action;
	}

	@Override
	public boolean isExecuted() {
		return false;
	}

	@Override
	public String getResultCode() {
		return null;
	}

	@Override
	public void setResultCode(String resultCode) {
		// Not used
	}

	@Override
	public String invoke() throws Exception {
		return null;
	}

	@Override
	public String invokeActionOnly() throws Exception {
		return null;
	}

	@Override
	public ActionContext getInvocationContext() {
		return actionContext;
	}

	@Override
	public Result getResult() throws Exception {
		return null;
	}

	@Override
	public ActionProxy getProxy() {
		return null;
	}

	@Override
	public ValueStack getStack() {
		return valueStack;
	}

	@Override
	public void addPreResultListener(PreResultListener listener) {
		// Not used
	}

	@Override
	public void setActionEventListener(ActionEventListener listener) {
		// Not used
	}

	@Override
	public void init(ActionProxy proxy) {
		// Not used
	}

}
