package name.matthewgreet.strutscommons.junit.library;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.interceptor.ValidationAware;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import com.opensymphony.xwork2.util.ValueStack;

import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.AutoConversionAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.AutoConversionForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.AutoConversionRequiredAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.AutoConversionRequiredForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.DefaultConversionAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.DefaultConversionForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.DefaultConversionRequiredAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.DefaultConversionRequiredForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.MockActionInvocaton;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.PairConversionRequiredAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.PairConversionRequiredForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.SetOnlyAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.SetOnlyForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.ValidationAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.ValidationForm;
import name.matthewgreet.strutscommons.junit.util.JUnitLibrary;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.MockValueStack;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.NoConversionAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.NoConversionForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.PairConversionAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.PairConversionForm;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.PairConversionForm.Colour;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.PairConversionMissingHalfAction;
import name.matthewgreet.strutscommons.junit.defaultannotationvalidator.PairConversionMissingHalfForm;
import name.matthewgreet.strutscommons.util.DefaultAnnotationValidatior;

@SuppressWarnings("deprecation")
public class DefaultAnnotationValidatorUnitTests {
	@BeforeEach
	public void init() {
		ActionContext actionContext;
		
		ActionContext.bind(ActionContext.of(new HashMap<>()));
		actionContext = ActionContext.getContext();
		actionContext.withSession(new HashMap<>());
	}
	
	
	@DisplayName("Validates a form based on pair conversion")
	@Test
	public void testValidatePair1() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		PairConversionAction action;
		PairConversionForm pairConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new PairConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "12.9");
		parameters.put("primitiveBooleanField", "1");
		parameters.put("objectBooleanField", "1");
		parameters.put("primitiveByteField", "127");
		parameters.put("objectByteField", "127");
		parameters.put("primitiveCharField", "^");
		parameters.put("objectCharacterField", "^");
		parameters.put("dateField", "10/12/1993");
		parameters.put("primitiveDoubleField", "-8.23");
		parameters.put("objectDoubleField", "-8.23");
		parameters.put("enumField", "RED");
		parameters.put("primitiveFloatField", "-8.23");
		parameters.put("objectFloatField", "-8.23");
		parameters.put("primitiveIntField", "10000");
		parameters.put("objectIntegerField", "10000");
		parameters.put("primitiveLongField", "999999");
		parameters.put("objectLongField", "999999");
		parameters.put("primitiveShortField", "4455");
		parameters.put("objectShortField", "4455");
		parameters.put("customField", "10.99");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		pairConversionForm = action.getModel();
		Assertions.assertEquals("12.9", pairConversionForm.getBigDecimalField(), "BigDecimal setting failed");
		Assertions.assertEquals(new BigDecimal("12.9"), pairConversionForm.getParsedBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals("1", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean setting failed");
		Assertions.assertEquals(true, pairConversionForm.getParsedPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals("1", pairConversionForm.getObjectBooleanField(), "Object boolean setting failed");
		Assertions.assertEquals(true, pairConversionForm.getParsedObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals("127", pairConversionForm.getPrimitiveByteField(), "Primitive byte setting failed");
		Assertions.assertEquals(127, pairConversionForm.getParsedPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals("127", pairConversionForm.getObjectByteField(), "Object byte setting failed");
		Assertions.assertEquals((byte)127, pairConversionForm.getParsedObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals("^", pairConversionForm.getPrimitiveCharField(), "Primitive char setting failed");
		Assertions.assertEquals('^', pairConversionForm.getParsedPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals("^", pairConversionForm.getObjectCharacterField(), "Object char setting failed");
		Assertions.assertEquals('^', pairConversionForm.getParsedObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals("10/12/1993", pairConversionForm.getDateField(), "Date setting failed");
		Assertions.assertEquals((new GregorianCalendar(1993,11,10).getTime()), pairConversionForm.getParsedDateField(), "Date conversion failed");
		Assertions.assertEquals("-8.23", pairConversionForm.getPrimitiveDoubleField(), "Primitive double setting failed");
		Assertions.assertEquals(-8.23, pairConversionForm.getParsedObjectDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals("-8.23", pairConversionForm.getObjectDoubleField(), "Object double setting failed");
		Assertions.assertEquals(-8.23, pairConversionForm.getParsedObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals("RED", pairConversionForm.getEnumField(), "Enum setting failed");
		Assertions.assertEquals(Colour.RED, pairConversionForm.getParsedEnumField(), "Enum conversion failed");
		Assertions.assertEquals("-8.23", pairConversionForm.getPrimitiveFloatField(), "Primitive float setting failed");
		Assertions.assertEquals((float)-8.23, pairConversionForm.getParsedObjectFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals("-8.23", pairConversionForm.getObjectFloatField(), "Object float setting failed");
		Assertions.assertEquals((float)-8.23, pairConversionForm.getParsedObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals("10000", pairConversionForm.getPrimitiveIntField(), "Primitive int setting failed");
		Assertions.assertEquals(10000, pairConversionForm.getParsedPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals("10000", pairConversionForm.getObjectIntegerField(), "Object integer setting failed");
		Assertions.assertEquals(10000, pairConversionForm.getParsedObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals("999999", pairConversionForm.getPrimitiveLongField(), "Primitive long setting failed");
		Assertions.assertEquals(999999, pairConversionForm.getParsedPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals("999999", pairConversionForm.getObjectLongField(), "Object long setting failed");
		Assertions.assertEquals(999999, pairConversionForm.getParsedObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals("4455", pairConversionForm.getPrimitiveShortField(), "Primitive short setting failed");
		Assertions.assertEquals((short)4455, pairConversionForm.getParsedPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals("4455", pairConversionForm.getObjectShortField(), "Object short setting failed");
		Assertions.assertEquals((short)4455, pairConversionForm.getParsedObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals("10.99", pairConversionForm.getCustomField(), "Custom setting failed");
		Assertions.assertEquals(1099, pairConversionForm.getParsedCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on pair conversion but empty string values")
	@Test
	public void testValidatePair2() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		PairConversionAction action;
		PairConversionForm pairConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new PairConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "");
		parameters.put("primitiveBooleanField", "");
		parameters.put("objectBooleanField", "");
		parameters.put("primitiveByteField", "");
		parameters.put("objectByteField", "");
		parameters.put("primitiveCharField", "");
		parameters.put("objectCharacterField", "");
		parameters.put("dateField", "");
		parameters.put("primitiveDoubleField", "");
		parameters.put("objectDoubleField", "");
		parameters.put("enumField", "");
		parameters.put("primitiveFloatField", "");
		parameters.put("objectFloatField", "");
		parameters.put("primitiveIntField", "");
		parameters.put("objectIntegerField", "");
		parameters.put("primitiveLongField", "");
		parameters.put("objectLongField", "");
		parameters.put("primitiveShortField", "");
		parameters.put("objectShortField", "");
		parameters.put("customField", "");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		pairConversionForm = action.getModel();
		Assertions.assertEquals("", pairConversionForm.getBigDecimalField(), "BigDecimal setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean setting failed");
		Assertions.assertEquals(false, pairConversionForm.getParsedPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectBooleanField(), "Object boolean setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveByteField(), "Primitive byte setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectByteField(), "Object byte setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveCharField(), "Primitive char setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectCharacterField(), "Object char setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals("", pairConversionForm.getDateField(), "Date setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedDateField(), "Date conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveDoubleField(), "Primitive double setting failed");
		Assertions.assertEquals(0.0, pairConversionForm.getParsedPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectDoubleField(), "Object double setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals("", pairConversionForm.getEnumField(), "Enum setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedEnumField(), "Enum conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveFloatField(), "Primitive float setting failed");
		Assertions.assertEquals((float)0.0, pairConversionForm.getParsedPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectFloatField(), "Object float setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveIntField(), "Primitive int setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectIntegerField(), "Object integer setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveLongField(), "Primitive long setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectLongField(), "Object long setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveShortField(), "Primitive short setting failed");
		Assertions.assertEquals((short)0, pairConversionForm.getParsedPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectShortField(), "Object short setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals("", pairConversionForm.getCustomField(), "Custom setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on pair conversion but missing parameters")
	@Test
	public void testValidatePair3() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		PairConversionAction action;
		PairConversionForm pairConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new PairConversionAction();
		
		parameters = new HashMap<>();
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		pairConversionForm = action.getModel();
		Assertions.assertEquals("", pairConversionForm.getBigDecimalField(), "BigDecimal setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean setting failed");
		Assertions.assertEquals(false, pairConversionForm.getParsedPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectBooleanField(), "Object boolean setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveByteField(), "Primitive byte setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectByteField(), "Object byte setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveCharField(), "Primitive char setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectCharacterField(), "Object char setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals("", pairConversionForm.getDateField(), "Date setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedDateField(), "Date conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveDoubleField(), "Primitive double setting failed");
		Assertions.assertEquals(0.0, pairConversionForm.getParsedPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectDoubleField(), "Object double setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals("", pairConversionForm.getEnumField(), "Enum setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedEnumField(), "Enum conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveFloatField(), "Primitive float setting failed");
		Assertions.assertEquals((float)0.0, pairConversionForm.getParsedPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectFloatField(), "Object float setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveIntField(), "Primitive int setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectIntegerField(), "Object integer setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveLongField(), "Primitive long setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectLongField(), "Object long setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveShortField(), "Primitive short setting failed");
		Assertions.assertEquals((short)0, pairConversionForm.getParsedPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectShortField(), "Object short setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals("", pairConversionForm.getCustomField(), "Custom setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on pair conversion but conversions fail")
	@Test
	public void testValidatePair4() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		PairConversionAction action;
		PairConversionForm pairConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new PairConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "1x");
		parameters.put("primitiveBooleanField", "2x");
		parameters.put("objectBooleanField", "3x");
		parameters.put("primitiveByteField", "4x");
		parameters.put("objectByteField", "5x");
		parameters.put("primitiveCharField", "6x");
		parameters.put("objectCharacterField", "7x");
		parameters.put("dateField", "8x");
		parameters.put("primitiveDoubleField", "9x");
		parameters.put("objectDoubleField", "10x");
		parameters.put("enumField", "11x");
		parameters.put("primitiveFloatField", "12x");
		parameters.put("objectFloatField", "13x");
		parameters.put("primitiveIntField", "14x");
		parameters.put("objectIntegerField", "15x");
		parameters.put("primitiveLongField", "16x");
		parameters.put("objectLongField", "17x");
		parameters.put("primitiveShortField", "18x");
		parameters.put("objectShortField", "19x");
		parameters.put("customField", "20x");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		pairConversionForm = action.getModel();
		Assertions.assertEquals("1x", pairConversionForm.getBigDecimalField(), "BigDecimal setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals("2x", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean setting failed");
		Assertions.assertEquals(false, pairConversionForm.getParsedPrimitiveBooleanField(), "Primitive boolean conversion failed");	// No invalid values exist
		Assertions.assertEquals("3x", pairConversionForm.getObjectBooleanField(), "Object boolean setting failed");
		Assertions.assertEquals(false, pairConversionForm.getParsedObjectBooleanField(), "Object boolean conversion failed");		// No invalid values exist
		Assertions.assertEquals("4x", pairConversionForm.getPrimitiveByteField(), "Primitive byte setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals("5x", pairConversionForm.getObjectByteField(), "Object byte setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals("6x", pairConversionForm.getPrimitiveCharField(), "Primitive char setting failed");
		Assertions.assertEquals('6', pairConversionForm.getParsedPrimitiveCharField(), "Primitive char conversion failed");			// No invalid values exist
		Assertions.assertEquals("7x", pairConversionForm.getObjectCharacterField(), "Object char setting failed");
		Assertions.assertEquals('7', pairConversionForm.getParsedObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals("8x", pairConversionForm.getDateField(), "Date setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedDateField(), "Date conversion failed");
		Assertions.assertEquals("9x", pairConversionForm.getPrimitiveDoubleField(), "Primitive double setting failed");
		Assertions.assertEquals(0.0, pairConversionForm.getParsedPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals("10x", pairConversionForm.getObjectDoubleField(), "Object double setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals("11x", pairConversionForm.getEnumField(), "Enum setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedEnumField(), "Enum conversion failed");
		Assertions.assertEquals("12x", pairConversionForm.getPrimitiveFloatField(), "Primitive float setting failed");
		Assertions.assertEquals((float)0.0, pairConversionForm.getParsedPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals("13x", pairConversionForm.getObjectFloatField(), "Object float setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals("14x", pairConversionForm.getPrimitiveIntField(), "Primitive int setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals("15x", pairConversionForm.getObjectIntegerField(), "Object integer setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals("16x", pairConversionForm.getPrimitiveLongField(), "Primitive long setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals("17x", pairConversionForm.getObjectLongField(), "Object long setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals("18x", pairConversionForm.getPrimitiveShortField(), "Primitive short setting failed");
		Assertions.assertEquals((short)0, pairConversionForm.getParsedPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals("19x", pairConversionForm.getObjectShortField(), "Object short setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals("20x", pairConversionForm.getCustomField(), "Custom setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(16, validationAware.getActionErrors().size(), "All conversions except boolean and char should write error messages");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal conversion failed", "Byte conversion failed", 
				"Byte conversion failed", "Date conversion failed", "Double conversion failed", "Double conversion failed", 
				"Enum conversion failed", "Float conversion failed", "Float conversion failed", "Integer conversion failed", 
				"Integer conversion failed", "Long conversion failed", "Long conversion failed", "Short conversion failed", 
				"Short conversion failed",	"Price is not a number"), 
				new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on pair conversion, each pair required")
	@Test
	public void testValidatePair5() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		PairConversionRequiredAction action;
		PairConversionRequiredForm pairConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new PairConversionRequiredAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "12.9");
		parameters.put("primitiveBooleanField", "1");
		parameters.put("objectBooleanField", "1");
		parameters.put("primitiveByteField", "127");
		parameters.put("objectByteField", "127");
		parameters.put("primitiveCharField", "^");
		parameters.put("objectCharacterField", "^");
		parameters.put("dateField", "10/12/1993");
		parameters.put("primitiveDoubleField", "-8.23");
		parameters.put("objectDoubleField", "-8.23");
		parameters.put("enumField", "RED");
		parameters.put("primitiveFloatField", "-8.23");
		parameters.put("objectFloatField", "-8.23");
		parameters.put("primitiveIntField", "10000");
		parameters.put("objectIntegerField", "10000");
		parameters.put("primitiveLongField", "999999");
		parameters.put("objectLongField", "999999");
		parameters.put("primitiveShortField", "4455");
		parameters.put("objectShortField", "4455");
		parameters.put("customField", "10.99");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		pairConversionForm = action.getModel();
		Assertions.assertEquals("12.9", pairConversionForm.getBigDecimalField(), "BigDecimal setting failed");
		Assertions.assertEquals(new BigDecimal("12.9"), pairConversionForm.getParsedBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals("1", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean setting failed");
		Assertions.assertEquals(true, pairConversionForm.getParsedPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals("1", pairConversionForm.getObjectBooleanField(), "Object boolean setting failed");
		Assertions.assertEquals(true, pairConversionForm.getParsedObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals("127", pairConversionForm.getPrimitiveByteField(), "Primitive byte setting failed");
		Assertions.assertEquals(127, pairConversionForm.getParsedPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals("127", pairConversionForm.getObjectByteField(), "Object byte setting failed");
		Assertions.assertEquals((byte)127, pairConversionForm.getParsedObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals("^", pairConversionForm.getPrimitiveCharField(), "Primitive char setting failed");
		Assertions.assertEquals('^', pairConversionForm.getParsedPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals("^", pairConversionForm.getObjectCharacterField(), "Object char setting failed");
		Assertions.assertEquals('^', pairConversionForm.getParsedObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals("10/12/1993", pairConversionForm.getDateField(), "Date setting failed");
		Assertions.assertEquals((new GregorianCalendar(1993,11,10).getTime()), pairConversionForm.getParsedDateField(), "Date conversion failed");
		Assertions.assertEquals("-8.23", pairConversionForm.getPrimitiveDoubleField(), "Primitive double setting failed");
		Assertions.assertEquals(-8.23, pairConversionForm.getParsedObjectDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals("-8.23", pairConversionForm.getObjectDoubleField(), "Object double setting failed");
		Assertions.assertEquals(-8.23, pairConversionForm.getParsedObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals("RED", pairConversionForm.getEnumField(), "Enum setting failed");
		Assertions.assertEquals(Colour.RED, pairConversionForm.getParsedEnumField(), "Enum conversion failed");
		Assertions.assertEquals("-8.23", pairConversionForm.getPrimitiveFloatField(), "Primitive float setting failed");
		Assertions.assertEquals((float)-8.23, pairConversionForm.getParsedObjectFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals("-8.23", pairConversionForm.getObjectFloatField(), "Object float setting failed");
		Assertions.assertEquals((float)-8.23, pairConversionForm.getParsedObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals("10000", pairConversionForm.getPrimitiveIntField(), "Primitive int setting failed");
		Assertions.assertEquals(10000, pairConversionForm.getParsedPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals("10000", pairConversionForm.getObjectIntegerField(), "Object integer setting failed");
		Assertions.assertEquals(10000, pairConversionForm.getParsedObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals("999999", pairConversionForm.getPrimitiveLongField(), "Primitive long setting failed");
		Assertions.assertEquals(999999, pairConversionForm.getParsedPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals("999999", pairConversionForm.getObjectLongField(), "Object long setting failed");
		Assertions.assertEquals(999999, pairConversionForm.getParsedObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals("4455", pairConversionForm.getPrimitiveShortField(), "Primitive short setting failed");
		Assertions.assertEquals((short)4455, pairConversionForm.getParsedPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals("4455", pairConversionForm.getObjectShortField(), "Object short setting failed");
		Assertions.assertEquals((short)4455, pairConversionForm.getParsedObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals("10.99", pairConversionForm.getCustomField(), "Custom setting failed");
		Assertions.assertEquals(1099, pairConversionForm.getParsedCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on pair conversion and required fields but empty string values")
	@Test
	public void testValidatePair6() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		PairConversionRequiredAction action;
		PairConversionRequiredForm pairConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new PairConversionRequiredAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "");
		parameters.put("primitiveBooleanField", "");
		parameters.put("objectBooleanField", "");
		parameters.put("primitiveByteField", "");
		parameters.put("objectByteField", "");
		parameters.put("primitiveCharField", "");
		parameters.put("objectCharacterField", "");
		parameters.put("dateField", "");
		parameters.put("primitiveDoubleField", "");
		parameters.put("objectDoubleField", "");
		parameters.put("enumField", "");
		parameters.put("primitiveFloatField", "");
		parameters.put("objectFloatField", "");
		parameters.put("primitiveIntField", "");
		parameters.put("objectIntegerField", "");
		parameters.put("primitiveLongField", "");
		parameters.put("objectLongField", "");
		parameters.put("primitiveShortField", "");
		parameters.put("objectShortField", "");
		parameters.put("customField", "");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		pairConversionForm = action.getModel();
		Assertions.assertEquals("", pairConversionForm.getBigDecimalField(), "BigDecimal setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean setting failed");
		Assertions.assertEquals(false, pairConversionForm.getParsedPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectBooleanField(), "Object boolean setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveByteField(), "Primitive byte setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectByteField(), "Object byte setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveCharField(), "Primitive char setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectCharacterField(), "Object char setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals("", pairConversionForm.getDateField(), "Date setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedDateField(), "Date conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveDoubleField(), "Primitive double setting failed");
		Assertions.assertEquals(0.0, pairConversionForm.getParsedPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectDoubleField(), "Object double setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals("", pairConversionForm.getEnumField(), "Enum setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedEnumField(), "Enum conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveFloatField(), "Primitive float setting failed");
		Assertions.assertEquals((float)0.0, pairConversionForm.getParsedPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectFloatField(), "Object float setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveIntField(), "Primitive int setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectIntegerField(), "Object integer setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveLongField(), "Primitive long setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectLongField(), "Object long setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveShortField(), "Primitive short setting failed");
		Assertions.assertEquals((short)0, pairConversionForm.getParsedPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectShortField(), "Object short setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals("", pairConversionForm.getCustomField(), "Custom setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(20, validationAware.getActionErrors().size(), "All fields should be rejected as they're required");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal required",	"Boolean required",	
				"Boolean required",	"Byte required", "Byte required", "Character required",	"Character required", 
				"Date required", "Double required", "Double required", "Enum required", "Float required", "Float required",
				"Integer required",	"Integer required",	"Long required", "Long required", "Short required", "Short required",
				"Price is required"), new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on pair conversion and required fields but missing parameters")
	@Test
	public void testValidatePair7() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		PairConversionRequiredAction action;
		PairConversionRequiredForm pairConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new PairConversionRequiredAction();
		
		parameters = new HashMap<>();
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		pairConversionForm = action.getModel();
		Assertions.assertEquals("", pairConversionForm.getBigDecimalField(), "BigDecimal setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean setting failed");
		Assertions.assertEquals(false, pairConversionForm.getParsedPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectBooleanField(), "Object boolean setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveByteField(), "Primitive byte setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectByteField(), "Object byte setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveCharField(), "Primitive char setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectCharacterField(), "Object char setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals("", pairConversionForm.getDateField(), "Date setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedDateField(), "Date conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveDoubleField(), "Primitive double setting failed");
		Assertions.assertEquals(0.0, pairConversionForm.getParsedPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectDoubleField(), "Object double setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals("", pairConversionForm.getEnumField(), "Enum setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedEnumField(), "Enum conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveFloatField(), "Primitive float setting failed");
		Assertions.assertEquals((float)0.0, pairConversionForm.getParsedPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectFloatField(), "Object float setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveIntField(), "Primitive int setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectIntegerField(), "Object integer setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveLongField(), "Primitive long setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectLongField(), "Object long setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals("", pairConversionForm.getPrimitiveShortField(), "Primitive short setting failed");
		Assertions.assertEquals((short)0, pairConversionForm.getParsedPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals("", pairConversionForm.getObjectShortField(), "Object short setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals("", pairConversionForm.getCustomField(), "Custom setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(20, validationAware.getActionErrors().size(), "All fields should be rejected as they're required");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal required",	"Boolean required",	
				"Boolean required",	"Byte required", "Byte required", "Character required",	"Character required", 
				"Date required", "Double required", "Double required", "Enum required", "Float required", "Float required",
				"Integer required",	"Integer required",	"Long required", "Long required", "Short required", "Short required",
				"Price is required"), new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on pair conversion and required fields but conversions fail")
	@Test
	public void testValidatePair8() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		PairConversionRequiredAction action;
		PairConversionRequiredForm pairConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new PairConversionRequiredAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "1x");
		parameters.put("primitiveBooleanField", "2x");
		parameters.put("objectBooleanField", "3x");
		parameters.put("primitiveByteField", "4x");
		parameters.put("objectByteField", "5x");
		parameters.put("primitiveCharField", "6x");
		parameters.put("objectCharacterField", "7x");
		parameters.put("dateField", "8x");
		parameters.put("primitiveDoubleField", "9x");
		parameters.put("objectDoubleField", "10x");
		parameters.put("enumField", "11x");
		parameters.put("primitiveFloatField", "12x");
		parameters.put("objectFloatField", "13x");
		parameters.put("primitiveIntField", "14x");
		parameters.put("objectIntegerField", "15x");
		parameters.put("primitiveLongField", "16x");
		parameters.put("objectLongField", "17x");
		parameters.put("primitiveShortField", "18x");
		parameters.put("objectShortField", "19x");
		parameters.put("customField", "20x");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		pairConversionForm = action.getModel();
		Assertions.assertEquals("1x", pairConversionForm.getBigDecimalField(), "BigDecimal setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals("2x", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean setting failed");
		Assertions.assertEquals(false, pairConversionForm.getParsedPrimitiveBooleanField(), "Primitive boolean conversion failed");	// No invalid values exist
		Assertions.assertEquals("3x", pairConversionForm.getObjectBooleanField(), "Object boolean setting failed");
		Assertions.assertEquals(false, pairConversionForm.getParsedObjectBooleanField(), "Object boolean conversion failed");		// No invalid values exist
		Assertions.assertEquals("4x", pairConversionForm.getPrimitiveByteField(), "Primitive byte setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals("5x", pairConversionForm.getObjectByteField(), "Object byte setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals("6x", pairConversionForm.getPrimitiveCharField(), "Primitive char setting failed");
		Assertions.assertEquals('6', pairConversionForm.getParsedPrimitiveCharField(), "Primitive char conversion failed");			// No invalid values exist
		Assertions.assertEquals("7x", pairConversionForm.getObjectCharacterField(), "Object char setting failed");
		Assertions.assertEquals('7', pairConversionForm.getParsedObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals("8x", pairConversionForm.getDateField(), "Date setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedDateField(), "Date conversion failed");
		Assertions.assertEquals("9x", pairConversionForm.getPrimitiveDoubleField(), "Primitive double setting failed");
		Assertions.assertEquals(0.0, pairConversionForm.getParsedPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals("10x", pairConversionForm.getObjectDoubleField(), "Object double setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals("11x", pairConversionForm.getEnumField(), "Enum setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedEnumField(), "Enum conversion failed");
		Assertions.assertEquals("12x", pairConversionForm.getPrimitiveFloatField(), "Primitive float setting failed");
		Assertions.assertEquals((float)0.0, pairConversionForm.getParsedPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals("13x", pairConversionForm.getObjectFloatField(), "Object float setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals("14x", pairConversionForm.getPrimitiveIntField(), "Primitive int setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals("15x", pairConversionForm.getObjectIntegerField(), "Object integer setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals("16x", pairConversionForm.getPrimitiveLongField(), "Primitive long setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals("17x", pairConversionForm.getObjectLongField(), "Object long setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals("18x", pairConversionForm.getPrimitiveShortField(), "Primitive short setting failed");
		Assertions.assertEquals((short)0, pairConversionForm.getParsedPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals("19x", pairConversionForm.getObjectShortField(), "Object short setting failed");
		Assertions.assertEquals(null, pairConversionForm.getParsedObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals("20x", pairConversionForm.getCustomField(), "Custom setting failed");
		Assertions.assertEquals(0, pairConversionForm.getParsedCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(16, validationAware.getActionErrors().size(), "All conversions except boolean and char should write error messages");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal conversion failed", "Byte conversion failed", 
				"Byte conversion failed", "Date conversion failed", "Double conversion failed", "Double conversion failed", 
				"Enum conversion failed", "Float conversion failed", "Float conversion failed", "Integer conversion failed", 
				"Integer conversion failed", "Long conversion failed", "Long conversion failed", "Short conversion failed", 
				"Short conversion failed",	"Price is not a number"), 
				new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Ignores a form based on pair conversion but the unformatted fields are missing")
	@Test
	public void testValidatePair9() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		PairConversionMissingHalfAction action;
		PairConversionMissingHalfForm pairConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new PairConversionMissingHalfAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "1x");
		parameters.put("primitiveBooleanField", "2x");
		parameters.put("objectBooleanField", "3x");
		parameters.put("primitiveByteField", "4x");
		parameters.put("objectByteField", "5x");
		parameters.put("primitiveCharField", "6x");
		parameters.put("objectCharacterField", "7x");
		parameters.put("dateField", "8x");
		parameters.put("primitiveDoubleField", "9x");
		parameters.put("objectDoubleField", "10x");
		parameters.put("enumField", "11x");
		parameters.put("primitiveFloatField", "12x");
		parameters.put("objectFloatField", "13x");
		parameters.put("primitiveIntField", "14x");
		parameters.put("objectIntegerField", "15x");
		parameters.put("primitiveLongField", "16x");
		parameters.put("objectLongField", "17x");
		parameters.put("primitiveShortField", "18x");
		parameters.put("objectShortField", "19x");
		parameters.put("customField", "20x");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		pairConversionForm = action.getModel();
		Assertions.assertEquals("1x", pairConversionForm.getBigDecimalField(), "BigDecimal setting failed");
		Assertions.assertEquals("2x", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean setting failed");
		Assertions.assertEquals("3x", pairConversionForm.getObjectBooleanField(), "Object boolean setting failed");
		Assertions.assertEquals("4x", pairConversionForm.getPrimitiveByteField(), "Primitive byte setting failed");
		Assertions.assertEquals("5x", pairConversionForm.getObjectByteField(), "Object byte setting failed");
		Assertions.assertEquals("6x", pairConversionForm.getPrimitiveCharField(), "Primitive char setting failed");
		Assertions.assertEquals("7x", pairConversionForm.getObjectCharacterField(), "Object char setting failed");
		Assertions.assertEquals("8x", pairConversionForm.getDateField(), "Date setting failed");
		Assertions.assertEquals("9x", pairConversionForm.getPrimitiveDoubleField(), "Primitive double setting failed");
		Assertions.assertEquals("10x", pairConversionForm.getObjectDoubleField(), "Object double setting failed");
		Assertions.assertEquals("11x", pairConversionForm.getEnumField(), "Enum setting failed");
		Assertions.assertEquals("12x", pairConversionForm.getPrimitiveFloatField(), "Primitive float setting failed");
		Assertions.assertEquals("13x", pairConversionForm.getObjectFloatField(), "Object float setting failed");
		Assertions.assertEquals("14x", pairConversionForm.getPrimitiveIntField(), "Primitive int setting failed");
		Assertions.assertEquals("15x", pairConversionForm.getObjectIntegerField(), "Object integer setting failed");
		Assertions.assertEquals("16x", pairConversionForm.getPrimitiveLongField(), "Primitive long setting failed");
		Assertions.assertEquals("17x", pairConversionForm.getObjectLongField(), "Object long setting failed");
		Assertions.assertEquals("18x", pairConversionForm.getPrimitiveShortField(), "Primitive short setting failed");
		Assertions.assertEquals("19x", pairConversionForm.getObjectShortField(), "Object short setting failed");
		Assertions.assertEquals("20x", pairConversionForm.getCustomField(), "Custom setting failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "Conversions skipped due to missing unformatted field halves");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on auto conversion")
	@Test
	public void testValidateAuto1() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		AutoConversionAction action;
		AutoConversionForm autoConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new AutoConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "12.9");
		parameters.put("primitiveBooleanField", "1");
		parameters.put("objectBooleanField", "1");
		parameters.put("primitiveByteField", "127");
		parameters.put("objectByteField", "127");
		parameters.put("primitiveCharField", "^");
		parameters.put("objectCharacterField", "^");
		parameters.put("dateField", "10/12/1993");
		parameters.put("primitiveDoubleField", "-8.23");
		parameters.put("objectDoubleField", "-8.23");
		parameters.put("enumField", "RED");
		parameters.put("primitiveFloatField", "-8.23");
		parameters.put("objectFloatField", "-8.23");
		parameters.put("primitiveIntField", "10000");
		parameters.put("objectIntegerField", "10000");
		parameters.put("primitiveLongField", "999999");
		parameters.put("objectLongField", "999999");
		parameters.put("primitiveShortField", "4455");
		parameters.put("objectShortField", "4455");
		parameters.put("customField", "10.99");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		autoConversionForm = action.getModel();
		Assertions.assertEquals(new BigDecimal("12.9"), autoConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(true, autoConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(true, autoConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(127, autoConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals((byte)127, autoConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals('^', autoConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals('^', autoConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals((new GregorianCalendar(1993,11,10).getTime()), autoConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(-8.23, autoConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(-8.23, autoConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(Colour.RED, autoConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)-8.23, autoConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals((float)-8.23, autoConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(10000, autoConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(10000, autoConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(999999, autoConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(999999, autoConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)4455, autoConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals((short)4455, autoConversionForm.getObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals(1099, autoConversionForm.getCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on auto conversion but empty string values")
	@Test
	public void testValidateAuto2() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		AutoConversionAction action;
		AutoConversionForm autoConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new AutoConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "");
		parameters.put("primitiveBooleanField", "");
		parameters.put("objectBooleanField", "");
		parameters.put("primitiveByteField", "");
		parameters.put("objectByteField", "");
		parameters.put("primitiveCharField", "");
		parameters.put("objectCharacterField", "");
		parameters.put("dateField", "");
		parameters.put("primitiveDoubleField", "");
		parameters.put("objectDoubleField", "");
		parameters.put("enumField", "");
		parameters.put("primitiveFloatField", "");
		parameters.put("objectFloatField", "");
		parameters.put("primitiveIntField", "");
		parameters.put("objectIntegerField", "");
		parameters.put("primitiveLongField", "");
		parameters.put("objectLongField", "");
		parameters.put("primitiveShortField", "");
		parameters.put("objectShortField", "");
		parameters.put("customField", "");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		autoConversionForm = action.getModel();
		Assertions.assertEquals(null, autoConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, autoConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, autoConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, autoConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)0, autoConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Empty strings don't trigger conversion");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on auto conversion but missing values")
	@Test
	public void testValidateAuto3() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		AutoConversionAction action;
		AutoConversionForm autoConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new AutoConversionAction();
		
		parameters = new HashMap<>();
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		autoConversionForm = action.getModel();
		Assertions.assertEquals(null, autoConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, autoConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, autoConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, autoConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)0, autoConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "There should be no conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on auto conversion but conversions fail")
	@Test
	public void testValidateAuto4() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		AutoConversionAction action;
		AutoConversionForm autoConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new AutoConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "1x");
		parameters.put("primitiveBooleanField", "2x");
		parameters.put("objectBooleanField", "3x");
		parameters.put("primitiveByteField", "4x");
		parameters.put("objectByteField", "5x");
		parameters.put("primitiveCharField", "6x");
		parameters.put("objectCharacterField", "7x");
		parameters.put("dateField", "8x");
		parameters.put("primitiveDoubleField", "9x");
		parameters.put("objectDoubleField", "10x");
		parameters.put("enumField", "11x");
		parameters.put("primitiveFloatField", "12x");
		parameters.put("objectFloatField", "13x");
		parameters.put("primitiveIntField", "14x");
		parameters.put("objectIntegerField", "15x");
		parameters.put("primitiveLongField", "16x");
		parameters.put("objectLongField", "17x");
		parameters.put("primitiveShortField", "18x");
		parameters.put("objectShortField", "19x");
		parameters.put("customField", "20x");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		autoConversionForm = action.getModel();
		Assertions.assertEquals(null, autoConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, autoConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(false, autoConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals('6', autoConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals('7', autoConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, autoConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, autoConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(16, conversionErrors.size(), "All parameters, except boolean and character, should be rejected and be conversion errors");
		Assertions.assertEquals("1x", conversionErrors.get("bigDecimalField").getValue(), "BigDecimal conversion error does not match parameter");
		Assertions.assertEquals(null, conversionErrors.get("primitiveBooleanField"), "Primitive boolean never has a conversion error");
		Assertions.assertEquals(null, conversionErrors.get("objectBooleanField"), "Object boolean never has a conversion error");
		Assertions.assertEquals("4x", conversionErrors.get("primitiveByteField").getValue(), "Primitive byte conversion error does not match parameter");
		Assertions.assertEquals("5x", conversionErrors.get("objectByteField").getValue(), "Object byte conversion error does not match parameter");
		Assertions.assertEquals(null, conversionErrors.get("primitiveCharField"), "Primitive char never has a conversion error");
		Assertions.assertEquals(null, conversionErrors.get("objectCharacterField"), "Object char never has a conversion error");
		Assertions.assertEquals("8x", conversionErrors.get("dateField").getValue(), "Date conversion error does not match parameter");
		Assertions.assertEquals("9x", conversionErrors.get("primitiveDoubleField").getValue(), "Primitive double conversion error does not match parameter");
		Assertions.assertEquals("10x", conversionErrors.get("objectDoubleField").getValue(), "Object double conversion error does not match parameter");
		Assertions.assertEquals("11x", conversionErrors.get("enumField").getValue(), "Enumerated conversion error does not match parameter");
		Assertions.assertEquals("12x", conversionErrors.get("primitiveFloatField").getValue(), "Primitive float conversion error does not match parameter");
		Assertions.assertEquals("13x", conversionErrors.get("objectFloatField").getValue(), "Object float conversion error does not match parameter");
		Assertions.assertEquals("14x", conversionErrors.get("primitiveIntField").getValue(), "Primitive int conversion error does not match parameter");
		Assertions.assertEquals("15x", conversionErrors.get("objectIntegerField").getValue(), "Object int conversion error does not match parameter");
		Assertions.assertEquals("16x", conversionErrors.get("primitiveLongField").getValue(), "Primitive long conversion error does not match parameter");
		Assertions.assertEquals("17x", conversionErrors.get("objectLongField").getValue(), "Object long conversion error does not match parameter");
		Assertions.assertEquals("18x", conversionErrors.get("primitiveShortField").getValue(), "Primitive short conversion error does not match parameter");
		Assertions.assertEquals("19x", conversionErrors.get("objectShortField").getValue(), "Object short conversion error does not match parameter");
		Assertions.assertEquals("20x", conversionErrors.get("customField").getValue(), "Custom conversion error does not match parameter");
		validationAware = action;
		Assertions.assertEquals(16, validationAware.getActionErrors().size(), "All parameters, except boolean and character, should be rejected");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal conversion failed", "Byte conversion failed", 
			"Byte conversion failed", "Date conversion failed", "Double conversion failed", "Double conversion failed", 
			"Enum conversion failed", "Float conversion failed", "Float conversion failed", "Integer conversion failed", 
			"Integer conversion failed", "Long conversion failed", "Long conversion failed", "Short conversion failed", 
			"Short conversion failed",	"Price is not a number"), 
			new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on auto conversion using required fields")
	@Test
	public void testValidateAuto5() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		AutoConversionRequiredAction action;
		AutoConversionRequiredForm autoConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new AutoConversionRequiredAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "12.9");
		parameters.put("primitiveBooleanField", "1");
		parameters.put("objectBooleanField", "1");
		parameters.put("primitiveByteField", "127");
		parameters.put("objectByteField", "127");
		parameters.put("primitiveCharField", "^");
		parameters.put("objectCharacterField", "^");
		parameters.put("dateField", "10/12/1993");
		parameters.put("primitiveDoubleField", "-8.23");
		parameters.put("objectDoubleField", "-8.23");
		parameters.put("enumField", "RED");
		parameters.put("primitiveFloatField", "-8.23");
		parameters.put("objectFloatField", "-8.23");
		parameters.put("primitiveIntField", "10000");
		parameters.put("objectIntegerField", "10000");
		parameters.put("primitiveLongField", "999999");
		parameters.put("objectLongField", "999999");
		parameters.put("primitiveShortField", "4455");
		parameters.put("objectShortField", "4455");
		parameters.put("customField", "10.99");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		autoConversionForm = action.getModel();
		Assertions.assertEquals(new BigDecimal("12.9"), autoConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(true, autoConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(true, autoConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(127, autoConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals((byte)127, autoConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals('^', autoConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals('^', autoConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals((new GregorianCalendar(1993,11,10).getTime()), autoConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(-8.23, autoConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(-8.23, autoConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(Colour.RED, autoConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)-8.23, autoConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals((float)-8.23, autoConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(10000, autoConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(10000, autoConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(999999, autoConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(999999, autoConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)4455, autoConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals((short)4455, autoConversionForm.getObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals(1099, autoConversionForm.getCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on auto conversion using required fields but empty string values")
	@Test
	public void testValidateAuto6() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		AutoConversionRequiredAction action;
		AutoConversionRequiredForm autoConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new AutoConversionRequiredAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "");
		parameters.put("primitiveBooleanField", "");
		parameters.put("objectBooleanField", "");
		parameters.put("primitiveByteField", "");
		parameters.put("objectByteField", "");
		parameters.put("primitiveCharField", "");
		parameters.put("objectCharacterField", "");
		parameters.put("dateField", "");
		parameters.put("primitiveDoubleField", "");
		parameters.put("objectDoubleField", "");
		parameters.put("enumField", "");
		parameters.put("primitiveFloatField", "");
		parameters.put("objectFloatField", "");
		parameters.put("primitiveIntField", "");
		parameters.put("objectIntegerField", "");
		parameters.put("primitiveLongField", "");
		parameters.put("objectLongField", "");
		parameters.put("primitiveShortField", "");
		parameters.put("objectShortField", "");
		parameters.put("customField", "");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		autoConversionForm = action.getModel();
		Assertions.assertEquals(null, autoConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, autoConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, autoConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, autoConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)0, autoConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(20, conversionErrors.size(), "All fields should fail @Required annotation");
		Assertions.assertEquals("", conversionErrors.get("bigDecimalField").getValue(), "BigDecimal conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveBooleanField").getValue(), "Primitive boolean never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("objectBooleanField").getValue(), "Object boolean never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("primitiveByteField").getValue(), "Primitive byte conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectByteField").getValue(), "Object byte conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveCharField").getValue(), "Primitive char never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("objectCharacterField").getValue(), "Object char never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("dateField").getValue(), "Date conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveDoubleField").getValue(), "Primitive double conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectDoubleField").getValue(), "Object double conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("enumField").getValue(), "Enumerated conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveFloatField").getValue(), "Primitive float conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectFloatField").getValue(), "Object float conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveIntField").getValue(), "Primitive int conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectIntegerField").getValue(), "Object int conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveLongField").getValue(), "Primitive long conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectLongField").getValue(), "Object long conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveShortField").getValue(), "Primitive short conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectShortField").getValue(), "Object short conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("customField").getValue(), "Custom conversion error does not match parameter");
		validationAware = action;
		Assertions.assertEquals(20, validationAware.getActionErrors().size(), "All failed fields should write an error message");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal required",	"Boolean required",	
			"Boolean required",	"Byte required", "Byte required", "Character required",	"Character required", 
			"Date required", "Double required", "Double required", "Enum required", "Float required", "Float required",
			"Integer required",	"Integer required",	"Long required", "Long required", "Short required", "Short required",
			"Price is required"), new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on auto conversion using required fields but missing parameters")
	@Test
	public void testValidateAuto7() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		AutoConversionRequiredAction action;
		AutoConversionRequiredForm autoConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new AutoConversionRequiredAction();
		
		parameters = new HashMap<>();
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		autoConversionForm = action.getModel();
		Assertions.assertEquals(null, autoConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, autoConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, autoConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, autoConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)0, autoConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(20, conversionErrors.size(), "All fields should fail @Required annotation");
		Assertions.assertEquals("", conversionErrors.get("bigDecimalField").getValue(), "BigDecimal conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveBooleanField").getValue(), "Primitive boolean never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("objectBooleanField").getValue(), "Object boolean never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("primitiveByteField").getValue(), "Primitive byte conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectByteField").getValue(), "Object byte conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveCharField").getValue(), "Primitive char never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("objectCharacterField").getValue(), "Object char never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("dateField").getValue(), "Date conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveDoubleField").getValue(), "Primitive double conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectDoubleField").getValue(), "Object double conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("enumField").getValue(), "Enumerated conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveFloatField").getValue(), "Primitive float conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectFloatField").getValue(), "Object float conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveIntField").getValue(), "Primitive int conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectIntegerField").getValue(), "Object int conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveLongField").getValue(), "Primitive long conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectLongField").getValue(), "Object long conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveShortField").getValue(), "Primitive short conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectShortField").getValue(), "Object short conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("customField").getValue(), "Custom conversion error does not match parameter");
		validationAware = action;
		Assertions.assertEquals(20, validationAware.getActionErrors().size(), "All failed fields should write an error message");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal required",	"Boolean required",	
				"Boolean required",	"Byte required", "Byte required", "Character required",	"Character required", 
				"Date required", "Double required", "Double required", "Enum required", "Float required", "Float required",
				"Integer required",	"Integer required",	"Long required", "Long required", "Short required", "Short required",
				"Price is required"), new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on auto conversion using required fields but conversions fail")
	@Test
	public void testValidateAuto8() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		AutoConversionRequiredAction action;
		AutoConversionRequiredForm autoConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new AutoConversionRequiredAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "1x");
		parameters.put("primitiveBooleanField", "2x");
		parameters.put("objectBooleanField", "3x");
		parameters.put("primitiveByteField", "4x");
		parameters.put("objectByteField", "5x");
		parameters.put("primitiveCharField", "6x");
		parameters.put("objectCharacterField", "7x");
		parameters.put("dateField", "8x");
		parameters.put("primitiveDoubleField", "9x");
		parameters.put("objectDoubleField", "10x");
		parameters.put("enumField", "11x");
		parameters.put("primitiveFloatField", "12x");
		parameters.put("objectFloatField", "13x");
		parameters.put("primitiveIntField", "14x");
		parameters.put("objectIntegerField", "15x");
		parameters.put("primitiveLongField", "16x");
		parameters.put("objectLongField", "17x");
		parameters.put("primitiveShortField", "18x");
		parameters.put("objectShortField", "19x");
		parameters.put("customField", "20x");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		autoConversionForm = action.getModel();
		Assertions.assertEquals(null, autoConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, autoConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(false, autoConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals('6', autoConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals('7', autoConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, autoConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, autoConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, autoConversionForm.getObjectShortField(), "Object short conversion failed");
		Assertions.assertEquals(0, autoConversionForm.getCustomField(), "Custom conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(16, conversionErrors.size(), "All parameters, except boolean and character, should be rejected and be conversion errors");
		Assertions.assertEquals("1x", conversionErrors.get("bigDecimalField").getValue(), "BigDecimal conversion error does not match parameter");
		Assertions.assertEquals(null, conversionErrors.get("primitiveBooleanField"), "Primitive boolean never has a conversion error");
		Assertions.assertEquals(null, conversionErrors.get("objectBooleanField"), "Object boolean never has a conversion error");
		Assertions.assertEquals("4x", conversionErrors.get("primitiveByteField").getValue(), "Primitive byte conversion error does not match parameter");
		Assertions.assertEquals("5x", conversionErrors.get("objectByteField").getValue(), "Object byte conversion error does not match parameter");
		Assertions.assertEquals(null, conversionErrors.get("primitiveCharField"), "Primitive char never has a conversion error");
		Assertions.assertEquals(null, conversionErrors.get("objectCharacterField"), "Object char never has a conversion error");
		Assertions.assertEquals("8x", conversionErrors.get("dateField").getValue(), "Date conversion error does not match parameter");
		Assertions.assertEquals("9x", conversionErrors.get("primitiveDoubleField").getValue(), "Primitive double conversion error does not match parameter");
		Assertions.assertEquals("10x", conversionErrors.get("objectDoubleField").getValue(), "Object double conversion error does not match parameter");
		Assertions.assertEquals("11x", conversionErrors.get("enumField").getValue(), "Enumerated conversion error does not match parameter");
		Assertions.assertEquals("12x", conversionErrors.get("primitiveFloatField").getValue(), "Primitive float conversion error does not match parameter");
		Assertions.assertEquals("13x", conversionErrors.get("objectFloatField").getValue(), "Object float conversion error does not match parameter");
		Assertions.assertEquals("14x", conversionErrors.get("primitiveIntField").getValue(), "Primitive int conversion error does not match parameter");
		Assertions.assertEquals("15x", conversionErrors.get("objectIntegerField").getValue(), "Object int conversion error does not match parameter");
		Assertions.assertEquals("16x", conversionErrors.get("primitiveLongField").getValue(), "Primitive long conversion error does not match parameter");
		Assertions.assertEquals("17x", conversionErrors.get("objectLongField").getValue(), "Object long conversion error does not match parameter");
		Assertions.assertEquals("18x", conversionErrors.get("primitiveShortField").getValue(), "Primitive short conversion error does not match parameter");
		Assertions.assertEquals("19x", conversionErrors.get("objectShortField").getValue(), "Object short conversion error does not match parameter");
		Assertions.assertEquals("20x", conversionErrors.get("customField").getValue(), "Custom conversion error does not match parameter");
		validationAware = action;
		Assertions.assertEquals(16, validationAware.getActionErrors().size(), "All parameters, except boolean and character, should be rejected");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal conversion failed", "Byte conversion failed", 
				"Byte conversion failed", "Date conversion failed", "Double conversion failed", "Double conversion failed", 
				"Enum conversion failed", "Float conversion failed", "Float conversion failed", "Integer conversion failed", 
				"Integer conversion failed", "Long conversion failed", "Long conversion failed", "Short conversion failed", 
				"Short conversion failed",	"Price is not a number"), 
				new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on default conversion")
	@Test
	public void testValidateDefault1() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		DefaultConversionAction action;
		DefaultConversionForm defaultConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new DefaultConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "12.9");
		parameters.put("primitiveBooleanField", "1");
		parameters.put("objectBooleanField", "1");
		parameters.put("primitiveByteField", "127");
		parameters.put("objectByteField", "127");
		parameters.put("primitiveCharField", "^");
		parameters.put("objectCharacterField", "^");
		parameters.put("dateField", "10/12/1993");
		parameters.put("primitiveDoubleField", "-8.23");
		parameters.put("objectDoubleField", "-8.23");
		parameters.put("enumField", "RED");
		parameters.put("primitiveFloatField", "-8.23");
		parameters.put("objectFloatField", "-8.23");
		parameters.put("primitiveIntField", "10000");
		parameters.put("objectIntegerField", "10000");
		parameters.put("primitiveLongField", "999999");
		parameters.put("objectLongField", "999999");
		parameters.put("primitiveShortField", "4455");
		parameters.put("objectShortField", "4455");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		defaultConversionForm = action.getModel();
		Assertions.assertEquals(new BigDecimal("12.9"), defaultConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(true, defaultConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(true, defaultConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(127, defaultConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals((byte)127, defaultConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals('^', defaultConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals('^', defaultConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals((new GregorianCalendar(1993,11,10).getTime()), defaultConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(-8.23, defaultConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(-8.23, defaultConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(Colour.RED, defaultConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)-8.23, defaultConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals((float)-8.23, defaultConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(10000, defaultConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(10000, defaultConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(999999, defaultConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(999999, defaultConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)4455, defaultConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals((short)4455, defaultConversionForm.getObjectShortField(), "Object short conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on default conversion but empty string values")
	@Test
	public void testValidateDefault2() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		DefaultConversionAction action;
		DefaultConversionForm defaultConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new DefaultConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "");
		parameters.put("primitiveBooleanField", "");
		parameters.put("objectBooleanField", "");
		parameters.put("primitiveByteField", "");
		parameters.put("objectByteField", "");
		parameters.put("primitiveCharField", "");
		parameters.put("objectCharacterField", "");
		parameters.put("dateField", "");
		parameters.put("primitiveDoubleField", "");
		parameters.put("objectDoubleField", "");
		parameters.put("enumField", "");
		parameters.put("primitiveFloatField", "");
		parameters.put("objectFloatField", "");
		parameters.put("primitiveIntField", "");
		parameters.put("objectIntegerField", "");
		parameters.put("primitiveLongField", "");
		parameters.put("objectLongField", "");
		parameters.put("primitiveShortField", "");
		parameters.put("objectShortField", "");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		defaultConversionForm = action.getModel();
		Assertions.assertEquals(null, defaultConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, defaultConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, defaultConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, defaultConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)0, defaultConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectShortField(), "Object short conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Empty strings don't trigger conversion");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on default conversion but missing values")
	@Test
	public void testValidateDefault3() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		DefaultConversionAction action;
		DefaultConversionForm defaultConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new DefaultConversionAction();
		
		parameters = new HashMap<>();
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		defaultConversionForm = action.getModel();
		Assertions.assertEquals(null, defaultConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, defaultConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, defaultConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, defaultConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)0, defaultConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectShortField(), "Object short conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "There should be no conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on default conversion but conversions fail")
	@Test
	public void testValidateDefault4() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		DefaultConversionAction action;
		DefaultConversionForm defaultConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new DefaultConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "1x");
		parameters.put("primitiveBooleanField", "2x");
		parameters.put("objectBooleanField", "3x");
		parameters.put("primitiveByteField", "4x");
		parameters.put("objectByteField", "5x");
		parameters.put("primitiveCharField", "6x");
		parameters.put("objectCharacterField", "7x");
		parameters.put("dateField", "8x");
		parameters.put("primitiveDoubleField", "9x");
		parameters.put("objectDoubleField", "10x");
		parameters.put("enumField", "11x");
		parameters.put("primitiveFloatField", "12x");
		parameters.put("objectFloatField", "13x");
		parameters.put("primitiveIntField", "14x");
		parameters.put("objectIntegerField", "15x");
		parameters.put("primitiveLongField", "16x");
		parameters.put("objectLongField", "17x");
		parameters.put("primitiveShortField", "18x");
		parameters.put("objectShortField", "19x");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		defaultConversionForm = action.getModel();
		Assertions.assertEquals(null, defaultConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, defaultConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(false, defaultConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals('6', defaultConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals('7', defaultConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, defaultConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, defaultConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectShortField(), "Object short conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(15, conversionErrors.size(), "All parameters, except boolean and character, should be rejected and be conversion errors");
		Assertions.assertEquals("1x", conversionErrors.get("bigDecimalField").getValue(), "BigDecimal conversion error does not match parameter");
		Assertions.assertEquals(null, conversionErrors.get("primitiveBooleanField"), "Primitive boolean never has a conversion error");
		Assertions.assertEquals(null, conversionErrors.get("objectBooleanField"), "Object boolean never has a conversion error");
		Assertions.assertEquals("4x", conversionErrors.get("primitiveByteField").getValue(), "Primitive byte conversion error does not match parameter");
		Assertions.assertEquals("5x", conversionErrors.get("objectByteField").getValue(), "Object byte conversion error does not match parameter");
		Assertions.assertEquals(null, conversionErrors.get("primitiveCharField"), "Primitive char never has a conversion error");
		Assertions.assertEquals(null, conversionErrors.get("objectCharacterField"), "Object char never has a conversion error");
		Assertions.assertEquals("8x", conversionErrors.get("dateField").getValue(), "Date conversion error does not match parameter");
		Assertions.assertEquals("9x", conversionErrors.get("primitiveDoubleField").getValue(), "Primitive double conversion error does not match parameter");
		Assertions.assertEquals("10x", conversionErrors.get("objectDoubleField").getValue(), "Object double conversion error does not match parameter");
		Assertions.assertEquals("11x", conversionErrors.get("enumField").getValue(), "Enumerated conversion error does not match parameter");
		Assertions.assertEquals("12x", conversionErrors.get("primitiveFloatField").getValue(), "Primitive float conversion error does not match parameter");
		Assertions.assertEquals("13x", conversionErrors.get("objectFloatField").getValue(), "Object float conversion error does not match parameter");
		Assertions.assertEquals("14x", conversionErrors.get("primitiveIntField").getValue(), "Primitive int conversion error does not match parameter");
		Assertions.assertEquals("15x", conversionErrors.get("objectIntegerField").getValue(), "Object int conversion error does not match parameter");
		Assertions.assertEquals("16x", conversionErrors.get("primitiveLongField").getValue(), "Primitive long conversion error does not match parameter");
		Assertions.assertEquals("17x", conversionErrors.get("objectLongField").getValue(), "Object long conversion error does not match parameter");
		Assertions.assertEquals("18x", conversionErrors.get("primitiveShortField").getValue(), "Primitive short conversion error does not match parameter");
		Assertions.assertEquals("19x", conversionErrors.get("objectShortField").getValue(), "Object short conversion error does not match parameter");
	validationAware = action;
		Assertions.assertEquals(15, validationAware.getActionErrors().size(), "All parameters, except boolean and character, should be rejected");
		// Default conversion error messages aren't defined
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on default conversion using required fields")
	@Test
	public void testValidateDefault5() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		DefaultConversionRequiredAction action;
		DefaultConversionRequiredForm defaultConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new DefaultConversionRequiredAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "12.9");
		parameters.put("primitiveBooleanField", "1");
		parameters.put("objectBooleanField", "1");
		parameters.put("primitiveByteField", "127");
		parameters.put("objectByteField", "127");
		parameters.put("primitiveCharField", "^");
		parameters.put("objectCharacterField", "^");
		parameters.put("dateField", "10/12/1993");
		parameters.put("primitiveDoubleField", "-8.23");
		parameters.put("objectDoubleField", "-8.23");
		parameters.put("enumField", "RED");
		parameters.put("primitiveFloatField", "-8.23");
		parameters.put("objectFloatField", "-8.23");
		parameters.put("primitiveIntField", "10000");
		parameters.put("objectIntegerField", "10000");
		parameters.put("primitiveLongField", "999999");
		parameters.put("objectLongField", "999999");
		parameters.put("primitiveShortField", "4455");
		parameters.put("objectShortField", "4455");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		defaultConversionForm = action.getModel();
		Assertions.assertEquals(new BigDecimal("12.9"), defaultConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(true, defaultConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(true, defaultConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(127, defaultConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals((byte)127, defaultConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals('^', defaultConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals('^', defaultConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals((new GregorianCalendar(1993,11,10).getTime()), defaultConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(-8.23, defaultConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(-8.23, defaultConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(Colour.RED, defaultConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)-8.23, defaultConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals((float)-8.23, defaultConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(10000, defaultConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(10000, defaultConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(999999, defaultConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(999999, defaultConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)4455, defaultConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals((short)4455, defaultConversionForm.getObjectShortField(), "Object short conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on default conversion using required fields but empty string values")
	@Test
	public void testValidateDeefault6() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		DefaultConversionRequiredAction action;
		DefaultConversionRequiredForm defaultConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new DefaultConversionRequiredAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "");
		parameters.put("primitiveBooleanField", "");
		parameters.put("objectBooleanField", "");
		parameters.put("primitiveByteField", "");
		parameters.put("objectByteField", "");
		parameters.put("primitiveCharField", "");
		parameters.put("objectCharacterField", "");
		parameters.put("dateField", "");
		parameters.put("primitiveDoubleField", "");
		parameters.put("objectDoubleField", "");
		parameters.put("enumField", "");
		parameters.put("primitiveFloatField", "");
		parameters.put("objectFloatField", "");
		parameters.put("primitiveIntField", "");
		parameters.put("objectIntegerField", "");
		parameters.put("primitiveLongField", "");
		parameters.put("objectLongField", "");
		parameters.put("primitiveShortField", "");
		parameters.put("objectShortField", "");
	httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		defaultConversionForm = action.getModel();
		Assertions.assertEquals(null, defaultConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, defaultConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, defaultConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, defaultConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)0, defaultConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectShortField(), "Object short conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(19, conversionErrors.size(), "All fields should fail @Required annotation");
		Assertions.assertEquals("", conversionErrors.get("bigDecimalField").getValue(), "BigDecimal conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveBooleanField").getValue(), "Primitive boolean never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("objectBooleanField").getValue(), "Object boolean never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("primitiveByteField").getValue(), "Primitive byte conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectByteField").getValue(), "Object byte conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveCharField").getValue(), "Primitive char never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("objectCharacterField").getValue(), "Object char never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("dateField").getValue(), "Date conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveDoubleField").getValue(), "Primitive double conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectDoubleField").getValue(), "Object double conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("enumField").getValue(), "Enumerated conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveFloatField").getValue(), "Primitive float conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectFloatField").getValue(), "Object float conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveIntField").getValue(), "Primitive int conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectIntegerField").getValue(), "Object int conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveLongField").getValue(), "Primitive long conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectLongField").getValue(), "Object long conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveShortField").getValue(), "Primitive short conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectShortField").getValue(), "Object short conversion error does not match parameter");
		validationAware = action;
		Assertions.assertEquals(19, validationAware.getActionErrors().size(), "All failed fields should write an error message");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal required",	"Boolean required",	
			"Boolean required",	"Byte required", "Byte required", "Character required",	"Character required", 
			"Date required", "Double required", "Double required", "Enum required", "Float required", "Float required",
			"Integer required",	"Integer required",	"Long required", "Long required", "Short required", "Short required"), 
			new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on default conversion using required fields but missing parameters")
	@Test
	public void testValidateDefault7() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		DefaultConversionRequiredAction action;
		DefaultConversionRequiredForm defaultConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new DefaultConversionRequiredAction();
		
		parameters = new HashMap<>();
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		defaultConversionForm = action.getModel();
		Assertions.assertEquals(null, defaultConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, defaultConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, defaultConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, defaultConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)0, defaultConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectShortField(), "Object short conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(19, conversionErrors.size(), "All fields should fail @Required annotation");
		Assertions.assertEquals("", conversionErrors.get("bigDecimalField").getValue(), "BigDecimal conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveBooleanField").getValue(), "Primitive boolean never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("objectBooleanField").getValue(), "Object boolean never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("primitiveByteField").getValue(), "Primitive byte conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectByteField").getValue(), "Object byte conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveCharField").getValue(), "Primitive char never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("objectCharacterField").getValue(), "Object char never has a conversion error");
		Assertions.assertEquals("", conversionErrors.get("dateField").getValue(), "Date conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveDoubleField").getValue(), "Primitive double conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectDoubleField").getValue(), "Object double conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("enumField").getValue(), "Enumerated conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveFloatField").getValue(), "Primitive float conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectFloatField").getValue(), "Object float conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveIntField").getValue(), "Primitive int conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectIntegerField").getValue(), "Object int conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveLongField").getValue(), "Primitive long conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectLongField").getValue(), "Object long conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("primitiveShortField").getValue(), "Primitive short conversion error does not match parameter");
		Assertions.assertEquals("", conversionErrors.get("objectShortField").getValue(), "Object short conversion error does not match parameter");
		validationAware = action;
		Assertions.assertEquals(19, validationAware.getActionErrors().size(), "All failed fields should write an error message");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Big decimal required",	"Boolean required",	
			"Boolean required",	"Byte required", "Byte required", "Character required",	"Character required", 
			"Date required", "Double required", "Double required", "Enum required", "Float required", "Float required",
			"Integer required",	"Integer required",	"Long required", "Long required", "Short required", "Short required"), 
			new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on default conversion using required fields but conversions fail")
	@Test
	public void testValidateDefault8() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		DefaultConversionRequiredAction action;
		DefaultConversionRequiredForm defaultConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new DefaultConversionRequiredAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "1x");
		parameters.put("primitiveBooleanField", "2x");
		parameters.put("objectBooleanField", "3x");
		parameters.put("primitiveByteField", "4x");
		parameters.put("objectByteField", "5x");
		parameters.put("primitiveCharField", "6x");
		parameters.put("objectCharacterField", "7x");
		parameters.put("dateField", "8x");
		parameters.put("primitiveDoubleField", "9x");
		parameters.put("objectDoubleField", "10x");
		parameters.put("enumField", "11x");
		parameters.put("primitiveFloatField", "12x");
		parameters.put("objectFloatField", "13x");
		parameters.put("primitiveIntField", "14x");
		parameters.put("objectIntegerField", "15x");
		parameters.put("primitiveLongField", "16x");
		parameters.put("objectLongField", "17x");
		parameters.put("primitiveShortField", "18x");
		parameters.put("objectShortField", "19x");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		defaultConversionForm = action.getModel();
		Assertions.assertEquals(null, defaultConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(false, defaultConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(false, defaultConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals('6', defaultConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals('7', defaultConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(0.0, defaultConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)0.0, defaultConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals(0, defaultConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals(null, defaultConversionForm.getObjectShortField(), "Object short conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(15, conversionErrors.size(), "All parameters, except boolean and character, should be rejected and be conversion errors");
		Assertions.assertEquals("1x", conversionErrors.get("bigDecimalField").getValue(), "BigDecimal conversion error does not match parameter");
		Assertions.assertEquals(null, conversionErrors.get("primitiveBooleanField"), "Primitive boolean never has a conversion error");
		Assertions.assertEquals(null, conversionErrors.get("objectBooleanField"), "Object boolean never has a conversion error");
		Assertions.assertEquals("4x", conversionErrors.get("primitiveByteField").getValue(), "Primitive byte conversion error does not match parameter");
		Assertions.assertEquals("5x", conversionErrors.get("objectByteField").getValue(), "Object byte conversion error does not match parameter");
		Assertions.assertEquals(null, conversionErrors.get("primitiveCharField"), "Primitive char never has a conversion error");
		Assertions.assertEquals(null, conversionErrors.get("objectCharacterField"), "Object char never has a conversion error");
		Assertions.assertEquals("8x", conversionErrors.get("dateField").getValue(), "Date conversion error does not match parameter");
		Assertions.assertEquals("9x", conversionErrors.get("primitiveDoubleField").getValue(), "Primitive double conversion error does not match parameter");
		Assertions.assertEquals("10x", conversionErrors.get("objectDoubleField").getValue(), "Object double conversion error does not match parameter");
		Assertions.assertEquals("11x", conversionErrors.get("enumField").getValue(), "Enumerated conversion error does not match parameter");
		Assertions.assertEquals("12x", conversionErrors.get("primitiveFloatField").getValue(), "Primitive float conversion error does not match parameter");
		Assertions.assertEquals("13x", conversionErrors.get("objectFloatField").getValue(), "Object float conversion error does not match parameter");
		Assertions.assertEquals("14x", conversionErrors.get("primitiveIntField").getValue(), "Primitive int conversion error does not match parameter");
		Assertions.assertEquals("15x", conversionErrors.get("objectIntegerField").getValue(), "Object int conversion error does not match parameter");
		Assertions.assertEquals("16x", conversionErrors.get("primitiveLongField").getValue(), "Primitive long conversion error does not match parameter");
		Assertions.assertEquals("17x", conversionErrors.get("objectLongField").getValue(), "Object long conversion error does not match parameter");
		Assertions.assertEquals("18x", conversionErrors.get("primitiveShortField").getValue(), "Primitive short conversion error does not match parameter");
		Assertions.assertEquals("19x", conversionErrors.get("objectShortField").getValue(), "Object short conversion error does not match parameter");
		validationAware = action;
		Assertions.assertEquals(15, validationAware.getActionErrors().size(), "All parameters, except boolean and character, should be rejected");
		// Default conversion error messages aren't defined
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a form based on default conversion but skipUnreferencedFields is true")
	@Test
	public void testValidateDefault9() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		DefaultConversionAction action;
		DefaultConversionForm defaultConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new DefaultConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("bigDecimalField", "12.9");
		parameters.put("primitiveBooleanField", "1");
		parameters.put("objectBooleanField", "1");
		parameters.put("primitiveByteField", "127");
		parameters.put("objectByteField", "127");
		parameters.put("primitiveCharField", "^");
		parameters.put("objectCharacterField", "^");
		parameters.put("dateField", "10/12/1993");
		parameters.put("primitiveDoubleField", "-8.23");
		parameters.put("objectDoubleField", "-8.23");
		parameters.put("enumField", "RED");
		parameters.put("primitiveFloatField", "-8.23");
		parameters.put("objectFloatField", "-8.23");
		parameters.put("primitiveIntField", "10000");
		parameters.put("objectIntegerField", "10000");
		parameters.put("primitiveLongField", "999999");
		parameters.put("objectLongField", "999999");
		parameters.put("primitiveShortField", "4455");
		parameters.put("objectShortField", "4455");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		defaultConversionForm = action.getModel();
		Assertions.assertEquals(new BigDecimal("12.9"), defaultConversionForm.getBigDecimalField(), "BigDecimal conversion failed");
		Assertions.assertEquals(true, defaultConversionForm.getPrimitiveBooleanField(), "Primitive boolean conversion failed");
		Assertions.assertEquals(true, defaultConversionForm.getObjectBooleanField(), "Object boolean conversion failed");
		Assertions.assertEquals(127, defaultConversionForm.getPrimitiveByteField(), "Primitive byte conversion failed");
		Assertions.assertEquals((byte)127, defaultConversionForm.getObjectByteField(), "Object byte conversion failed");
		Assertions.assertEquals('^', defaultConversionForm.getPrimitiveCharField(), "Primitive char conversion failed");
		Assertions.assertEquals('^', defaultConversionForm.getObjectCharacterField(), "Object char conversion failed");
		Assertions.assertEquals((new GregorianCalendar(1993,11,10).getTime()), defaultConversionForm.getDateField(), "Date conversion failed");
		Assertions.assertEquals(-8.23, defaultConversionForm.getPrimitiveDoubleField(), "Primitive double conversion failed");
		Assertions.assertEquals(-8.23, defaultConversionForm.getObjectDoubleField(), "Object double conversion failed");
		Assertions.assertEquals(Colour.RED, defaultConversionForm.getEnumField(), "Enum conversion failed");
		Assertions.assertEquals((float)-8.23, defaultConversionForm.getPrimitiveFloatField(), "Primitive float conversion failed");
		Assertions.assertEquals((float)-8.23, defaultConversionForm.getObjectFloatField(), "Object float conversion failed");
		Assertions.assertEquals(10000, defaultConversionForm.getPrimitiveIntField(), "Primitive int conversion failed");
		Assertions.assertEquals(10000, defaultConversionForm.getObjectIntegerField(), "Object integer conversion failed");
		Assertions.assertEquals(999999, defaultConversionForm.getPrimitiveLongField(), "Primitive long conversion failed");
		Assertions.assertEquals(999999, defaultConversionForm.getObjectLongField(), "Object long conversion failed");
		Assertions.assertEquals((short)4455, defaultConversionForm.getPrimitiveShortField(), "Primitive short conversion failed");
		Assertions.assertEquals((short)4455, defaultConversionForm.getObjectShortField(), "Object short conversion failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "Pair conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "No action errors should be created");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a no conversion based form")
	@Test
	public void testValidateNone1() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		NoConversionAction action;
		NoConversionForm noConversionForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new NoConversionAction();
		
		parameters = new HashMap<>();
		parameters.put("nonEmptyField", "The future is bright");
		parameters.put("emptyField", "");
		parameters.put("requiredNonEmptyField", "Evil geniuses");
		parameters.put("requiredEmptyField", "");
		parameters.put("toUpperCaseField", "sw1a 0aa");
		parameters.put("tooLongField", "To boldy go where no man has gone before!");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		noConversionForm = action.getModel();
		Assertions.assertEquals("The future is bright", noConversionForm.getNonEmptyField(), "Setting Non empty field failed");
		Assertions.assertEquals("", noConversionForm.getEmptyField(), "Setting Empty field failed");
		Assertions.assertEquals("", noConversionForm.getMissingField(), "String fields not set by parameter should be set to empty string");
		Assertions.assertEquals("Evil geniuses", noConversionForm.getRequiredNonEmptyField(), "Setting required non empty field failed");
		Assertions.assertEquals("", noConversionForm.getRequiredMissingField(), "Required string field should still be set to empty string, even if it fails require annotation");
		Assertions.assertEquals("", noConversionForm.getRequiredMissingField(), "Required string field should still be set to empty string, even if it fails require annotation");
		Assertions.assertEquals("SW1A 0AA", noConversionForm.getToUpperCaseField(), "Adjuster for to uppercase field failed");
		Assertions.assertEquals("To boldy go where no man has gone before!", noConversionForm.getTooLongField(), "String field should still be set, even if it failed validation");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "No conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(3, validationAware.getActionErrors().size(), "Only required empty, required missing and too long fields should fail");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("Too long field must be 5 characters or less", 
			"Empty field is actually required", "Missing field is required, so create it"), new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Validates a set only based form")
	@Test
	public void testValidateSetOnly1() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		SetOnlyAction action;
		SetOnlyForm setOnlyForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,Object> parameters;
		
		action = new SetOnlyAction();
		
		parameters = new HashMap<>();
		parameters.put("multiValueArrayField", new String[] {"Roses are red", "violets are blue", "TL;DR: They differ in hue"});
		parameters.put("singleValueArrayField", new String[] {"Violets are violet"});
		parameters.put("emptyStringArrayField", new String[] {""});
		parameters.put("multiValueCollectionField", new String[] {"Roses are red", "violets are blue", "TL;DR: They differ in hue"});
		parameters.put("singleValueCollectionField", new String[] {"Violets are violet"});
		parameters.put("emptyStringCollectionField", new String[] {""});
		parameters.put("queueField", new String[] {"Man is a rope stretched between the animal and the Superman--a rope over an abyss.",
        "A dangerous crossing, a dangerous wayfaring, a dangerous looking-back, a dangerous trembling and halting."});
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		setOnlyForm = action.getModel();
		Assertions.assertArrayEquals(new String[] {"Roses are red", "violets are blue", "TL;DR: They differ in hue"}, setOnlyForm.getMultiValueArrayField(), "Setting multi-valued array field failed");
		Assertions.assertArrayEquals(new String[] {"Violets are violet"}, setOnlyForm.getSingleValueArrayField(), "Setting single-valued array field failed");
		Assertions.assertArrayEquals(new String[] {""}, setOnlyForm.getEmptyStringArrayField(), "Setting empty string array field failed");
		Assertions.assertArrayEquals(new String[] {}, setOnlyForm.getMissingArrayField(), "Setting missing value array field failed");
		Assertions.assertIterableEquals(Arrays.asList("Roses are red", "violets are blue", "TL;DR: They differ in hue"), setOnlyForm.getMultiValueCollectionField(), "Setting multi-valued collection field failed");
		Assertions.assertIterableEquals(Arrays.asList("Violets are violet"), setOnlyForm.getSingleValueCollectionField(), "Setting single-valued collection field failed");
		Assertions.assertIterableEquals(Arrays.asList(""), setOnlyForm.getEmptyStringCollectionField(), "Setting empty string collection field failed");
		Assertions.assertIterableEquals(Arrays.asList(), setOnlyForm.getMissingCollectionField(), "Setting missing value collection field failed");
		Assertions.assertIterableEquals(Arrays.asList("Man is a rope stretched between the animal and the Superman--a rope over an abyss.",
		        "A dangerous crossing, a dangerous wayfaring, a dangerous looking-back, a dangerous trembling and halting."), setOnlyForm.getQueueField(), "Setting queue field failed");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(0, conversionErrors.size(), "No conversion doesn't create conversion errors");
		validationAware = action;
		Assertions.assertEquals(0, validationAware.getActionErrors().size(), "Set only mode doesn't convert or validate");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "Set only mode doesn't convert or validate");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "Set only mode doesn't convert or validate");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
	@DisplayName("Checks validators in all modes")
	@Test
	public void testValidateAll1() {
		Map<String, ConversionData> conversionErrors;
		DefaultAnnotationValidatior annotationValidatior;
		ValidationAction action;
		ValidationForm validationForm;
		ValidationAware validationAware;
		ActionContext actionContext;
		HttpParameters httpParameters;
		ValueStack valueStack;
		Map<String,String> parameters;
		
		action = new ValidationAction();
		
		parameters = new HashMap<>();
		parameters.put("noConversionValidationSuccessField", "Short");
		parameters.put("noConversionValidationFailureField", "Too too long");
		parameters.put("pairConversionValidationSuccessField", "842");
		parameters.put("pairConversionValidationFailureField", "42");
		parameters.put("pairConversionPostValidationSuccessField", "7");
		parameters.put("pairConversionPostValidationFailureField", "12");
		parameters.put("autoConversionValidationSuccessField", "842");
		parameters.put("autoConversionValidationFailureField", "42");
		parameters.put("autoConversionPostValidationSuccessField", "7");
		parameters.put("autoConversionPostValidationFailureField", "12");
		parameters.put("defaultConversionValidationSuccessField", "842");
		parameters.put("defaultConversionValidationFailureField", "42");
		parameters.put("defaultConversionPostValidationSuccessField", "7");
		parameters.put("defaultConversionPostValidationFailureField", "12");
		httpParameters = HttpParameters.create(parameters).build();
		
		actionContext = ActionContext.getContext();
		actionContext.withParameters(httpParameters);
		actionContext.withActionInvocation(new MockActionInvocaton(action, actionContext, new MockValueStack()));
		annotationValidatior = new DefaultAnnotationValidatior();
		
		annotationValidatior.validate();
		validationForm = action.getModel();
		Assertions.assertEquals("Short", validationForm.getNoConversionValidationSuccessField(), "No conversion setting failed");
		Assertions.assertEquals("Too too long", validationForm.getNoConversionValidationFailureField(), "No conversion should be set even if validation fails");
		Assertions.assertEquals("842", validationForm.getPairConversionValidationSuccessField(), "Pair conversion setting failed");
		Assertions.assertEquals(842, validationForm.getParsedPairConversionValidationSuccessField(), "Pair conversion failed");
		Assertions.assertEquals("42", validationForm.getPairConversionValidationFailureField(), "Pair conversion should still be set despite failure");
		Assertions.assertEquals(0, validationForm.getParsedPairConversionValidationFailureField(), "Pair conversion should be skipped as non-conversion validation failed");
		Assertions.assertEquals("7", validationForm.getPairConversionPostValidationSuccessField(), "Pair conversion setting failed");
		Assertions.assertEquals(7, validationForm.getParsedPairConversionPostValidationSuccessField(), "Pair conversion failed");
		Assertions.assertEquals("12", validationForm.getPairConversionPostValidationFailureField(), "Post-conversion failure should not remove previous formatted value");
		Assertions.assertEquals(12, validationForm.getParsedPairConversionPostValidationFailureField(), "Post-conversion failure should not remove previous conversion value");
		Assertions.assertEquals(842, validationForm.getAutoConversionValidationSuccessField(), "Auto conversion failed");
		Assertions.assertEquals(0, validationForm.getAutoConversionValidationFailureField(), "Non-conversion validation failure should prevent conversion");
		Assertions.assertEquals(7, validationForm.getAutoConversionPostValidationSuccessField(), "Auto conversion setting failed");
		Assertions.assertEquals(12, validationForm.getAutoConversionPostValidationFailureField(), "Post-conversion failure should not remove previous converted value");
		Assertions.assertEquals(842, validationForm.getDefaultConversionValidationSuccessField(), "Default conversion failed");
		Assertions.assertEquals(0, validationForm.getDefaultConversionValidationFailureField(), "Non-conversion validation failure should prevent conversion");
		Assertions.assertEquals(7, validationForm.getDefaultConversionPostValidationSuccessField(), "Default conversion setting failed");
		Assertions.assertEquals(12, validationForm.getDefaultConversionPostValidationFailureField(), "Post-conversion failure should not remove previous converted value");
		conversionErrors = actionContext.getConversionErrors();
		Assertions.assertEquals(2, conversionErrors.size(), "Only auto and default non-conversion failed validation should trigger conversion errors");
		Assertions.assertEquals("42", conversionErrors.get("autoConversionValidationFailureField").getValue(), "Auto conversion error does not match parameter");
		Assertions.assertEquals("42", conversionErrors.get("defaultConversionValidationFailureField").getValue(), "Default conversion error does not match parameter");
		validationAware = action;
		Assertions.assertEquals(7, validationAware.getActionErrors().size(), "All validation failures should write an error message");
		Assertions.assertEquals(JUnitLibrary.makeHashSetFromStrings("No conversion field must be 10 characters or less",
				"Pair conversion field must be exactly 3 digits", "Pair conversion field must be between 1 and 10",
				"Auto conversion field must be exactly 3 digits","Auto conversion field must be exactly 3 digits",
				"Auto conversion field must be between 1 and 10","Default conversion field must be exactly 3 digits",
				"Default conversion field must be between 1 and 10"), new HashSet<String>(validationAware.getActionErrors()), "Validation error messages don't match annotations");
		Assertions.assertEquals(0, validationAware.getActionMessages().size(), "No action messages should be created");
		Assertions.assertEquals(0, validationAware.getFieldErrors().size(), "No field errors should be created");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(0, valueStack.size(), "Nothing should be added to ValueStack");
		Assertions.assertEquals(0, valueStack.getExprOverrides().size(), "No expression overrides should be added");
	}
    
}
