package name.matthewgreet.strutscommons.junit.library;

import java.util.HashMap;
import java.util.Map;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;

import name.matthewgreet.strutscommons.junit.defaultformformatter.AutoConversionAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.AutoConversionForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.AutoConversionNonFormattableAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.AutoConversionNonFormattableForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.DefaultConversionAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.DefaultConversionForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.DefaultConversionNonFormattableAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.DefaultConversionNonFormattableForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.ManualParameterConversionAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.ManualParameterConversionForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.ManualParameterConversionNonFormattableAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.ManualParameterConversionNonFormattableForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.MixedAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.MixedForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.MixedNonFormattableAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.MixedNonFormattableForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.MockActionInvocaton;
import name.matthewgreet.strutscommons.junit.defaultformformatter.MockValueStack;
import name.matthewgreet.strutscommons.junit.defaultformformatter.NoConversionAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.NoConversionForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.NoConversionNonFormattableAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.NoConversionNonFormattableForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.PairConversionAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.PairConversionForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.PairConversionNonFormattableAction;
import name.matthewgreet.strutscommons.junit.defaultformformatter.PairConversionNonFormattableForm;
import name.matthewgreet.strutscommons.util.DefaultFormFormatter;

@SuppressWarnings("deprecation")
public class DefaultFormFormatterUnitTests {
	@BeforeEach
	public void init() {
		ActionContext actionContext;
		
		ActionContext.bind(ActionContext.of(new HashMap<>()));
		actionContext = ActionContext.getContext();
		actionContext.withSession(new HashMap<>());
	}
	
	
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on pair conversion")
	@Test
	public void testFormatForms1() {
		DefaultFormFormatter formFormatter;
		PairConversionAction action;
		PairConversionForm pairConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		Map<String,Object> fakeForm;
		
		pairConversionForm = new PairConversionForm();
		action = new PairConversionAction();
		action.setPairConversionForm(pairConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		Assertions.assertEquals("12.9", pairConversionForm.getBigDecimalNonNull(), "Non null BigDecimal failed");
		Assertions.assertEquals("", pairConversionForm.getBigDecimalNull(), "Null BigDecimal failed");
		Assertions.assertEquals("1", pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean failed");
		Assertions.assertEquals("1", pairConversionForm.getObjectBooleanFieldNonNull(), "Non null boolean failed");
		Assertions.assertEquals("", pairConversionForm.getObjectBooleanFieldNull(), "Null Boolean failed");
		Assertions.assertEquals("63", pairConversionForm.getPrimitiveByteField(), "Primitive byte failed");
		Assertions.assertEquals("63", pairConversionForm.getObjectByteFieldNonNull(), "Non null Byte failed");
		Assertions.assertEquals("", pairConversionForm.getObjectByteFieldNull(), "Null Byte failed");
		Assertions.assertEquals("^", pairConversionForm.getPrimitiveCharField(), "Primitive char failed");
		Assertions.assertEquals("^", pairConversionForm.getObjectCharacterFieldNonNull(), "Non null Character failed");
		Assertions.assertEquals("", pairConversionForm.getObjectCharacterFieldNull(), "Null Character failed");
		Assertions.assertEquals("13/12/2020", pairConversionForm.getDateFieldNonNull(), "Non null Date failed");
		Assertions.assertEquals("", pairConversionForm.getDateFieldNull(), "Null Date failed");
		Assertions.assertEquals("-7235258.45", pairConversionForm.getPrimitiveDoubleField(), "Primitive double failed");
		Assertions.assertEquals("-7235258.45", pairConversionForm.getObjectDoubleFieldNonNull(), "Non null Double failed");
		Assertions.assertEquals("", pairConversionForm.getObjectDoubleFieldNull(), "Null Double failed");
		Assertions.assertEquals("RED", pairConversionForm.getEnumFieldNonNull(), "Non null Enum failed");
		Assertions.assertEquals("", pairConversionForm.getEnumFieldNull(), "Null Enum failed");
		Assertions.assertEquals("-345.45", pairConversionForm.getPrimitiveFloatField(), "Primitive float failed");
		Assertions.assertEquals("-345.45", pairConversionForm.getObjectFloatFieldNonNull(), "Non null Float failed");
		Assertions.assertEquals("", pairConversionForm.getObjectFloatFieldNull(), "Null Float failed");
		Assertions.assertEquals("23", pairConversionForm.getPrimitiveIntField(), "Primitive int failed");
		Assertions.assertEquals("23", pairConversionForm.getObjectIntegerFieldNonNull(), "Non null Integer failed");
		Assertions.assertEquals("", pairConversionForm.getObjectIntegerFieldNull(), "Null Integer failed");
		Assertions.assertEquals("367674", pairConversionForm.getPrimitiveLongField(), "Primitive long failed");
		Assertions.assertEquals("367674", pairConversionForm.getObjectLongFieldNonNull(), "Non null Long failed");
		Assertions.assertEquals("", pairConversionForm.getObjectLongFieldNull(), "Null Long failed");
		Assertions.assertEquals("34", pairConversionForm.getPrimitiveShortField(), "Primitive short failed");
		Assertions.assertEquals("34", pairConversionForm.getObjectShortFieldNonNull(), "Non null Short failed");
		Assertions.assertEquals("", pairConversionForm.getObjectShortFieldNull(), "Null Short failed");
		Assertions.assertEquals("1.99", pairConversionForm.getCustomFieldNonNull(), "Non null custom failed");
		Assertions.assertEquals("", pairConversionForm.getCustomFieldNull(), "Null custom failed");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(1, fakeForms.size(), "Only one fake form should exist");
		fakeForm = fakeForms.get("pairConversionForm");
		Assertions.assertNotNull(fakeForm, "pairConversionForm fake form should exist");
		Assertions.assertEquals("12.9", fakeForm.get("bigDecimalNonNull"), "Non null BigDecimal failed");
		Assertions.assertEquals("", fakeForm.get("bigDecimalNull"), "Null BigDecimal failed");
		Assertions.assertEquals("1", fakeForm.get("primitiveBooleanField"), "Primitive boolean failed");
		Assertions.assertEquals("1", fakeForm.get("objectBooleanFieldNonNull"), "Non null boolean failed");
		Assertions.assertEquals("", fakeForm.get("objectBooleanFieldNull"), "Null Boolean failed");
		Assertions.assertEquals("63", fakeForm.get("primitiveByteField"), "Primitive byte failed");
		Assertions.assertEquals("63", fakeForm.get("objectByteFieldNonNull"), "Non null Byte failed");
		Assertions.assertEquals("", fakeForm.get("objectByteFieldNull"), "Null Byte failed");
		Assertions.assertEquals("^", fakeForm.get("primitiveCharField"), "Primitive char failed");
		Assertions.assertEquals("^", fakeForm.get("objectCharacterFieldNonNull"), "Non null Character failed");
		Assertions.assertEquals("", fakeForm.get("objectCharacterFieldNull"), "Null Character failed");
		Assertions.assertEquals("13/12/2020", fakeForm.get("dateFieldNonNull"), "Non null Date failed");
		Assertions.assertEquals("", fakeForm.get("dateFieldNull"), "Null Date failed");
		Assertions.assertEquals("-7235258.45", fakeForm.get("primitiveDoubleField"), "Primitive double failed");
		Assertions.assertEquals("-7235258.45", fakeForm.get("objectDoubleFieldNonNull"), "Non null Double failed");
		Assertions.assertEquals("", fakeForm.get("objectDoubleFieldNull"), "Null Double failed");
		Assertions.assertEquals("RED", fakeForm.get("enumFieldNonNull"), "Non null Enum failed");
		Assertions.assertEquals("", fakeForm.get("enumFieldNull"), "Null Enum failed");
		Assertions.assertEquals("-345.45", fakeForm.get("primitiveFloatField"), "Primitive float failed");
		Assertions.assertEquals("-345.45", fakeForm.get("objectFloatFieldNonNull"), "Non null Float failed");
		Assertions.assertEquals("", fakeForm.get("objectFloatFieldNull"), "Null Float failed");
		Assertions.assertEquals("23", fakeForm.get("primitiveIntField"), "Primitive int failed");
		Assertions.assertEquals("23", fakeForm.get("objectIntegerFieldNonNull"), "Non null Integer failed");
		Assertions.assertEquals("", fakeForm.get("objectIntegerFieldNull"), "Null Integer failed");
		Assertions.assertEquals("367674", fakeForm.get("primitiveLongField"), "Primitive long failed");
		Assertions.assertEquals("367674", fakeForm.get("objectLongFieldNonNull"), "Non null Long failed");
		Assertions.assertEquals("", fakeForm.get("objectLongFieldNull"), "Null Long failed");
		Assertions.assertEquals("34", fakeForm.get("primitiveShortField"), "Primitive short failed");
		Assertions.assertEquals("34", fakeForm.get("objectShortFieldNonNull"), "Non null Short failed");
		Assertions.assertEquals("", fakeForm.get("objectShortFieldNull"), "Null Short failed");
		Assertions.assertEquals("1.99", fakeForm.get("customFieldNonNull"), "Non null custom failed");
		Assertions.assertEquals("", fakeForm.get("customFieldNull"), "Null custom failed");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Ignores a form based on pair conversion as it's not FormattableForm")
	@Test
	public void testFormatForms2() {
		DefaultFormFormatter formFormatter;
		PairConversionNonFormattableAction action;
		PairConversionNonFormattableForm pairConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		pairConversionForm = new PairConversionNonFormattableForm();
		action = new PairConversionNonFormattableAction();
		action.setPairConversionNonFormattableForm(pairConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		Assertions.assertEquals(null, pairConversionForm.getBigDecimalNonNull(), "Non null BigDecimal failed");
		Assertions.assertEquals(null, pairConversionForm.getBigDecimalNull(), "Null BigDecimal failed");
		Assertions.assertEquals(null, pairConversionForm.getPrimitiveBooleanField(), "Primitive boolean failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectBooleanFieldNonNull(), "Non null boolean failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectBooleanFieldNull(), "Null Boolean failed");
		Assertions.assertEquals(null, pairConversionForm.getPrimitiveByteField(), "Primitive byte failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectByteFieldNonNull(), "Non null Byte failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectByteFieldNull(), "Null Byte failed");
		Assertions.assertEquals(null, pairConversionForm.getPrimitiveCharField(), "Primitive char failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectCharacterFieldNonNull(), "Non null Character failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectCharacterFieldNull(), "Null Character failed");
		Assertions.assertEquals(null, pairConversionForm.getDateFieldNonNull(), "Non null Date failed");
		Assertions.assertEquals(null, pairConversionForm.getDateFieldNull(), "Null Date failed");
		Assertions.assertEquals(null, pairConversionForm.getPrimitiveDoubleField(), "Primitive double failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectDoubleFieldNonNull(), "Non null Double failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectDoubleFieldNull(), "Null Double failed");
		Assertions.assertEquals(null, pairConversionForm.getEnumFieldNonNull(), "Non null Enum failed");
		Assertions.assertEquals(null, pairConversionForm.getEnumFieldNull(), "Null Enum failed");
		Assertions.assertEquals(null, pairConversionForm.getPrimitiveFloatField(), "Primitive float failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectFloatFieldNonNull(), "Non null Float failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectFloatFieldNull(), "Null Float failed");
		Assertions.assertEquals(null, pairConversionForm.getPrimitiveIntField(), "Primitive int failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectIntegerFieldNonNull(), "Non null Integer failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectIntegerFieldNull(), "Null Integer failed");
		Assertions.assertEquals(null, pairConversionForm.getPrimitiveLongField(), "Primitive long failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectLongFieldNonNull(), "Non null Long failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectLongFieldNull(), "Null Long failed");
		Assertions.assertEquals(null, pairConversionForm.getPrimitiveShortField(), "Primitive short failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectShortFieldNonNull(), "Non null Short failed");
		Assertions.assertEquals(null, pairConversionForm.getObjectShortFieldNull(), "Null Short failed");
		Assertions.assertEquals(null, pairConversionForm.getCustomFieldNonNull(), "Non null custom failed");
		Assertions.assertEquals(null, pairConversionForm.getCustomFieldNull(), "Null custom failed");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on pair conversion but form is null")
	@Test
	public void testFormatForms3() {
		DefaultFormFormatter formFormatter;
		PairConversionAction action;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		action = new PairConversionAction();
		action.setPairConversionForm(null);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on default conversion")
	@Test
	public void testFormatForms4() {
		DefaultFormFormatter formFormatter;
		AutoConversionAction action;
		AutoConversionForm autoConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		Map<String,Object> fakeForm;
		
		autoConversionForm = new AutoConversionForm();
		action = new AutoConversionAction();
		action.setAutoConversionForm(autoConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(1, fakeForms.size(), "Only one fake form should exist");
		fakeForm = fakeForms.get("autoConversionForm");
		Assertions.assertNotNull(fakeForm, "autoConversionForm fake form should exist");
		Assertions.assertEquals("12.9", fakeForm.get("bigDecimalNonNull"), "Non null BigDecimal failed");
		Assertions.assertEquals("", fakeForm.get("bigDecimalNull"), "Null BigDecimal failed");
		Assertions.assertEquals("1", fakeForm.get("primitiveBooleanField"), "Primitive boolean failed");
		Assertions.assertEquals("1", fakeForm.get("objectBooleanFieldNonNull"), "Non null boolean failed");
		Assertions.assertEquals("", fakeForm.get("objectBooleanFieldNull"), "Null Boolean failed");
		Assertions.assertEquals("63", fakeForm.get("primitiveByteField"), "Primitive byte failed");
		Assertions.assertEquals("63", fakeForm.get("objectByteFieldNonNull"), "Non null Byte failed");
		Assertions.assertEquals("", fakeForm.get("objectByteFieldNull"), "Null Byte failed");
		Assertions.assertEquals("^", fakeForm.get("primitiveCharField"), "Primitive char failed");
		Assertions.assertEquals("^", fakeForm.get("objectCharacterFieldNonNull"), "Non null Character failed");
		Assertions.assertEquals("", fakeForm.get("objectCharacterFieldNull"), "Null Character failed");
		Assertions.assertEquals("13/12/2020", fakeForm.get("dateFieldNonNull"), "Non null Date failed");
		Assertions.assertEquals("", fakeForm.get("dateFieldNull"), "Null Date failed");
		Assertions.assertEquals("-7235258.45", fakeForm.get("primitiveDoubleField"), "Primitive double failed");
		Assertions.assertEquals("-7235258.45", fakeForm.get("objectDoubleFieldNonNull"), "Non null Double failed");
		Assertions.assertEquals("", fakeForm.get("objectDoubleFieldNull"), "Null Double failed");
		Assertions.assertEquals("RED", fakeForm.get("enumFieldNonNull"), "Non null Enum failed");
		Assertions.assertEquals("", fakeForm.get("enumFieldNull"), "Null Enum failed");
		Assertions.assertEquals("-345.45", fakeForm.get("primitiveFloatField"), "Primitive float failed");
		Assertions.assertEquals("-345.45", fakeForm.get("objectFloatFieldNonNull"), "Non null Float failed");
		Assertions.assertEquals("", fakeForm.get("objectFloatFieldNull"), "Null Float failed");
		Assertions.assertEquals("23", fakeForm.get("primitiveIntField"), "Primitive int failed");
		Assertions.assertEquals("23", fakeForm.get("objectIntegerFieldNonNull"), "Non null Integer failed");
		Assertions.assertEquals("", fakeForm.get("objectIntegerFieldNull"), "Null Integer failed");
		Assertions.assertEquals("367674", fakeForm.get("primitiveLongField"), "Primitive long failed");
		Assertions.assertEquals("367674", fakeForm.get("objectLongFieldNonNull"), "Non null Long failed");
		Assertions.assertEquals("", fakeForm.get("objectLongFieldNull"), "Null Long failed");
		Assertions.assertEquals("34", fakeForm.get("primitiveShortField"), "Primitive short failed");
		Assertions.assertEquals("34", fakeForm.get("objectShortFieldNonNull"), "Non null Short failed");
		Assertions.assertEquals("", fakeForm.get("objectShortFieldNull"), "Null Short failed");
		Assertions.assertEquals("1.99", fakeForm.get("customFieldNonNull"), "Non null custom failed");
		Assertions.assertEquals("", fakeForm.get("customFieldNull"), "Null custom failed");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Ignores a form based on auto conversion as it's not FormattableForm")
	@Test
	public void testFormatForms5() {
		DefaultFormFormatter formFormatter;
		AutoConversionNonFormattableAction action;
		AutoConversionNonFormattableForm autoConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		autoConversionForm = new AutoConversionNonFormattableForm();
		action = new AutoConversionNonFormattableAction();
		action.setAutoConversionNonFormattableForm(autoConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on auto conversion but form is null")
	@Test
	public void testFormatForms6() {
		DefaultFormFormatter formFormatter;
		AutoConversionAction action;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		action = new AutoConversionAction();
		action.setAutoConversionForm(null);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on default conversion")
	@Test
	public void testFormatForms7() {
		DefaultFormFormatter formFormatter;
		DefaultConversionAction action;
		DefaultConversionForm defaultConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		Map<String,Object> fakeForm;
		
		defaultConversionForm = new DefaultConversionForm();
		action = new DefaultConversionAction();
		action.setDefaultConversionForm(defaultConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(1, fakeForms.size(), "Only one fake form should exist");
		fakeForm = fakeForms.get("defaultConversionForm");
		Assertions.assertNotNull(fakeForm, "defaultConversionForm fake form should exist");
		Assertions.assertEquals("12.9", fakeForm.get("bigDecimalNonNull"), "Non null BigDecimal failed");
		Assertions.assertEquals("", fakeForm.get("bigDecimalNull"), "Null BigDecimal failed");
		Assertions.assertEquals("1", fakeForm.get("primitiveBooleanField"), "Primitive boolean failed");
		Assertions.assertEquals("1", fakeForm.get("objectBooleanFieldNonNull"), "Non null boolean failed");
		Assertions.assertEquals("", fakeForm.get("objectBooleanFieldNull"), "Null Boolean failed");
		Assertions.assertEquals("63", fakeForm.get("primitiveByteField"), "Primitive byte failed");
		Assertions.assertEquals("63", fakeForm.get("objectByteFieldNonNull"), "Non null Byte failed");
		Assertions.assertEquals("", fakeForm.get("objectByteFieldNull"), "Null Byte failed");
		Assertions.assertEquals("^", fakeForm.get("primitiveCharField"), "Primitive char failed");
		Assertions.assertEquals("^", fakeForm.get("objectCharacterFieldNonNull"), "Non null Character failed");
		Assertions.assertEquals("", fakeForm.get("objectCharacterFieldNull"), "Null Character failed");
		Assertions.assertEquals("13/12/2020", fakeForm.get("dateFieldNonNull"), "Non null Date failed");
		Assertions.assertEquals("", fakeForm.get("dateFieldNull"), "Null Date failed");
		Assertions.assertEquals("-7235258.45", fakeForm.get("primitiveDoubleField"), "Primitive double failed");
		Assertions.assertEquals("-7235258.45", fakeForm.get("objectDoubleFieldNonNull"), "Non null Double failed");
		Assertions.assertEquals("", fakeForm.get("objectDoubleFieldNull"), "Null Double failed");
		Assertions.assertEquals("RED", fakeForm.get("enumFieldNonNull"), "Non null Enum failed");
		Assertions.assertEquals("", fakeForm.get("enumFieldNull"), "Null Enum failed");
		Assertions.assertEquals("-345.45", fakeForm.get("primitiveFloatField"), "Primitive float failed");
		Assertions.assertEquals("-345.45", fakeForm.get("objectFloatFieldNonNull"), "Non null Float failed");
		Assertions.assertEquals("", fakeForm.get("objectFloatFieldNull"), "Null Float failed");
		Assertions.assertEquals("23", fakeForm.get("primitiveIntField"), "Primitive int failed");
		Assertions.assertEquals("23", fakeForm.get("objectIntegerFieldNonNull"), "Non null Integer failed");
		Assertions.assertEquals("", fakeForm.get("objectIntegerFieldNull"), "Null Integer failed");
		Assertions.assertEquals("367674", fakeForm.get("primitiveLongField"), "Primitive long failed");
		Assertions.assertEquals("367674", fakeForm.get("objectLongFieldNonNull"), "Non null Long failed");
		Assertions.assertEquals("", fakeForm.get("objectLongFieldNull"), "Null Long failed");
		Assertions.assertEquals("34", fakeForm.get("primitiveShortField"), "Primitive short failed");
		Assertions.assertEquals("34", fakeForm.get("objectShortFieldNonNull"), "Non null Short failed");
		Assertions.assertEquals("", fakeForm.get("objectShortFieldNull"), "Null Short failed");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Ignores a form based on default conversion as it's not FormattableForm")
	@Test
	public void testFormatForms8() {
		DefaultFormFormatter formFormatter;
		DefaultConversionNonFormattableAction action;
		DefaultConversionNonFormattableForm defaultConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		defaultConversionForm = new DefaultConversionNonFormattableForm();
		action = new DefaultConversionNonFormattableAction();
		action.setDefaultConversionNonFormattableForm(defaultConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on default conversion but form is null")
	@Test
	public void testFormatForms9() {
		DefaultFormFormatter formFormatter;
		DefaultConversionAction action;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		action = new DefaultConversionAction();
		action.setDefaultConversionForm(null);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form where all fields use no conversion mode")
	@Test
	public void testFormatForms10() {
		DefaultFormFormatter formFormatter;
		NoConversionAction action;
		NoConversionForm noConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		Map<String,Object> fakeForm;
		
		noConversionForm = new NoConversionForm();
		action = new NoConversionAction();
		action.setNoConversionForm(noConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(1, fakeForms.size(), "Only one fake form should exist");
		fakeForm = fakeForms.get("noConversionForm");
		Assertions.assertNotNull(fakeForm, "noConversionForm fake form should exist");
		Assertions.assertEquals("Our Motto: Apocalypse Now", fakeForm.get("stringNonNull"), "Non null String failed");
		Assertions.assertEquals("", fakeForm.get("stringNull"), "Null String failed");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Ignores a form using only no conversion fields as it's not FormattableForm")
	@Test
	public void testFormatForms11() {
		DefaultFormFormatter formFormatter;
		NoConversionNonFormattableAction action;
		NoConversionNonFormattableForm noConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		noConversionForm = new NoConversionNonFormattableForm();
		action = new NoConversionNonFormattableAction();
		action.setNoConversionNonFormattableForm(noConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form where all fields use no conversion mode but form is null")
	@Test
	public void testFormatForms12() {
		DefaultFormFormatter formFormatter;
		NoConversionAction action;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		action = new NoConversionAction();
		action.setNoConversionForm(null);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on manual parameter and manual conversion")
	@Test
	public void testFormatForms13() {
		DefaultFormFormatter formFormatter;
		ManualParameterConversionAction action;
		ManualParameterConversionForm manualParameterConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		Map<String,Object> fakeForm;
		
		manualParameterConversionForm = new ManualParameterConversionForm();
		action = new ManualParameterConversionAction();
		action.setManualParameterConversionForm(manualParameterConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(1, fakeForms.size(), "Only one fake form should exist");
		fakeForm = fakeForms.get("manualParameterConversionForm");
		Assertions.assertNotNull(fakeForm, "manualParameterConversionForm fake form should exist");
		Assertions.assertEquals("10", fakeForm.get("startDay"), "Day of startDate failed");
		Assertions.assertEquals("12", fakeForm.get("startMonth"), "Month of startDate failed");
		Assertions.assertEquals("1993", fakeForm.get("startYear"), "Year of startDate failed");
		Assertions.assertEquals("25", fakeForm.get("endDay"), "Day of endDate failed");
		Assertions.assertEquals("12", fakeForm.get("endMonth"), "Month of endDate failed");
		Assertions.assertEquals("1993", fakeForm.get("endYear"), "Year of endDate failed");
		Assertions.assertEquals("6", fakeForm.get("score"), "Score failed");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Ignores a form based on manual parameter and manual conversion as it's not formattable")
	@Test
	public void testFormatForms14() {
		DefaultFormFormatter formFormatter;
		ManualParameterConversionNonFormattableAction action;
		ManualParameterConversionNonFormattableForm manualParameterConversionForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		manualParameterConversionForm = new ManualParameterConversionNonFormattableForm();
		action = new ManualParameterConversionNonFormattableAction();
		action.setManualParameterConversionNonFormattableForm(manualParameterConversionForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on manual parameter and manual conversion but form is null")
	@Test
	public void testFormatForms15() {
		DefaultFormFormatter formFormatter;
		ManualParameterConversionAction action;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		action = new ManualParameterConversionAction();
		action.setManualParameterConversionForm(null);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "No fake forms should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on various conversion modes")
	@Test
	public void testFormatForms16() {
		DefaultFormFormatter formFormatter;
		MixedAction action;
		MixedForm mixedForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		Map<String,Object> fakeForm;
		
		mixedForm = new MixedForm();
		action = new MixedAction();
		action.setMixedForm(mixedForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		Assertions.assertEquals("John Romero", mixedForm.getName(), "No conversion name failed");
		Assertions.assertEquals("6", mixedForm.getScore(), "Pair conversion score failed");
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(1, fakeForms.size(), "Only one fake form should exist");
		fakeForm = fakeForms.get("mixedForm");
		Assertions.assertNotNull(fakeForm, "mixedForm fake form should exist");
		Assertions.assertEquals("John Romero", fakeForm.get("name"), "Name failed");
		Assertions.assertEquals("6", fakeForm.get("score"), "Score failed");
		Assertions.assertEquals("619", fakeForm.get("plays"), "Plays failed");
		Assertions.assertEquals("39", fakeForm.get("wins"), "Wins failed");
		Assertions.assertEquals("10", fakeForm.get("startDay"), "StartDay failed");
		Assertions.assertEquals("12", fakeForm.get("startMonth"), "StartMonth failed");
		Assertions.assertEquals("1993", fakeForm.get("startYear"), "StartYear failed");
		Assertions.assertEquals("25", fakeForm.get("endDay"), "EndDay failed");
		Assertions.assertEquals("12", fakeForm.get("endMonth"), "EndMonth failed");
		Assertions.assertEquals("1993", fakeForm.get("endYear"), "EndYear failed");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Ignores form based on various conversion modes as it's not formattable")
	@Test
	public void testFormatForms17() {
		DefaultFormFormatter formFormatter;
		MixedNonFormattableAction action;
		MixedNonFormattableForm mixedForm;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		mixedForm = new MixedNonFormattableForm();
		action = new MixedNonFormattableAction();
		action.setMixedNonFormattableForm(mixedForm);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "Only one fake form should exist");
	}
    
	@SuppressWarnings("unchecked")
	@DisplayName("Formats a form based on various conversion modes but form is null")
	@Test
	public void testFormatForms18() {
		DefaultFormFormatter formFormatter;
		MixedNonFormattableAction action;
		ActionContext actionContext;
		ValueStack valueStack;
		Map<String,Map<String,Object>> fakeForms;
		
		action = new MixedNonFormattableAction();
		action.setMixedNonFormattableForm(null);
		
		actionContext = ActionContext.getContext();
		actionContext.withActionInvocation(new MockActionInvocaton(action, new MockValueStack()));
		formFormatter = new DefaultFormFormatter();
		
		formFormatter.formatForms();
		valueStack = actionContext.getActionInvocation().getStack();
		Assertions.assertEquals(1, valueStack.size(), "Fake formatted forms map should be on the ValueStack");
		fakeForms = (Map<String,Map<String,Object>>)valueStack.peek();
		Assertions.assertEquals(0, fakeForms.size(), "Only one fake form should exist");
	}
    
}
