package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.BooleanConversion;
import name.matthewgreet.strutscommons.policy.BooleanConverter;
import name.matthewgreet.strutscommons.policy.ConversionResult;


public class BooleanConverterUnitTests {
	@BooleanConversion
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		BooleanConversion annotation;
		BooleanConverter booleanConverter;
		ConversionResult<Boolean> result;
		
		annotation = (BooleanConversion)BooleanConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(BooleanConversion.class);
		booleanConverter = new BooleanConverter();
		booleanConverter.setAnnotation(annotation);
		result = booleanConverter.convert("1", Boolean.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(true, result.getParsedValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Other conversion")
	@Test
	public void testConvert2() throws Exception {
		BooleanConversion annotation;
		BooleanConverter booleanConverter;
		ConversionResult<Boolean> result;
		
		annotation = (BooleanConversion)BooleanConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(BooleanConversion.class);
		booleanConverter = new BooleanConverter();
		booleanConverter.setAnnotation(annotation);
		result = booleanConverter.convert("", Boolean.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(false, result.getParsedValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws Exception {
		BooleanConversion annotation;
		BooleanConverter booleanConverter;
		String result;
		
		annotation = (BooleanConversion)BooleanConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(BooleanConversion.class);
		booleanConverter = new BooleanConverter();
		booleanConverter.setAnnotation(annotation);
		result = booleanConverter.format(true);
		Assertions.assertEquals("1", result, "Final value is incorrect");
	}
    
}
