package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.EnumConversion;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import name.matthewgreet.strutscommons.policy.EnumConverter;;


public class EnumConverterUnitTests {
	public enum Fruit {APPLE, BANANA, ORANGE, PEAR, PLUM}
	
	@EnumConversion
	private boolean annotationPlaceholderDefault;
	
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@SuppressWarnings({ "rawtypes" })
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		EnumConversion annotation;
		EnumConverter enumConverter;
		ConversionResult<Enum> result;
		
		annotation = (EnumConversion)EnumConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(EnumConversion.class);
		enumConverter = new EnumConverter();
		enumConverter.setAnnotation(annotation);
		result = enumConverter.convert("ORANGE", Fruit.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(Fruit.ORANGE, result.getParsedValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@SuppressWarnings({ "rawtypes" })
	@DisplayName("Failed conversion")
	@Test
	public void testConvert2() throws Exception {
		EnumConversion annotation;
		EnumConverter enumConverter;
		ConversionResult<Enum> result;
		
		annotation = (EnumConversion)EnumConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(EnumConversion.class);
		enumConverter = new EnumConverter();
		enumConverter.setAnnotation(annotation);
		result = enumConverter.convert("TOMATO", Fruit.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws Exception {
		EnumConversion annotation;
		EnumConverter dateConverter;
		String result;
		
		annotation = (EnumConversion)EnumConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(EnumConversion.class);
		dateConverter = new EnumConverter();
		dateConverter.setAnnotation(annotation);
		result = dateConverter.format(Fruit.PLUM);
		Assertions.assertEquals(result, "PLUM", "Final value is incorrect");
	}
    
}
