package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.policy.IntegerConverter;
import name.matthewgreet.strutscommons.policy.ConversionResult;


public class IntegerConverterUnitTests {
	@IntegerConversion
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		IntegerConversion annotation;
		IntegerConverter integerConverter;
		ConversionResult<Integer> result;
		
		annotation = (IntegerConversion)IntegerConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(IntegerConversion.class);
		integerConverter = new IntegerConverter();
		integerConverter.setAnnotation(annotation);
		result = integerConverter.convert("334579", Integer.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(new Integer("334579"), result.getParsedValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Failed conversion")
	@Test
	public void testConvert2() throws Exception {
		IntegerConversion annotation;
		IntegerConverter integerConverter;
		ConversionResult<Integer> result;
		
		annotation = (IntegerConversion)IntegerConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(IntegerConversion.class);
		integerConverter = new IntegerConverter();
		integerConverter.setAnnotation(annotation);
		result = integerConverter.convert("$334579", Integer.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws Exception {
		IntegerConversion annotation;
		IntegerConverter integerConverter;
		String result;
		
		annotation = (IntegerConversion)IntegerConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(IntegerConversion.class);
		integerConverter = new IntegerConverter();
		integerConverter.setAnnotation(annotation);
		result = integerConverter.format(new Integer("560009"));
		Assertions.assertEquals("560009", result, "Final value is incorrect");
	}
    
}
