package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.IntegerRange;
import name.matthewgreet.strutscommons.policy.IntegerRangeValidator;
import name.matthewgreet.strutscommons.policy.ValidationResult;


public class IntegerRangeValidatorUnitTests {
	@IntegerRange(min = 1, max = 10)
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Validation success")
	@Test
	public void testValidate1() throws Exception {
		IntegerRange annotation;
		IntegerRangeValidator integerRangeValidator;
		ValidationResult result;
		
		annotation = (IntegerRange)IntegerRangeValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(IntegerRange.class);
		integerRangeValidator = new IntegerRangeValidator();
		integerRangeValidator.setAnnotation(annotation);
		result = integerRangeValidator.validate(4);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Lower boundary")
	@Test
	public void testValidate2() throws Exception {
		IntegerRange annotation;
		IntegerRangeValidator integerRangeValidator;
		ValidationResult result;
		
		annotation = (IntegerRange)IntegerRangeValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(IntegerRange.class);
		integerRangeValidator = new IntegerRangeValidator();
		integerRangeValidator.setAnnotation(annotation);
		result = integerRangeValidator.validate(1);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Upper boundary")
	@Test
	public void testValidate3() throws Exception {
		IntegerRange annotation;
		IntegerRangeValidator integerRangeValidator;
		ValidationResult result;
		
		annotation = (IntegerRange)IntegerRangeValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(IntegerRange.class);
		integerRangeValidator = new IntegerRangeValidator();
		integerRangeValidator.setAnnotation(annotation);
		result = integerRangeValidator.validate(10);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Validation failure")
	@Test
	public void testValidate4() throws Exception {
		IntegerRange annotation;
		IntegerRangeValidator integerRangeValidator;
		ValidationResult result;
		
		annotation = (IntegerRange)IntegerRangeValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(IntegerRange.class);
		integerRangeValidator = new IntegerRangeValidator();
		integerRangeValidator.setAnnotation(annotation);
		result = integerRangeValidator.validate(-5);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Just outside lower boundary")
	@Test
	public void testValidate5() throws Exception {
		IntegerRange annotation;
		IntegerRangeValidator integerRangeValidator;
		ValidationResult result;
		
		annotation = (IntegerRange)IntegerRangeValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(IntegerRange.class);
		integerRangeValidator = new IntegerRangeValidator();
		integerRangeValidator.setAnnotation(annotation);
		result = integerRangeValidator.validate(0);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Just outside upper boundary")
	@Test
	public void testValidate6() throws Exception {
		IntegerRange annotation;
		IntegerRangeValidator integerRangeValidator;
		ValidationResult result;
		
		annotation = (IntegerRange)IntegerRangeValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(IntegerRange.class);
		integerRangeValidator = new IntegerRangeValidator();
		integerRangeValidator.setAnnotation(annotation);
		result = integerRangeValidator.validate(11);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
}
