package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.MaxLength;
import name.matthewgreet.strutscommons.policy.MaxLengthValidator;
import name.matthewgreet.strutscommons.policy.ValidationResult;


public class MaxLengthValidatorUnitTests {
	@MaxLength(maxLength = 10)
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Validation passed")
	@Test
	public void testConvert1() throws Exception {
		MaxLength annotation;
		MaxLengthValidator maxLengthValidator;
		ValidationResult result;
		
		annotation = (MaxLength)MaxLengthValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(MaxLength.class);
		maxLengthValidator = new MaxLengthValidator();
		maxLengthValidator.setAnnotation(annotation);
		result = maxLengthValidator.validate("strawberry");
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Validation failed")
	@Test
	public void testConvert2() throws Exception {
		MaxLength annotation;
		MaxLengthValidator maxLengthValidator;
		ValidationResult result;
		
		annotation = (MaxLength)MaxLengthValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(MaxLength.class);
		maxLengthValidator = new MaxLengthValidator();
		maxLengthValidator.setAnnotation(annotation);
		result = maxLengthValidator.validate("strawberry tart");
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
}
