package name.matthewgreet.strutscommons.junit.policy;

import java.util.regex.PatternSyntaxException;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.Regex;
import name.matthewgreet.strutscommons.policy.RegexValidator;
import name.matthewgreet.strutscommons.policy.ValidationResult;


public class RegexValidatorUnitTests {
	@Regex(regex = "^[A-Z]{1,2}\\d[A-Z\\d]?\\s*\\d[A-Z]{2}$")
	private boolean annotationPlaceholderDefault;
	
	@Regex(regex = "^[A-Z]{1,2}\\d[A-Z\\d]?\\s*\\d[A-Z]{2})$")
	private boolean annotationPlaceholderMalformed;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Validation passed")
	@Test
	public void testConvert1() throws Exception {
		Regex annotation;
		RegexValidator regexValidator;
		ValidationResult result;
		
		annotation = (Regex)RegexValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(Regex.class);
		regexValidator = new RegexValidator();
		regexValidator.setAnnotation(annotation);
		result = regexValidator.validate("SW1A 0AA");
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Validation failed")
	@Test
	public void testConvert2() throws Exception {
		Regex annotation;
		RegexValidator regexValidator;
		ValidationResult result;
		
		annotation = (Regex)RegexValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(Regex.class);
		regexValidator = new RegexValidator();
		regexValidator.setAnnotation(annotation);
		result = regexValidator.validate("SW1A 00A");
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Malformed regex")
	@Test
	public void testConvert3() throws Exception {
		Regex annotation;
		RegexValidator regexValidator;
		
		annotation = (Regex)RegexValidatorUnitTests.class.getDeclaredField("annotationPlaceholderMalformed").getAnnotation(Regex.class);
		regexValidator = new RegexValidator();
		regexValidator.setAnnotation(annotation);
		try { 
			regexValidator.validate("SW1A 0AA");
			Assertions.fail("Malformed regex expression should fail");
		}
		catch (PatternSyntaxException e) {
			// Expected
		}
	}
    
}
