package name.matthewgreet.strutscommons.junit.policy;

import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.StringCSVConversion;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import name.matthewgreet.strutscommons.policy.StringCSVConverter;


public class StringCSVConverterUnitTests {
	@StringCSVConversion
	private boolean annotationPlaceholderDefault;
	
	@StringCSVConversion(separator = ":")
	private boolean annotationPlaceholderSeparator;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		StringCSVConversion annotation;
		StringCSVConverter StringCSVConverter;
		ConversionResult<String> result;
		
		annotation = (StringCSVConversion)StringCSVConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(StringCSVConversion.class);
		StringCSVConverter = new StringCSVConverter();
		StringCSVConverter.setAnnotation(annotation);
		result = StringCSVConverter.convert("I,hate,Microsoft", Collection.class, String.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertIterableEquals(Arrays.asList("I","hate","Microsoft"), result.getParsedCollectionValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Alternate separator")
	@Test
	public void testConvert2() throws Exception {
		StringCSVConversion annotation;
		StringCSVConverter StringCSVConverter;
		ConversionResult<String> result;
		
		annotation = (StringCSVConversion)StringCSVConverterUnitTests.class.getDeclaredField("annotationPlaceholderSeparator").getAnnotation(StringCSVConversion.class);
		StringCSVConverter = new StringCSVConverter();
		StringCSVConverter.setAnnotation(annotation);
		result = StringCSVConverter.convert("The snow is melting:And the village is flooded:With children", Collection.class, String.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertIterableEquals(Arrays.asList("The snow is melting", "And the village is flooded", "With children"), result.getParsedCollectionValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Contains empty value")
	@Test
	public void testConvert3() throws Exception {
		StringCSVConversion annotation;
		StringCSVConverter StringCSVConverter;
		ConversionResult<String> result;
		
		annotation = (StringCSVConversion)StringCSVConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(StringCSVConversion.class);
		StringCSVConverter = new StringCSVConverter();
		StringCSVConverter.setAnnotation(annotation);
		result = StringCSVConverter.convert("An ancient pond,,The splash of water", Collection.class, String.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertIterableEquals(Arrays.asList("An ancient pond","","The splash of water"), result.getParsedCollectionValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Starts with empty value")
	@Test
	public void testConvert4() throws Exception {
		StringCSVConversion annotation;
		StringCSVConverter StringCSVConverter;
		ConversionResult<String> result;
		
		annotation = (StringCSVConversion)StringCSVConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(StringCSVConversion.class);
		StringCSVConverter = new StringCSVConverter();
		StringCSVConverter.setAnnotation(annotation);
		result = StringCSVConverter.convert(",A frog jumps in,The splash of water", Collection.class, String.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertIterableEquals(Arrays.asList("","A frog jumps in","The splash of water"), result.getParsedCollectionValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Ends with empty value")
	@Test
	public void testConvert5() throws Exception {
		StringCSVConversion annotation;
		StringCSVConverter StringCSVConverter;
		ConversionResult<String> result;
		
		annotation = (StringCSVConversion)StringCSVConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(StringCSVConversion.class);
		StringCSVConverter = new StringCSVConverter();
		StringCSVConverter.setAnnotation(annotation);
		result = StringCSVConverter.convert("An ancient pond,A frog jumps in,", Collection.class, String.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertIterableEquals(Arrays.asList("An ancient pond","A frog jumps in",""), result.getParsedCollectionValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Single value")
	@Test
	public void testConvert6() throws Exception {
		StringCSVConversion annotation;
		StringCSVConverter StringCSVConverter;
		ConversionResult<String> result;
		
		annotation = (StringCSVConversion)StringCSVConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(StringCSVConversion.class);
		StringCSVConverter = new StringCSVConverter();
		StringCSVConverter.setAnnotation(annotation);
		result = StringCSVConverter.convert("42", Collection.class, String.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertIterableEquals(Arrays.asList("42"), result.getParsedCollectionValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Empty value")
	@Test
	public void testConvert7() throws Exception {
		StringCSVConversion annotation;
		StringCSVConverter StringCSVConverter;
		ConversionResult<String> result;
		
		annotation = (StringCSVConversion)StringCSVConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(StringCSVConversion.class);
		StringCSVConverter = new StringCSVConverter();
		StringCSVConverter.setAnnotation(annotation);
		result = StringCSVConverter.convert("", Collection.class, String.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertIterableEquals(Arrays.asList(), result.getParsedCollectionValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws Exception {
		StringCSVConversion annotation;
		StringCSVConverter StringCSVConverter;
		String result;
		
		annotation = (StringCSVConversion)StringCSVConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(StringCSVConversion.class);
		StringCSVConverter = new StringCSVConverter();
		StringCSVConverter.setAnnotation(annotation);
		result = StringCSVConverter.format(Arrays.asList("Red", "Green", "Blue"));
		Assertions.assertEquals("Red,Green,Blue", result, "Final value is incorrect");
	}
    
}
