package name.matthewgreet.strutscommons.junit.policy;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.ToEndOfDay;
import name.matthewgreet.strutscommons.policy.ToEndOfDayAdjuster;


public class ToEndOfDayAdjusterUnitTests {
	@ToEndOfDay
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("End of day for non-BST date at midnight")
	@Test
	public void testAdjust1() throws Exception {
	    ToEndOfDay annotation;
	    ToEndOfDayAdjuster toEndOfDayAdjuster;
	    Calendar initialCalendar, finalCalendar;
		Date finalValue;
		
		annotation = (ToEndOfDay)ToEndOfDayAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToEndOfDay.class);
		toEndOfDayAdjuster = new ToEndOfDayAdjuster();
		toEndOfDayAdjuster.setAnnotation(annotation);
		initialCalendar = new GregorianCalendar(1980, 2, 12, 0, 0, 0); 
		finalValue = toEndOfDayAdjuster.adjust(initialCalendar.getTime());
		finalCalendar = new GregorianCalendar();
		finalCalendar.setTime(finalValue);
		finalCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
		Assertions.assertEquals(1980, finalCalendar.get(Calendar.YEAR) , "Year incorrectly changed");
        Assertions.assertEquals(2, finalCalendar.get(Calendar.MONTH) , "Month incorrectly changed");
        Assertions.assertEquals(12, finalCalendar.get(Calendar.DAY_OF_MONTH) , "Day incorrectly changed");
        Assertions.assertEquals(23, finalCalendar.get(Calendar.HOUR_OF_DAY) , "Hour incorrectly changed");
        Assertions.assertEquals(59, finalCalendar.get(Calendar.MINUTE) , "Minute incorrectly changed");
        Assertions.assertEquals(59, finalCalendar.get(Calendar.SECOND) , "Second incorrectly changed");
        Assertions.assertEquals(999, finalCalendar.get(Calendar.MILLISECOND) , "Millisecond incorrectly changed");
	}
    
    @DisplayName("End of day for non-BST date at 17:45:21")
    @Test
    public void testAdjust2() throws Exception {
        ToEndOfDay annotation;
        ToEndOfDayAdjuster toEndOfDayAdjuster;
        Calendar initialCalendar, finalCalendar;
        Date finalValue;
        
        annotation = (ToEndOfDay)ToEndOfDayAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToEndOfDay.class);
        toEndOfDayAdjuster = new ToEndOfDayAdjuster();
        toEndOfDayAdjuster.setAnnotation(annotation);
        initialCalendar = new GregorianCalendar(1980, 2, 12, 17, 45, 21); 
        finalValue = toEndOfDayAdjuster.adjust(initialCalendar.getTime());
        finalCalendar = new GregorianCalendar();
        finalCalendar.setTime(finalValue);
        finalCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assertions.assertEquals(1980, finalCalendar.get(Calendar.YEAR) , "Year incorrectly changed");
        Assertions.assertEquals(2, finalCalendar.get(Calendar.MONTH) , "Month incorrectly changed");
        Assertions.assertEquals(12, finalCalendar.get(Calendar.DAY_OF_MONTH) , "Day incorrectly changed");
        Assertions.assertEquals(23, finalCalendar.get(Calendar.HOUR_OF_DAY) , "Hour incorrectly changed");
        Assertions.assertEquals(59, finalCalendar.get(Calendar.MINUTE) , "Minute incorrectly changed");
        Assertions.assertEquals(59, finalCalendar.get(Calendar.SECOND) , "Second incorrectly changed");
        Assertions.assertEquals(999, finalCalendar.get(Calendar.MILLISECOND) , "Millisecond incorrectly changed");
    }
    
    @DisplayName("End of day for BST date at midnight")
    @Test
    public void testAdjust3() throws Exception {
        ToEndOfDay annotation;
        ToEndOfDayAdjuster toEndOfDayAdjuster;
        Calendar initialCalendar, finalCalendar;
        Date finalValue;
        
        annotation = (ToEndOfDay)ToEndOfDayAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToEndOfDay.class);
        toEndOfDayAdjuster = new ToEndOfDayAdjuster();
        toEndOfDayAdjuster.setAnnotation(annotation);
        initialCalendar = new GregorianCalendar(2011, 7, 23, 0, 0, 0); 
        finalValue = toEndOfDayAdjuster.adjust(initialCalendar.getTime());
        finalCalendar = new GregorianCalendar();
        finalCalendar.setTime(finalValue);
        finalCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assertions.assertEquals(2011, finalCalendar.get(Calendar.YEAR) , "Year incorrectly changed");
        Assertions.assertEquals(7, finalCalendar.get(Calendar.MONTH) , "Month incorrectly changed");
        Assertions.assertEquals(23, finalCalendar.get(Calendar.DAY_OF_MONTH) , "Day incorrectly changed");
        Assertions.assertEquals(23, finalCalendar.get(Calendar.HOUR_OF_DAY) , "Hour incorrectly changed");
        Assertions.assertEquals(59, finalCalendar.get(Calendar.MINUTE) , "Minute incorrectly changed");
        Assertions.assertEquals(59, finalCalendar.get(Calendar.SECOND) , "Second incorrectly changed");
        Assertions.assertEquals(999, finalCalendar.get(Calendar.MILLISECOND) , "Millisecond incorrectly changed");
    }
    
    @DisplayName("End of day for BST date at 08:17:23")
    @Test
    public void testAdjust4() throws Exception {
        ToEndOfDay annotation;
        ToEndOfDayAdjuster toEndOfDayAdjuster;
        Calendar initialCalendar, finalCalendar;
        Date finalValue;
        
        annotation = (ToEndOfDay)ToEndOfDayAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToEndOfDay.class);
        toEndOfDayAdjuster = new ToEndOfDayAdjuster();
        toEndOfDayAdjuster.setAnnotation(annotation);
        initialCalendar = new GregorianCalendar(2011, 7, 23, 8, 17, 23); 
        finalValue = toEndOfDayAdjuster.adjust(initialCalendar.getTime());
        finalCalendar = new GregorianCalendar();
        finalCalendar.setTime(finalValue);
        finalCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assertions.assertEquals(2011, finalCalendar.get(Calendar.YEAR) , "Year incorrectly changed");
        Assertions.assertEquals(7, finalCalendar.get(Calendar.MONTH) , "Month incorrectly changed");
        Assertions.assertEquals(23, finalCalendar.get(Calendar.DAY_OF_MONTH) , "Day incorrectly changed");
        Assertions.assertEquals(23, finalCalendar.get(Calendar.HOUR_OF_DAY) , "Hour incorrectly changed");
        Assertions.assertEquals(59, finalCalendar.get(Calendar.MINUTE) , "Minute incorrectly changed");
        Assertions.assertEquals(59, finalCalendar.get(Calendar.SECOND) , "Second incorrectly changed");
        Assertions.assertEquals(999, finalCalendar.get(Calendar.MILLISECOND) , "Millisecond incorrectly changed");
    }
    
}
