package name.matthewgreet.strutscommons.action;

import name.matthewgreet.strutscommons.form.Form;

/**
 * Base class of Struts 2 Action for finding or updating based on form data, or otherwise respond to POST requests.  
 * Concrete subclasses are expected to use an interceptor stack like <CODE>FormDrivenStack</CODE>; see 
 * <A HREF="../interceptor/package-summary.html">interceptor package</A>.
 * 
 * @param <F> Form containing request parameters.
 */
public abstract class AbstractFormDrivenActionSupport<F extends Form> extends AbstractActionSupport implements FormDriven<F> {
    private static final long serialVersionUID = 3570723717239709427L;

    private F form;

    /**
     * Returns a new instance of the form. 
     */
    protected abstract F makeForm();
    
    protected F getForm() {
        return form;
    }

    protected void setForm(F form) {
        this.form = form;
    }
    
    @Override
    public boolean formValidationFailed() {
        return hasErrors();
    }
    
    @Override
    public F getModel() {
        if (form == null) {
            form = makeForm();
        }
        return form;
    }

    @SuppressWarnings("deprecation")
	@Override
    public void validate() {
        if (this instanceof ValidationAware2) {
            form.doValidate2((ValidationAware2)this, this);
        }
        form.doValidate(this, this);
    }

}
