package name.matthewgreet.strutscommons.form;

import org.apache.struts2.Validateable;

import name.matthewgreet.strutscommons.annotation.ManualParameterConversion;
import name.matthewgreet.strutscommons.interceptor.FormFormatterInterceptor;
import name.matthewgreet.strutscommons.util.StrutsMiscellaneousLibrary;

/**
 * Template for Struts 2 forms that receives form data and can be processed by {@link FormFormatterInterceptor} and 
 * {@link StrutsMiscellaneousLibrary#updateDisplay StrutsMiscellaneousLibrary#updateDisplay}.
 */
public abstract class AbstractFormattableForm extends AbstractForm implements FormattableForm {
	private static final long serialVersionUID = 1539462511152335910L;

	/**
	 * <P>Returns formatted text and/or sets string fields from unprocessed form fields of the implementing class.  This 
	 * is the reverse of {@link Form#manualParameterConvert Form#manualParameterConvert} and {@link Validateable#validate}.</P>
	 * 
	 * <P>Unprocessed form fields are those not processed by {@link FormFormatterInterceptor} for a number of reasons.</P>
	 * <UL>
	 *   <LI>Form field is a string, string array, or string collection, which are already formatted.</LI>
	 *   <LI>Form field is annotated with {@link ManualParameterConversion}.</LI>
	 *   <LI>Form field is a non-string array.</LI>
	 *   <LI>Form field is a non-string collection without a converter annotation.</LI>
	 * </UL>
	 */
	public FormatResult format() {
		return new FormatResult();
	}
	
}
