package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.MinInteger;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class MinIntegerValidator extends AbstractPostConversionValidatorSupport<MinInteger,Integer> {

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public Class<Integer> getRecipientClass() {
        return Integer.class;
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

    @Override
    public ValidationResult validate(Integer fieldValue) throws Exception {
        int value;
        
        value = fieldValue.intValue();
        if (value >= getAnnotation().min()) {
            return ValidationResult.makeSuccessResult();
        } else {
            return ValidationResult.makeFailureResult();
        }
    }

}
