/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import name.matthewgreet.strutscommons.util.AnnotationValidatior;
import name.matthewgreet.strutscommons.util.DefaultAnnotationValidatior;
import name.matthewgreet.strutscommons.util.DefaultPolicyLookup;
import name.matthewgreet.strutscommons.util.PolicyLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnnotationValidationInterceptor2
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 2689404505465349761L;
    public static final int PARAM_NAME_MAX_LENGTH = 100;
    private Logger LOG = LogManager.getLogger(AnnotationValidationInterceptor2.class);
    @Inject(value="name.matthewgreet.strutscommons.accept_classes", required=false)
    private String acceptClasses = "";
    @Inject(value="name.matthewgreet.strutscommons.accept_packages", required=false)
    private String acceptPackages = "";
    @Inject(value="name.matthewgreet.strutscommons.classpath_scanning_replace_built_in", required=false)
    private String classpathScanningReplaceBuiltIn = "false";
    @Inject(value="name.matthewgreet.strutscommons.enable_classpath_scanning", required=false)
    private String enableClassScanning = "false";
    @Inject(value="name.matthewgreet.strutscommons.reject_classes", required=false)
    private String rejectClasses = "";
    @Inject(value="name.matthewgreet.strutscommons.reject_packages", required=false)
    private String rejectPackages = "";
    private boolean disabled;
    private int paramNameMaxLength = 100;
    private boolean processUnreferencedFields = false;

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        if (!this.disabled) {
            AnnotationValidatior annotationValidationLibrary = this.makeAnnotationValidationLibrary();
            annotationValidationLibrary.validate();
        }
        return invocation.invoke();
    }

    protected AnnotationValidatior makeAnnotationValidationLibrary() {
        PolicyLookup policyLookup = this.makePolicyLookup();
        DefaultAnnotationValidatior result = new DefaultAnnotationValidatior();
        result.setParamNameMaxLength(this.getParamNameMaxLength());
        result.setProcessUnreferencedFields(this.processUnreferencedFields);
        result.setPolicyLookup(policyLookup);
        return result;
    }

    protected PolicyLookup makePolicyLookup() {
        DefaultPolicyLookup.Configuration configuration = new DefaultPolicyLookup.Configuration();
        configuration.setAcceptClasses(this.acceptClasses);
        configuration.setAcceptPackages(this.acceptPackages);
        configuration.setClasspathScanningReplaceBuiltIn(Boolean.parseBoolean(this.classpathScanningReplaceBuiltIn));
        configuration.setEnableClasspathScanning(Boolean.parseBoolean(this.enableClassScanning));
        configuration.setRejectClasses(this.rejectClasses);
        configuration.setRejectPackages(this.rejectPackages);
        return DefaultPolicyLookup.getInstance(configuration);
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getParamNameMaxLength() {
        return this.paramNameMaxLength;
    }

    public void setParamNameMaxLength(int paramNameMaxLength) {
        this.paramNameMaxLength = paramNameMaxLength;
    }

    public boolean getProcessUnreferencedFields() {
        return this.processUnreferencedFields;
    }

    public void setProcessUnreferencedFields(boolean processUnreferencedFields) {
        this.processUnreferencedFields = processUnreferencedFields;
    }
}

