/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.matthewgreet.strutscommons.action.ValidationAware2;

public class MessageStoreInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -8274766657096416432L;
    public static final String SESSION_STORED_MESSAGES = MessageStoreInterceptor.class + "_STORED_MESSAGES";
    private boolean disabled;

    public String intercept(ActionInvocation invocation) throws Exception {
        String result = invocation.invoke();
        if (!this.disabled && invocation.getAction() instanceof ValidationAware) {
            ValidationAware validationAware = (ValidationAware)invocation.getAction();
            StoredMessages storedMessages = (StoredMessages)ActionContext.getContext().getSession().get(SESSION_STORED_MESSAGES);
            if (storedMessages == null) {
                storedMessages = new StoredMessages();
            }
            storedMessages.getActionErrors().addAll(validationAware.getActionErrors());
            storedMessages.getActionMessages().addAll(validationAware.getActionMessages());
            Map<String, List<String>> allFieldErrors = storedMessages.getFieldErrors();
            for (Map.Entry entrySet : validationAware.getFieldErrors().entrySet()) {
                List<String> fieldErrors = allFieldErrors.get(entrySet.getKey());
                if (fieldErrors == null) {
                    fieldErrors = new ArrayList<String>();
                }
                fieldErrors.addAll((Collection)entrySet.getValue());
                allFieldErrors.put((String)entrySet.getKey(), fieldErrors);
            }
            if (validationAware instanceof ValidationAware2) {
                ValidationAware2 aflAware = (ValidationAware2)validationAware;
                storedMessages.getActionWarnings().addAll(aflAware.getActionWarnings());
            }
            ActionContext.getContext().getSession().put(SESSION_STORED_MESSAGES, storedMessages);
        }
        return result;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public static class StoredMessages {
        private Collection<String> actionErrors = new ArrayList<String>();
        private Collection<String> actionMessages = new ArrayList<String>();
        private Collection<String> actionWarnings = new ArrayList<String>();
        private Map<String, List<String>> fieldErrors = new HashMap<String, List<String>>();

        public Collection<String> getActionErrors() {
            return this.actionErrors;
        }

        public void setActionErrors(Collection<String> actionErrors) {
            this.actionErrors = actionErrors;
        }

        public Collection<String> getActionMessages() {
            return this.actionMessages;
        }

        public void setActionMessages(Collection<String> actionMessages) {
            this.actionMessages = actionMessages;
        }

        public Collection<String> getActionWarnings() {
            return this.actionWarnings;
        }

        public void setActionWarnings(Collection<String> actionWarnings) {
            this.actionWarnings = actionWarnings;
        }

        public Map<String, List<String>> getFieldErrors() {
            return this.fieldErrors;
        }

        public void setFieldErrors(Map<String, List<String>> fieldErrors) {
            this.fieldErrors = fieldErrors;
        }
    }
}

