/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.annotation.ShortConversion;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShortConverter
extends AbstractDefaultConverterSupport<ShortConversion, Short> {
    private static final Logger LOG = LogManager.getLogger(ShortConverter.class);
    @ShortConversion
    private static boolean annotationPlaceholder;

    @Override
    protected ShortConversion makeDefaultAnnotation() {
        try {
            return ShortConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(ShortConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(Short unformattedValue) {
        return unformattedValue.toString();
    }

    @Override
    public Class<Short> getRecipientClass() {
        return Short.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return ((ShortConversion)this.getAnnotation()).messageType();
    }

    @Override
    public String getMessage() {
        return ((ShortConversion)this.getAnnotation()).message();
    }

    @Override
    public String getMessageKey() {
        return ((ShortConversion)this.getAnnotation()).messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return ((ShortConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<Short> convert(String formValue, Class<? extends Short> recipientClass) throws Exception {
        try {
            short parsedValue = Short.parseShort(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

