/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import name.matthewgreet.strutscommons.annotation.BigDecimalConversion;
import name.matthewgreet.strutscommons.annotation.BooleanConversion;
import name.matthewgreet.strutscommons.annotation.ByteConversion;
import name.matthewgreet.strutscommons.annotation.CharacterConversion;
import name.matthewgreet.strutscommons.annotation.CustomAdjuster;
import name.matthewgreet.strutscommons.annotation.CustomCollectionConversion;
import name.matthewgreet.strutscommons.annotation.CustomCollectionPostConversionAdjuster;
import name.matthewgreet.strutscommons.annotation.CustomCollectionPostConversionValidation;
import name.matthewgreet.strutscommons.annotation.CustomConversion;
import name.matthewgreet.strutscommons.annotation.CustomPostConversionAdjuster;
import name.matthewgreet.strutscommons.annotation.CustomPostConversionValidation;
import name.matthewgreet.strutscommons.annotation.CustomValidation;
import name.matthewgreet.strutscommons.annotation.DateConversion;
import name.matthewgreet.strutscommons.annotation.DoubleConversion;
import name.matthewgreet.strutscommons.annotation.EnumConversion;
import name.matthewgreet.strutscommons.annotation.FloatConversion;
import name.matthewgreet.strutscommons.annotation.IntegerCSVConversion;
import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.annotation.IntegerRange;
import name.matthewgreet.strutscommons.annotation.LongConversion;
import name.matthewgreet.strutscommons.annotation.ManualParameterConversion;
import name.matthewgreet.strutscommons.annotation.MaxLength;
import name.matthewgreet.strutscommons.annotation.MinInteger;
import name.matthewgreet.strutscommons.annotation.Regex;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.annotation.RequiredIntegerEntries;
import name.matthewgreet.strutscommons.annotation.ShortConversion;
import name.matthewgreet.strutscommons.annotation.StringCSVConversion;
import name.matthewgreet.strutscommons.annotation.ToEndOfDay;
import name.matthewgreet.strutscommons.annotation.ToLowerCase;
import name.matthewgreet.strutscommons.annotation.ToStartOfDay;
import name.matthewgreet.strutscommons.annotation.ToUpperCase;
import name.matthewgreet.strutscommons.annotation.Trim;
import name.matthewgreet.strutscommons.exception.FormFieldAnnotationTypeMismatchException;
import name.matthewgreet.strutscommons.interceptor.FormStoreInterceptor;
import name.matthewgreet.strutscommons.policy.AbstractAdjusterSupport;
import name.matthewgreet.strutscommons.policy.AbstractCollectionConverterSupport;
import name.matthewgreet.strutscommons.policy.AbstractCollectionPostConversionAdjusterSupport;
import name.matthewgreet.strutscommons.policy.AbstractConverterSupport;
import name.matthewgreet.strutscommons.policy.AbstractNonConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.AbstractPostConversionAdjusterSupport;
import name.matthewgreet.strutscommons.policy.AbstractPostConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.Adjuster;
import name.matthewgreet.strutscommons.policy.BigDecimalConverter;
import name.matthewgreet.strutscommons.policy.BooleanConverter;
import name.matthewgreet.strutscommons.policy.ByteConverter;
import name.matthewgreet.strutscommons.policy.CharacterConverter;
import name.matthewgreet.strutscommons.policy.CollectionConverter;
import name.matthewgreet.strutscommons.policy.CollectionPostConversionAdjuster;
import name.matthewgreet.strutscommons.policy.CollectionPostConversionValidator;
import name.matthewgreet.strutscommons.policy.Converter;
import name.matthewgreet.strutscommons.policy.DateConverter;
import name.matthewgreet.strutscommons.policy.DoubleConverter;
import name.matthewgreet.strutscommons.policy.EnumConverter;
import name.matthewgreet.strutscommons.policy.FloatConverter;
import name.matthewgreet.strutscommons.policy.IntegerCSVConverter;
import name.matthewgreet.strutscommons.policy.IntegerConverter;
import name.matthewgreet.strutscommons.policy.IntegerRangeValidator;
import name.matthewgreet.strutscommons.policy.LongConverter;
import name.matthewgreet.strutscommons.policy.MaxLengthValidator;
import name.matthewgreet.strutscommons.policy.MinIntegerValidator;
import name.matthewgreet.strutscommons.policy.NonConversionValidator;
import name.matthewgreet.strutscommons.policy.Policy;
import name.matthewgreet.strutscommons.policy.PostConversionAdjuster;
import name.matthewgreet.strutscommons.policy.PostConversionValidator;
import name.matthewgreet.strutscommons.policy.RegexValidator;
import name.matthewgreet.strutscommons.policy.RequiredIntegerEntriesValidator;
import name.matthewgreet.strutscommons.policy.RequiredValidator;
import name.matthewgreet.strutscommons.policy.ShortConverter;
import name.matthewgreet.strutscommons.policy.StringCSVConverter;
import name.matthewgreet.strutscommons.policy.ToEndOfDayAdjuster;
import name.matthewgreet.strutscommons.policy.ToLowerCaseAdjuster;
import name.matthewgreet.strutscommons.policy.ToStartOfDayAdjuster;
import name.matthewgreet.strutscommons.policy.ToUpperCaseAdjuster;
import name.matthewgreet.strutscommons.policy.TrimAdjuster;
import name.matthewgreet.strutscommons.util.PolicyLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InterceptorCommonLibrary {
    private static final Logger LOG = LogManager.getLogger(InterceptorCommonLibrary.class);
    private static final String ACTION_CONTEXT_FORMATTED_FORMS = InterceptorCommonLibrary.class.getName() + ".formattedForms";
    private static Set<Class<? extends Annotation>> customAnnotations = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CustomAdjuster.class, CustomCollectionConversion.class, CustomCollectionPostConversionAdjuster.class, CustomCollectionPostConversionValidation.class, CustomConversion.class, CustomPostConversionAdjuster.class, CustomPostConversionValidation.class, CustomValidation.class)));
    public static final String DEFAULT_ACCEPT_CLASSES = "";
    public static final String DEFAULT_ACCEPT_PACKAGES = "";
    public static final String DEFAULT_CLASSPATH_SCANNING_REPLACE_BUILT_IN = "false";
    public static final String DEFAULT_ENABLE_CLASSPATH_SCANNING = "false";
    public static final String DEFAULT_REJECT_CLASSES = "";
    public static final String DEFAULT_REJECT_PACKAGES = "";
    public static final String STRUTS_CONSTANT_ACCEPT_CLASSES = "name.matthewgreet.strutscommons.accept_classes";
    public static final String STRUTS_CONSTANT_ACCEPT_PACKAGES = "name.matthewgreet.strutscommons.accept_packages";
    public static final String STRUTS_CONSTANT_CLASSPATH_SCANNING_REPLACE_BUILT_IN = "name.matthewgreet.strutscommons.classpath_scanning_replace_built_in";
    public static final String STRUTS_CONSTANT_ENABLE_CLASSPATH_SCANNING = "name.matthewgreet.strutscommons.enable_classpath_scanning";
    public static final String STRUTS_CONSTANT_REJECT_CLASSES = "name.matthewgreet.strutscommons.reject_classes";
    public static final String STRUTS_CONSTANT_REJECT_PACKAGES = "name.matthewgreet.strutscommons.reject_packages";

    private static <T> String formatCollectionValue(CollectionConverter<?, T> collectionConverter, Collection<T> unformattedValue) throws Exception {
        if (unformattedValue != null) {
            return collectionConverter.format(unformattedValue);
        }
        return "";
    }

    private static <T> String formatValue(Converter<?, T> converter, T unformattedValue) throws Exception {
        if (unformattedValue != null) {
            return converter.format(unformattedValue);
        }
        return "";
    }

    private static Field getUnformattedField(Collection<Field> fields, String unformattedFieldName) {
        Field result = null;
        for (Field field : fields) {
            if (!field.getName().equals(unformattedFieldName)) continue;
            result = field;
            break;
        }
        return result;
    }

    public static <T> CategoriseFieldResult categoriseFormFields(Collection<Field> formFields, PolicyLookup policyLookup) {
        CategoriseFieldResult result = new CategoriseFieldResult();
        HashMap<String, FieldUsage<T>> allFieldUsages = new HashMap<String, FieldUsage<T>>();
        for (Field formField : formFields) {
            try {
                FieldUsage<T> fieldUsage = InterceptorCommonLibrary.getFormFieldUsage(formField, policyLookup);
                allFieldUsages.put(fieldUsage.getName(), fieldUsage);
            }
            catch (FormFieldAnnotationTypeMismatchException e) {
                LOG.error("Form field annotation is incompatible with form field type and will be skipped  form=" + formField.getDeclaringClass() + "  field=" + formField.getName() + "  annotation=" + e.getAnnotation().annotationType());
            }
        }
        HashMap<String, FieldUsage> autoConversionFieldUsages = new HashMap<String, FieldUsage>();
        HashMap<String, FieldUsage> defaultConversionFieldUsages = new HashMap<String, FieldUsage>();
        HashMap<String, FieldUsage> fileFieldUsages = new HashMap<String, FieldUsage>();
        HashMap<String, FieldUsage> noConversionFieldUsages = new HashMap<String, FieldUsage>();
        HashMap<String, FieldUsage> manualConversionFieldUsages = new HashMap<String, FieldUsage>();
        HashMap<String, FieldUsage> pairConversionFieldUsages = new HashMap<String, FieldUsage>();
        HashMap<String, FieldUsage> setOnlyFieldUsages = new HashMap<String, FieldUsage>();
        for (FieldUsage fieldUsage2 : allFieldUsages.values()) {
            boolean explicitConversion = fieldUsage2.getAnnountationEntries().getConverter() != null || fieldUsage2.getAnnountationEntries().getCollectionConverter() != null;
            boolean manualConversion = fieldUsage2.getAnnountationEntries().getManualParameterConversion();
            FormFieldCategory fieldCategory = InterceptorCommonLibrary.getFormFieldCategory(fieldUsage2);
            switch (fieldCategory.ordinal()) {
                case 0: {
                    fileFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                    break;
                }
                case 1: {
                    if (manualConversion) {
                        manualConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                        break;
                    }
                    if (explicitConversion) {
                        autoConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                        break;
                    }
                    defaultConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                    break;
                }
                case 2: {
                    manualConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                    break;
                }
                case 3: {
                    if (manualConversion) {
                        manualConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                        break;
                    }
                    if (explicitConversion) {
                        autoConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                        break;
                    }
                    defaultConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                    break;
                }
                case 4: {
                    if (manualConversion) {
                        manualConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                        break;
                    }
                    if (explicitConversion) {
                        pairConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                        break;
                    }
                    noConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                    break;
                }
                case 5: {
                    setOnlyFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                    break;
                }
                case 6: {
                    if (manualConversion) {
                        setOnlyFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                        break;
                    }
                    if (explicitConversion) {
                        autoConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                        break;
                    }
                    setOnlyFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                }
            }
        }
        for (FieldUsage formattedFieldUsage : pairConversionFieldUsages.values()) {
            String unformattedFieldName = formattedFieldUsage.getAnnountationEntries().getCollectionConverter() != null ? formattedFieldUsage.getAnnountationEntries().getCollectionConverter().getCollectionConverter().getRecipientFieldName() : formattedFieldUsage.getAnnountationEntries().getConverter().getConverter().getRecipientFieldName();
            if (unformattedFieldName == null || unformattedFieldName.length() == 0) {
                unformattedFieldName = InterceptorCommonLibrary.getDefaultRecipientName(formattedFieldUsage.getName());
            }
            boolean failed = false;
            FieldUsage unformattedFieldUsage = (FieldUsage)defaultConversionFieldUsages.get(unformattedFieldName);
            if (unformattedFieldUsage == null) {
                failed = true;
                noConversionFieldUsages.put(formattedFieldUsage.getName(), formattedFieldUsage);
                LOG.error("Form field annotation refers to non-existent or annotated unformatted field, explicitly or by default, and will be treated as no conversion  form=" + formattedFieldUsage.getField().getDeclaringClass() + "  field=" + formattedFieldUsage.getName() + "  unformattedFieldName=" + unformattedFieldName);
            }
            if (!failed) {
                Class<?> unformattedFieldClass = formattedFieldUsage.getField().getType();
                AnnotationEntries annotationEntries = unformattedFieldUsage.getAnnountationEntries();
                if (annotationEntries.getConverter() != null && !annotationEntries.getConverter().getConverter().getRecipientClass().isAssignableFrom(unformattedFieldClass)) {
                    failed = true;
                    manualConversionFieldUsages.put(formattedFieldUsage.getName(), formattedFieldUsage);
                    manualConversionFieldUsages.put(unformattedFieldUsage.getName(), unformattedFieldUsage);
                    defaultConversionFieldUsages.remove(unformattedFieldName);
                    LOG.error("Unformatted field of formatted/unformatted pair is incompatible with converter, and will be treated as manual parameter conversion  form=" + formattedFieldUsage.getField().getDeclaringClass() + "  formatted field=" + formattedFieldUsage.getName() + "  unformatted field=" + unformattedFieldName);
                } else if (annotationEntries.getCollectionConverter() != null && !annotationEntries.getCollectionConverter().getCollectionConverter().getRecipientClass().isAssignableFrom(unformattedFieldClass)) {
                    failed = true;
                    manualConversionFieldUsages.put(formattedFieldUsage.getName(), formattedFieldUsage);
                    manualConversionFieldUsages.put(unformattedFieldUsage.getName(), unformattedFieldUsage);
                    defaultConversionFieldUsages.remove(unformattedFieldName);
                    LOG.error("Unformatted field of formatted/unformatted pair is incompatible with converter, and will be treated as manual parameter conversion  form=" + formattedFieldUsage.getField().getDeclaringClass() + "  formatted field=" + formattedFieldUsage.getName() + "  unformatted field=" + unformattedFieldName);
                }
                for (ConfiguredPolicy configuredPolicy : annotationEntries.getPostConversionValidators()) {
                    if (configuredPolicy.getPostConversionValidator().getRecipientClass().isAssignableFrom(unformattedFieldClass)) continue;
                    failed = true;
                    manualConversionFieldUsages.put(formattedFieldUsage.getName(), formattedFieldUsage);
                    manualConversionFieldUsages.put(unformattedFieldUsage.getName(), unformattedFieldUsage);
                    defaultConversionFieldUsages.remove(unformattedFieldName);
                    LOG.error("Unformatted field of formatted/unformatted pair is incompatible with post-conversion validator, and will be treated as manual parameter conversion  form=" + formattedFieldUsage.getField().getDeclaringClass() + "  formatted field=" + formattedFieldUsage.getName() + "  unformatted field=" + unformattedFieldName);
                    break;
                }
                for (ConfiguredPolicy configuredPolicy : annotationEntries.getCollectionPostConversionValidators()) {
                    if (configuredPolicy.getCollectionPostConversionValidator().getRecipientClass().isAssignableFrom(unformattedFieldClass)) continue;
                    failed = true;
                    manualConversionFieldUsages.put(formattedFieldUsage.getName(), formattedFieldUsage);
                    manualConversionFieldUsages.put(unformattedFieldUsage.getName(), unformattedFieldUsage);
                    defaultConversionFieldUsages.remove(unformattedFieldName);
                    LOG.error("Unformatted field of formatted/unformatted pair is incompatible with post-conversion validator, and will be treated as manual parameter conversion  form=" + formattedFieldUsage.getField().getDeclaringClass() + "  formatted field=" + formattedFieldUsage.getName() + "  unformatted field=" + unformattedFieldName);
                    break;
                }
            }
            if (failed) continue;
            PairFieldUsage pairFieldUsage = new PairFieldUsage();
            pairFieldUsage.setAnnountationEntries(formattedFieldUsage.getAnnountationEntries());
            pairFieldUsage.setUnformattedName(unformattedFieldUsage.getName());
            pairFieldUsage.setUnformattedField(unformattedFieldUsage.getField());
            pairFieldUsage.setFormattedName(formattedFieldUsage.getName());
            pairFieldUsage.setFormattedField(formattedFieldUsage.getField());
            result.getPairConversionFields().add(pairFieldUsage);
            defaultConversionFieldUsages.remove(unformattedFieldName);
        }
        for (FieldUsage fieldUsage2 : new ArrayList(defaultConversionFieldUsages.values())) {
            if (Collection.class.isAssignableFrom(fieldUsage2.getField().getType())) {
                CollectionConverter<?, ?> defaultCollectionConverter = InterceptorCommonLibrary.getDefaultCollectionConverter(fieldUsage2.getField(), policyLookup);
                if (defaultCollectionConverter != null) {
                    fieldUsage2.getAnnountationEntries().addAnnotationUsageResult(ConfiguredPolicy.makeCollectionConverterResult(defaultCollectionConverter, true));
                    result.getDefaultParameterConversionFields().add(fieldUsage2);
                    continue;
                }
                manualConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
                defaultConversionFieldUsages.remove(fieldUsage2.getName());
                continue;
            }
            Converter<?, ?> defaultConverter = InterceptorCommonLibrary.getDefaultConverter(fieldUsage2.getField(), policyLookup);
            if (defaultConverter != null) {
                fieldUsage2.getAnnountationEntries().addAnnotationUsageResult(ConfiguredPolicy.makeConverterResult(defaultConverter, true));
                result.getDefaultParameterConversionFields().add(fieldUsage2);
                continue;
            }
            manualConversionFieldUsages.put(fieldUsage2.getName(), fieldUsage2);
            defaultConversionFieldUsages.remove(fieldUsage2.getName());
        }
        result.getAutoParameterConversionFields().addAll(autoConversionFieldUsages.values());
        result.getFileFields().addAll(fileFieldUsages.values());
        result.getManualParameterConversionFields().addAll(manualConversionFieldUsages.values());
        result.getNoConversionFields().addAll(noConversionFieldUsages.values());
        result.getSetOnlyFields().addAll(setOnlyFieldUsages.values());
        return result;
    }

    public static <T> boolean checkCollectionRecipientDataType(Field recipientField, Class<T> recipientClass) {
        Class<T> entryClass = InterceptorCommonLibrary.getTypeFromCollectionField(recipientField);
        if (entryClass != null) {
            return InterceptorCommonLibrary.checkFieldClass(recipientClass, entryClass);
        }
        return false;
    }

    public static boolean checkFieldClass(Class<?> conversionClass, Class<?> fieldClass) {
        if (conversionClass == Boolean.class) {
            return Boolean.class.isAssignableFrom(fieldClass) || Boolean.TYPE.isAssignableFrom(fieldClass);
        }
        if (conversionClass == Byte.class) {
            return Byte.class.isAssignableFrom(fieldClass) || Byte.TYPE.isAssignableFrom(fieldClass);
        }
        if (conversionClass == Character.class) {
            return Character.class.isAssignableFrom(fieldClass) || Character.TYPE.isAssignableFrom(fieldClass);
        }
        if (conversionClass == Double.class) {
            return Double.class.isAssignableFrom(fieldClass) || Double.TYPE.isAssignableFrom(fieldClass);
        }
        if (conversionClass == Float.class) {
            return Float.class.isAssignableFrom(fieldClass) || Float.TYPE.isAssignableFrom(fieldClass);
        }
        if (conversionClass == Integer.class) {
            return Integer.class.isAssignableFrom(fieldClass) || Integer.TYPE.isAssignableFrom(fieldClass);
        }
        if (conversionClass == Long.class) {
            return Long.class.isAssignableFrom(fieldClass) || Long.TYPE.isAssignableFrom(fieldClass);
        }
        if (conversionClass == Short.class) {
            return Short.class.isAssignableFrom(fieldClass) || Short.TYPE.isAssignableFrom(fieldClass);
        }
        return conversionClass.isAssignableFrom(fieldClass);
    }

    public static boolean checkRecipientDataType(Field recipientField, Class<?> recipientClass) {
        Class<?> recipientFieldClass = recipientField.getType();
        return InterceptorCommonLibrary.checkFieldClass(recipientClass, recipientFieldClass);
    }

    public static boolean fieldIsNotForm(Field actionField) {
        Class<?> fieldClass = actionField.getType();
        if (fieldClass.isArray()) {
            return true;
        }
        if (fieldClass.isPrimitive()) {
            return true;
        }
        if (Modifier.isStatic(actionField.getModifiers())) {
            return true;
        }
        if (String.class.isAssignableFrom(fieldClass)) {
            return true;
        }
        return Collection.class.isAssignableFrom(fieldClass);
    }

    public static boolean fieldReceivedStoredForm(Field actionField) {
        if (actionField == null) {
            return false;
        }
        FormStoreInterceptor.StoredForm storedForm = InterceptorCommonLibrary.getStoredForm();
        if (storedForm == null) {
            return false;
        }
        if (storedForm.getOwningURL() == null) {
            return false;
        }
        if (actionField.getDeclaringClass() != storedForm.getOwningActionClass()) {
            return false;
        }
        return storedForm.getOwningActionFieldNames().contains(actionField.getName());
    }

    public static Collection<Field> filterNonConversionErrorFormFields(Collection<Field> formFields, Map<String, ConversionData> conversionErrors) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : formFields) {
            if (conversionErrors != null && conversionErrors.containsKey(field.getName())) continue;
            result.add(field);
        }
        return result;
    }

    public static Collection<Field> filterPlausibleFormFields(Collection<Field> formFields) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : formFields) {
            int fieldModifiers = field.getModifiers();
            if (Modifier.isFinal(fieldModifiers) || Modifier.isStatic(fieldModifiers)) continue;
            result.add(field);
        }
        return result;
    }

    public static <T> void formatCollectionFormField(Object form, Collection<Field> allFormFields, Field formField, ConfiguredPolicy<T> configuredPolicy) {
        Field unformattedField;
        String fieldName = formField.getName();
        String unformattedFieldName = configuredPolicy.getCollectionConverter().getRecipientFieldName();
        if (unformattedFieldName == null || unformattedFieldName.length() == 0) {
            unformattedFieldName = InterceptorCommonLibrary.getDefaultRecipientName(fieldName);
        }
        if ((unformattedField = InterceptorCommonLibrary.getUnformattedField(allFormFields, unformattedFieldName)) == null) {
            LOG.error("Form field annotation refers to non-existent unformatted field, explicitly or by default  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + formField.getName() + "  unformattedFieldName=" + unformattedFieldName);
            return;
        }
        boolean compatible = InterceptorCommonLibrary.checkCollectionRecipientDataType(unformattedField, configuredPolicy.getCollectionConverter().getRecipientClass());
        if (!compatible) {
            LOG.error("Unformatted field is not compatible with validator  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + formField.getName() + "  unformattedFieldName=" + unformattedFieldName + "  allowed class=" + configuredPolicy.getCollectionConverter().getRecipientClass());
            return;
        }
        Collection unformattedValue = null;
        try {
            unformattedField.setAccessible(true);
            unformattedValue = (Collection)unformattedField.get(form);
            String formattedText = InterceptorCommonLibrary.formatCollectionValue(configuredPolicy.getCollectionConverter(), unformattedValue);
            formField.setAccessible(true);
            formField.set(form, formattedText);
        }
        catch (Exception e) {
            LOG.error("Setting formatted form field failed  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + formField.getName() + "  unformattedFieldName=" + unformattedFieldName + "  value to format=" + unformattedValue, (Throwable)e);
        }
    }

    public static <T> void formatFormField(Object form, Collection<Field> allFormFields, Field formField, ConfiguredPolicy<T> configuredPolicy) {
        Field unformattedField;
        String fieldName = formField.getName();
        String unformattedFieldName = configuredPolicy.getConverter().getRecipientFieldName();
        if (unformattedFieldName == null || unformattedFieldName.length() == 0) {
            unformattedFieldName = InterceptorCommonLibrary.getDefaultRecipientName(fieldName);
        }
        if ((unformattedField = InterceptorCommonLibrary.getUnformattedField(allFormFields, unformattedFieldName)) == null) {
            LOG.error("Form field annotation refers to non-existent unformatted field, explicitly or by default  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + formField.getName() + "  unformattedFieldName=" + unformattedFieldName);
            return;
        }
        boolean compatible = InterceptorCommonLibrary.checkRecipientDataType(unformattedField, configuredPolicy.getConverter().getRecipientClass());
        if (!compatible) {
            LOG.error("Unformatted field is not compatible with validator  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + formField.getName() + "  unformattedFieldName=" + unformattedFieldName + "  allowed class=" + configuredPolicy.getConverter().getRecipientClass());
            return;
        }
        Object unformattedValue = null;
        try {
            unformattedField.setAccessible(true);
            unformattedValue = unformattedField.get(form);
            String formattedText = InterceptorCommonLibrary.formatValue(configuredPolicy.getConverter(), unformattedValue);
            formField.setAccessible(true);
            formField.set(form, formattedText);
        }
        catch (Exception e) {
            LOG.error("Setting formatted form field failed  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + formField.getName() + "  unformattedFieldName=" + unformattedFieldName + "  value to format=" + unformattedValue, (Throwable)e);
        }
    }

    public static synchronized Map<String, Map<String, Object>> getActionContextFormattedForms() {
        HashMap result = (HashMap)ActionContext.getContext().getContextMap().get(ACTION_CONTEXT_FORMATTED_FORMS);
        if (result == null) {
            result = new HashMap();
            ActionContext.getContext().getContextMap().put(ACTION_CONTEXT_FORMATTED_FORMS, result);
        }
        return result;
    }

    public static <T> AnnotationEntries<T> getAnnotationEntries(Field formField, PolicyLookup policyLookup) {
        AnnotationEntries<T> result = new AnnotationEntries<T>();
        for (Annotation annotation : formField.getAnnotations()) {
            ConfiguredPolicy<T> configuredPolicy;
            try {
                configuredPolicy = InterceptorCommonLibrary.getConfiguredPolicy(annotation, policyLookup);
            }
            catch (Exception e) {
                configuredPolicy = ConfiguredPolicy.makeNAResult(annotation);
                LOG.error("Creation of linked policy for form field failed   form (or helper) class=" + formField.getDeclaringClass() + "  field=" + formField.getName() + "  annotation=" + annotation.annotationType(), (Throwable)e);
            }
            result.addAnnotationUsageResult(configuredPolicy);
        }
        return result;
    }

    public static AnnotationUsage getAnnotationUsageFromPolicyClass(Class<?> policyClass) {
        if (Adjuster.class.isAssignableFrom(policyClass)) {
            return AnnotationUsage.ADJUSTER;
        }
        if (CollectionConverter.class.isAssignableFrom(policyClass)) {
            return AnnotationUsage.COLLECTION_CONVERT;
        }
        if (CollectionPostConversionAdjuster.class.isAssignableFrom(policyClass)) {
            return AnnotationUsage.COLLECTION_POST_ADJUSTER;
        }
        if (CollectionPostConversionValidator.class.isAssignableFrom(policyClass)) {
            return AnnotationUsage.COLLECTION_POST_VALIDATION;
        }
        if (Converter.class.isAssignableFrom(policyClass)) {
            return AnnotationUsage.CONVERT;
        }
        if (NonConversionValidator.class.isAssignableFrom(policyClass)) {
            return AnnotationUsage.NON_CONVERT_VALIDATION;
        }
        if (PostConversionAdjuster.class.isAssignableFrom(policyClass)) {
            return AnnotationUsage.POST_ADJUSTER;
        }
        if (PostConversionValidator.class.isAssignableFrom(policyClass)) {
            return AnnotationUsage.POST_VALIDATION;
        }
        return AnnotationUsage.NA;
    }

    public static List<DefaultCollectionConverterEntry<?, ?>> getBuiltInDefaultCollectionConverters() {
        ArrayList result = new ArrayList();
        result.add(new DefaultCollectionConverterEntry<Integer, IntegerCSVConverter>(Integer.class, IntegerCSVConverter.class, true));
        result.add(new DefaultCollectionConverterEntry<String, StringCSVConverter>(String.class, StringCSVConverter.class, true));
        return result;
    }

    public static List<DefaultConverterEntry<?, ?>> getBuiltInDefaultConverters() {
        ArrayList result = new ArrayList();
        result.add(new DefaultConverterEntry<BigDecimal, BigDecimalConverter>(BigDecimal.class, BigDecimalConverter.class, true));
        result.add(new DefaultConverterEntry<Boolean, BooleanConverter>(Boolean.class, BooleanConverter.class, true));
        result.add(new DefaultConverterEntry<Byte, ByteConverter>(Byte.class, ByteConverter.class, true));
        result.add(new DefaultConverterEntry<Character, CharacterConverter>(Character.class, CharacterConverter.class, true));
        result.add(new DefaultConverterEntry<Date, DateConverter>(Date.class, DateConverter.class, true));
        result.add(new DefaultConverterEntry<Double, DoubleConverter>(Double.class, DoubleConverter.class, true));
        result.add(new DefaultConverterEntry<Enum, EnumConverter>(Enum.class, EnumConverter.class, true));
        result.add(new DefaultConverterEntry<Float, FloatConverter>(Float.class, FloatConverter.class, true));
        result.add(new DefaultConverterEntry<Integer, IntegerConverter>(Integer.class, IntegerConverter.class, true));
        result.add(new DefaultConverterEntry<Long, LongConverter>(Long.class, LongConverter.class, true));
        result.add(new DefaultConverterEntry<Short, ShortConverter>(Short.class, ShortConverter.class, true));
        return result;
    }

    public static List<PolicyEntry<?, ?, ?>> getBuiltInPolicies() {
        ArrayList result = new ArrayList();
        result.add(new PolicyEntry<BigDecimalConversion, BigDecimalConverter, BigDecimal>(BigDecimalConversion.class, BigDecimalConverter.class, BigDecimal.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<BooleanConversion, BooleanConverter, Boolean>(BooleanConversion.class, BooleanConverter.class, Boolean.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<ByteConversion, ByteConverter, Byte>(ByteConversion.class, ByteConverter.class, Byte.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<CharacterConversion, CharacterConverter, Character>(CharacterConversion.class, CharacterConverter.class, Character.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<DateConversion, DateConverter, Date>(DateConversion.class, DateConverter.class, Date.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<DoubleConversion, DoubleConverter, Double>(DoubleConversion.class, DoubleConverter.class, Double.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<EnumConversion, EnumConverter, Enum>(EnumConversion.class, EnumConverter.class, Enum.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<FloatConversion, FloatConverter, Float>(FloatConversion.class, FloatConverter.class, Float.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<IntegerConversion, IntegerConverter, Integer>(IntegerConversion.class, IntegerConverter.class, Integer.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<IntegerCSVConversion, IntegerCSVConverter, Integer>(IntegerCSVConversion.class, IntegerCSVConverter.class, Integer.class, AnnotationUsage.COLLECTION_CONVERT, true, true));
        result.add(new PolicyEntry<IntegerRange, IntegerRangeValidator, Integer>(IntegerRange.class, IntegerRangeValidator.class, Integer.class, AnnotationUsage.POST_VALIDATION, true, false));
        result.add(new PolicyEntry<LongConversion, LongConverter, Long>(LongConversion.class, LongConverter.class, Long.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry(MaxLength.class, MaxLengthValidator.class, null, AnnotationUsage.NON_CONVERT_VALIDATION, true, false));
        result.add(new PolicyEntry<MinInteger, MinIntegerValidator, Integer>(MinInteger.class, MinIntegerValidator.class, Integer.class, AnnotationUsage.POST_VALIDATION, true, false));
        result.add(new PolicyEntry(Regex.class, RegexValidator.class, null, AnnotationUsage.NON_CONVERT_VALIDATION, true, false));
        result.add(new PolicyEntry(Required.class, RequiredValidator.class, null, AnnotationUsage.NON_CONVERT_VALIDATION, true, false));
        result.add(new PolicyEntry<RequiredIntegerEntries, RequiredIntegerEntriesValidator, Integer>(RequiredIntegerEntries.class, RequiredIntegerEntriesValidator.class, Integer.class, AnnotationUsage.COLLECTION_POST_VALIDATION, true, false));
        result.add(new PolicyEntry<ShortConversion, ShortConverter, Short>(ShortConversion.class, ShortConverter.class, Short.class, AnnotationUsage.CONVERT, true, true));
        result.add(new PolicyEntry<StringCSVConversion, StringCSVConverter, String>(StringCSVConversion.class, StringCSVConverter.class, String.class, AnnotationUsage.COLLECTION_CONVERT, true, true));
        result.add(new PolicyEntry<ToEndOfDay, ToEndOfDayAdjuster, Date>(ToEndOfDay.class, ToEndOfDayAdjuster.class, Date.class, AnnotationUsage.POST_ADJUSTER, true, false));
        result.add(new PolicyEntry(ToLowerCase.class, ToLowerCaseAdjuster.class, null, AnnotationUsage.ADJUSTER, true, false));
        result.add(new PolicyEntry<ToStartOfDay, ToStartOfDayAdjuster, Date>(ToStartOfDay.class, ToStartOfDayAdjuster.class, Date.class, AnnotationUsage.POST_ADJUSTER, true, false));
        result.add(new PolicyEntry(ToUpperCase.class, ToUpperCaseAdjuster.class, null, AnnotationUsage.ADJUSTER, true, false));
        result.add(new PolicyEntry(Trim.class, TrimAdjuster.class, null, AnnotationUsage.ADJUSTER, true, false));
        return result;
    }

    public static <T> ConfiguredPolicy<T> getConfiguredPolicy(Annotation annotation, PolicyLookup policyLookup) throws Exception {
        ConfiguredPolicy<Object> result;
        if (annotation instanceof CustomAdjuster) {
            CustomAdjuster customAdjusterAnnotation = (CustomAdjuster)annotation;
            Class<? extends Adjuster<CustomAdjuster>> policyClass = customAdjusterAnnotation.adjusterClass();
            if (Adjuster.class.isAssignableFrom(policyClass)) {
                Constructor<? extends Adjuster<CustomAdjuster>> constructor = policyClass.getConstructor(new Class[0]);
                Adjuster<Annotation> adjuster = constructor.newInstance(new Object[0]);
                adjuster.setAnnotation(customAdjusterAnnotation);
                result = ConfiguredPolicy.makeAdjusterResult(adjuster);
            } else {
                LOG.warn("CustomAdjuster annotation refers to class that doesn't implement Adjuster  annotation=" + annotation.annotationType() + "  adjuster class=" + ((CustomAdjuster)annotation).adjusterClass());
                result = null;
            }
        } else if (annotation instanceof CustomConversion) {
            CustomConversion customConversionAnnotation = (CustomConversion)annotation;
            Class<Converter<CustomConversion, ?>> policyClass = customConversionAnnotation.validatorClass();
            if (Converter.class.isAssignableFrom(policyClass)) {
                Constructor<Converter<CustomConversion, ?>> constructor = policyClass.getConstructor(new Class[0]);
                Converter<CustomConversion, ?> converter = constructor.newInstance(new Object[0]);
                converter.setAnnotation(customConversionAnnotation);
                result = ConfiguredPolicy.makeConverterResult(converter, false);
            } else {
                LOG.warn("CustomConversion annotation refers to class that doesn't implement Converter  annotation=" + annotation.annotationType() + "  converter class=" + ((CustomConversion)annotation).validatorClass());
                result = null;
            }
        } else if (annotation instanceof CustomPostConversionAdjuster) {
            CustomPostConversionAdjuster customPostConversionAdjusterAnnotation = (CustomPostConversionAdjuster)annotation;
            Class<PostConversionAdjuster<CustomPostConversionAdjuster, ?>> policyClass = customPostConversionAdjusterAnnotation.adjusterClass();
            if (PostConversionAdjuster.class.isAssignableFrom(policyClass)) {
                Constructor<PostConversionAdjuster<CustomPostConversionAdjuster, ?>> constructor = policyClass.getConstructor(new Class[0]);
                PostConversionAdjuster<CustomPostConversionAdjuster, ?> postConversionAdjuster = constructor.newInstance(new Object[0]);
                postConversionAdjuster.setAnnotation(customPostConversionAdjusterAnnotation);
                result = ConfiguredPolicy.makePostConversionAdjusterResult(postConversionAdjuster);
            } else {
                LOG.warn("CustomPostConversionAdjuster annotation refers to class that doesn't implement PostConversionAdjuster  annotation=" + annotation.annotationType() + "  converter class=" + ((CustomPostConversionAdjuster)annotation).adjusterClass());
                result = null;
            }
        } else if (annotation instanceof CustomPostConversionValidation) {
            CustomPostConversionValidation customPostConversionValidationAnnotation = (CustomPostConversionValidation)annotation;
            Class<PostConversionValidator<CustomPostConversionValidation, ?>> policyClass = customPostConversionValidationAnnotation.validatorClass();
            if (PostConversionValidator.class.isAssignableFrom(policyClass)) {
                Constructor<PostConversionValidator<CustomPostConversionValidation, ?>> constructor = policyClass.getConstructor(new Class[0]);
                PostConversionValidator<CustomPostConversionValidation, ?> postConversionValidator = constructor.newInstance(new Object[0]);
                postConversionValidator.setAnnotation(customPostConversionValidationAnnotation);
                result = ConfiguredPolicy.makePostConversionValidatorResult(postConversionValidator);
            } else {
                LOG.warn("CustomPostConversionValidation annotation refers to class that doesn't implement PostConversionValidator  annotation=" + annotation.annotationType() + "  converter class=" + ((CustomPostConversionValidation)annotation).validatorClass());
                result = null;
            }
        } else if (annotation instanceof CustomValidation) {
            CustomValidation customValidationAnnotation = (CustomValidation)annotation;
            Class<? extends NonConversionValidator<CustomValidation>> policyClass = customValidationAnnotation.validatorClass();
            if (NonConversionValidator.class.isAssignableFrom(policyClass)) {
                Constructor<? extends NonConversionValidator<CustomValidation>> constructor = policyClass.getConstructor(new Class[0]);
                NonConversionValidator<CustomValidation> nonConversionValidator = constructor.newInstance(new Object[0]);
                nonConversionValidator.setAnnotation(customValidationAnnotation);
                result = ConfiguredPolicy.makeNonConversionValidatorResult(nonConversionValidator);
            } else {
                LOG.warn("CustomValidation annotation refers to class that doesn't implement NonConversionValidator  annotation=" + annotation.annotationType() + "  converter class=" + ((CustomValidation)annotation).validatorClass());
                result = null;
            }
        } else if (annotation instanceof CustomCollectionConversion) {
            CustomCollectionConversion customCollectionConversionAnnotation = (CustomCollectionConversion)annotation;
            Class<CollectionConverter<CustomCollectionConversion, ?>> policyClass = customCollectionConversionAnnotation.validatorClass();
            if (CollectionConverter.class.isAssignableFrom(policyClass)) {
                Constructor<CollectionConverter<CustomCollectionConversion, ?>> constructor = policyClass.getConstructor(new Class[0]);
                CollectionConverter<CustomCollectionConversion, ?> collectionConverter = constructor.newInstance(new Object[0]);
                collectionConverter.setAnnotation(customCollectionConversionAnnotation);
                result = ConfiguredPolicy.makeCollectionConverterResult(collectionConverter, false);
            } else {
                LOG.warn("CustomCollectionConversion annotation refers to class that doesn't implement CollectionConverter  annotation=" + annotation.annotationType() + "  converter class=" + ((CustomConversion)annotation).validatorClass());
                result = null;
            }
        } else if (annotation instanceof CustomCollectionPostConversionAdjuster) {
            CustomCollectionPostConversionAdjuster customCollectionPostConversionAdjusterAnnotation = (CustomCollectionPostConversionAdjuster)annotation;
            Class<CollectionPostConversionAdjuster<CustomCollectionPostConversionAdjuster, ?>> policyClass = customCollectionPostConversionAdjusterAnnotation.adjusterClass();
            if (CollectionPostConversionAdjuster.class.isAssignableFrom(policyClass)) {
                Constructor<CollectionPostConversionAdjuster<CustomCollectionPostConversionAdjuster, ?>> constructor = policyClass.getConstructor(new Class[0]);
                CollectionPostConversionAdjuster<CustomCollectionPostConversionAdjuster, ?> collectionPostConversionAdjuster = constructor.newInstance(new Object[0]);
                collectionPostConversionAdjuster.setAnnotation(customCollectionPostConversionAdjusterAnnotation);
                result = ConfiguredPolicy.makeCollectionPostConversionAdjusterResult(collectionPostConversionAdjuster);
            } else {
                LOG.warn("CustomPostConversionAdjuster annotation refers to class that doesn't implement PostConversionAdjuster  annotation=" + annotation.annotationType() + "  converter class=" + ((CustomPostConversionAdjuster)annotation).adjusterClass());
                result = null;
            }
        } else if (annotation instanceof CustomCollectionPostConversionValidation) {
            CustomCollectionPostConversionValidation customCollectionPostConversionValidationAnnotation = (CustomCollectionPostConversionValidation)annotation;
            Class<CollectionPostConversionValidator<CustomCollectionPostConversionValidation, ?>> policyClass = customCollectionPostConversionValidationAnnotation.validatorClass();
            if (CollectionPostConversionValidator.class.isAssignableFrom(policyClass)) {
                Constructor<CollectionPostConversionValidator<CustomCollectionPostConversionValidation, ?>> constructor = policyClass.getConstructor(new Class[0]);
                CollectionPostConversionValidator<CustomCollectionPostConversionValidation, ?> collectionPostConversionValidator = constructor.newInstance(new Object[0]);
                collectionPostConversionValidator.setAnnotation(customCollectionPostConversionValidationAnnotation);
                result = ConfiguredPolicy.makeCollectionPostConversionValidatorResult(collectionPostConversionValidator);
            } else {
                LOG.warn("CustomCollectionPostConversionValidation annotation refers to class that doesn't implement CollectionPostConversionValidator  annotation=" + annotation.annotationType() + "  converter class=" + ((CustomConversion)annotation).validatorClass());
                result = null;
            }
        } else if (annotation instanceof ManualParameterConversion) {
            result = ConfiguredPolicy.makeManualParameterConversionResult(annotation);
        } else {
            result = null;
            PolicyEntry policyEntry = policyLookup.getPolicyEntry(annotation.annotationType());
            if (policyEntry != null) {
                Class policyClass = policyEntry.getPolicyClass();
                Constructor constructor = policyClass.getConstructor(new Class[0]);
                Policy policy = (Policy)constructor.newInstance(new Object[0]);
                policy.setAnnotation(annotation);
                switch (policyEntry.getAnnotationUsage().ordinal()) {
                    case 0: {
                        result = ConfiguredPolicy.makeAdjusterResult((Adjuster)policy);
                        break;
                    }
                    case 1: {
                        result = ConfiguredPolicy.makeCollectionConverterResult((CollectionConverter)policy, false);
                        break;
                    }
                    case 2: {
                        result = ConfiguredPolicy.makeCollectionPostConversionAdjusterResult((CollectionPostConversionAdjuster)policy);
                        break;
                    }
                    case 3: {
                        result = ConfiguredPolicy.makeCollectionPostConversionValidatorResult((CollectionPostConversionValidator)policy);
                        break;
                    }
                    case 4: {
                        result = ConfiguredPolicy.makeConverterResult((Converter)policy, false);
                        break;
                    }
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        result = ConfiguredPolicy.makeNonConversionValidatorResult((NonConversionValidator)policy);
                        break;
                    }
                    case 8: {
                        result = ConfiguredPolicy.makePostConversionAdjusterResult((PostConversionAdjuster)policy);
                        break;
                    }
                    case 9: {
                        result = ConfiguredPolicy.makePostConversionValidatorResult((PostConversionValidator)policy);
                    }
                }
            } else {
                LOG.debug("Annotation noticed by form field validation but not linked to any policy, which may be a mistake  annotation=" + annotation.annotationType());
            }
            if (result == null) {
                result = ConfiguredPolicy.makeNAResult(annotation);
            }
        }
        return result;
    }

    public static Class<?> getConverterClassLookupFromFormFieldClass(Class<?> fieldClass) {
        Class<Object> result = fieldClass;
        if (Boolean.TYPE.isAssignableFrom(fieldClass)) {
            result = Boolean.class;
        } else if (Byte.TYPE.isAssignableFrom(fieldClass)) {
            result = Byte.class;
        } else if (Character.TYPE.isAssignableFrom(fieldClass)) {
            result = Character.class;
        } else if (Double.TYPE.isAssignableFrom(fieldClass)) {
            result = Double.class;
        } else if (Enum.class.isAssignableFrom(fieldClass)) {
            result = Enum.class;
        } else if (Float.TYPE.isAssignableFrom(fieldClass)) {
            result = Float.class;
        } else if (Integer.TYPE.isAssignableFrom(fieldClass)) {
            result = Integer.class;
        } else if (Long.TYPE.isAssignableFrom(fieldClass)) {
            result = Long.class;
        } else if (Short.TYPE.isAssignableFrom(fieldClass)) {
            result = Short.class;
        }
        return result;
    }

    public static CollectionConverter<?, ?> getDefaultCollectionConverter(Field field, PolicyLookup policyLookup) {
        CollectionConverter result = null;
        Class itemClass = InterceptorCommonLibrary.getTypeFromCollectionField(field);
        DefaultCollectionConverterEntry collectionConverterEntry = policyLookup.getDefaultCollectionConverterEntry(itemClass);
        if (collectionConverterEntry != null) {
            Class collectionConverterClass = collectionConverterEntry.getCollectionConverterClass();
            try {
                result = (CollectionConverter)collectionConverterClass.newInstance();
            }
            catch (Exception e) {
                LOG.error("Creation of collection  converter failed  class=" + collectionConverterClass, (Throwable)e);
                result = null;
            }
        }
        return result;
    }

    public static Converter<?, ?> getDefaultConverter(Field field, PolicyLookup policyLookup) {
        Converter result = null;
        Class<?> fieldClass = field.getType();
        DefaultConverterEntry converterEntry = policyLookup.getDefaultConverterEntry(fieldClass);
        if (converterEntry != null) {
            Class converterClass = converterEntry.getConverterClass();
            try {
                result = (Converter)converterClass.newInstance();
            }
            catch (Exception e) {
                LOG.error("Creation of converter failed  class=" + converterClass, (Throwable)e);
                result = null;
            }
        }
        return result;
    }

    public static Converter<?, ?> getDefaultConverterFromArray(Field field, PolicyLookup policyLookup) {
        Converter result = null;
        Class itemClass = InterceptorCommonLibrary.getTypeFromArrayField(field);
        DefaultConverterEntry converterEntry = policyLookup.getDefaultConverterEntry(itemClass);
        if (converterEntry != null) {
            Class converterClass = converterEntry.getConverterClass();
            try {
                result = (Converter)converterClass.newInstance();
            }
            catch (Exception e) {
                LOG.error("Creation of converter failed  class=" + converterClass, (Throwable)e);
                result = null;
            }
        }
        return result;
    }

    public static Converter<?, ?> getDefaultConverterFromCollection(Field field, PolicyLookup policyLookup) {
        Converter result = null;
        Class itemClass = InterceptorCommonLibrary.getTypeFromCollectionField(field);
        DefaultConverterEntry converterEntry = policyLookup.getDefaultConverterEntry(itemClass);
        if (converterEntry != null) {
            Class converterClass = converterEntry.getConverterClass();
            try {
                result = (Converter)converterClass.newInstance();
            }
            catch (Exception e) {
                LOG.error("Creation of converter failed  class=" + converterClass, (Throwable)e);
                result = null;
            }
        }
        return result;
    }

    public static String getDefaultRecipientName(String fieldName) {
        return "parsed" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static Object getForm(Object action) {
        boolean modelDriven = action instanceof ModelDriven;
        if (modelDriven) {
            return ((ModelDriven)action).getModel();
        }
        return action;
    }

    public static FormFieldCategory getFormFieldCategory(FieldUsage<?> fieldUsage) {
        if (File.class.isAssignableFrom(fieldUsage.getFieldType())) {
            return FormFieldCategory.FILE;
        }
        if (fieldUsage.getArray() && String.class.isAssignableFrom(fieldUsage.getFieldType())) {
            return FormFieldCategory.STRING_ARRAY;
        }
        if (fieldUsage.getArray()) {
            return FormFieldCategory.NON_STRING_ARRAY;
        }
        if (fieldUsage.getCollection() && String.class.isAssignableFrom(fieldUsage.getFieldType())) {
            return FormFieldCategory.STRING_COLLECTION;
        }
        if (fieldUsage.getCollection()) {
            return FormFieldCategory.NON_STRING_COLLECTION;
        }
        if (String.class.isAssignableFrom(fieldUsage.getFieldType())) {
            return FormFieldCategory.STRING;
        }
        return FormFieldCategory.NON_STRING;
    }

    public static <T> FieldUsage<T> getFormFieldUsage(Field formField, PolicyLookup policyLookup) throws FormFieldAnnotationTypeMismatchException {
        AnnotationEntries<T> annotationEntries = InterceptorCommonLibrary.getAnnotationEntries(formField, policyLookup);
        boolean isArray = formField.getType().isArray();
        boolean isCollection = Collection.class.isAssignableFrom(formField.getType());
        Class<Object> fieldType = isArray ? formField.getType().getComponentType() : (isCollection ? InterceptorCommonLibrary.getTypeFromCollectionField(formField) : formField.getType());
        if (!isArray) {
            ConfiguredPolicy<T> converterConfiguredPolicy;
            if (isCollection) {
                ConfiguredPolicy<T> converterConfiguredPolicy2 = annotationEntries.getCollectionConverter();
                if (converterConfiguredPolicy2 != null) {
                    if (fieldType == null) {
                        throw new FormFieldAnnotationTypeMismatchException(converterConfiguredPolicy2.getAnnotation(), formField);
                    }
                    if (!InterceptorCommonLibrary.checkFieldClass(converterConfiguredPolicy2.getCollectionConverter().getRecipientClass(), fieldType)) {
                        throw new FormFieldAnnotationTypeMismatchException(converterConfiguredPolicy2.getAnnotation(), formField);
                    }
                    for (ConfiguredPolicy<T> configuredPolicy : annotationEntries.getCollectionPostConversionValidators()) {
                        if (InterceptorCommonLibrary.checkFieldClass(configuredPolicy.getCollectionPostConversionValidator().getRecipientClass(), fieldType)) continue;
                        throw new FormFieldAnnotationTypeMismatchException(converterConfiguredPolicy2.getAnnotation(), formField);
                    }
                }
            } else if (!String.class.isAssignableFrom(formField.getType()) && (converterConfiguredPolicy = annotationEntries.getConverter()) != null) {
                if (fieldType == null) {
                    throw new FormFieldAnnotationTypeMismatchException(converterConfiguredPolicy.getAnnotation(), formField);
                }
                if (!InterceptorCommonLibrary.checkFieldClass(converterConfiguredPolicy.getConverter().getRecipientClass(), fieldType)) {
                    throw new FormFieldAnnotationTypeMismatchException(converterConfiguredPolicy.getAnnotation(), formField);
                }
                for (ConfiguredPolicy<T> configuredPolicy : annotationEntries.getPostConversionValidators()) {
                    if (InterceptorCommonLibrary.checkFieldClass(configuredPolicy.getPostConversionValidator().getRecipientClass(), fieldType)) continue;
                    throw new FormFieldAnnotationTypeMismatchException(converterConfiguredPolicy.getAnnotation(), formField);
                }
            }
        }
        FieldUsage<Object> result = new FieldUsage<Object>();
        result.setField(formField);
        result.setName(formField.getName());
        result.setAnnountationEntries(annotationEntries);
        result.setFieldType(fieldType);
        result.setArray(isArray);
        result.setCollection(isCollection);
        return result;
    }

    public static Collection<Field> getProperties(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            Field[] declaredfields;
            for (Field declaredfield : declaredfields = c.getDeclaredFields()) {
                int modifiers = declaredfield.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                fields.add(declaredfield);
            }
        }
        return fields;
    }

    public static Field getProperty(Class<?> type, String name) {
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            Field[] declaredFields;
            for (Field f : declaredFields = c.getDeclaredFields()) {
                if (!f.getName().equals(name)) continue;
                return f;
            }
        }
        return null;
    }

    public static FormStoreInterceptor.StoredForm getStoredForm() {
        Object rawObject;
        Map session = ActionContext.getContext().getSession();
        if (session != null && (rawObject = session.get(FormStoreInterceptor.SESSION_STORED_FORM)) != null) {
            if (rawObject instanceof FormStoreInterceptor.StoredForm) {
                return (FormStoreInterceptor.StoredForm)rawObject;
            }
            LOG.warn("Session attribute is not a stored form  session attribute=" + FormStoreInterceptor.SESSION_STORED_FORM + "  value=" + rawObject);
        }
        return null;
    }

    public static <T> Class<T> getTypeFromArrayField(Field recipientField) {
        if (!recipientField.getType().isArray()) {
            return null;
        }
        Class<?> recipientFieldClass = recipientField.getType().getComponentType();
        return recipientFieldClass;
    }

    public static <T> Class<T> getTypeFromCollectionField(Field recipientField) {
        Class<?> recipientFieldClass = recipientField.getType();
        if (!Collection.class.isAssignableFrom(recipientFieldClass)) {
            return null;
        }
        Type[] recipientEntryTypes = ((ParameterizedType)recipientField.getGenericType()).getActualTypeArguments();
        if (recipientEntryTypes.length != 1) {
            return null;
        }
        if (recipientEntryTypes[0] instanceof Class) {
            return (Class)recipientEntryTypes[0];
        }
        if (recipientEntryTypes[0] instanceof ParameterizedType) {
            return (Class)((ParameterizedType)recipientEntryTypes[0]).getRawType();
        }
        return null;
    }

    public static <A extends Annotation> boolean isCustomAnnotationClass(Class<A> annotationClass) {
        return customAnnotations.contains(annotationClass);
    }

    public static <T> Collection<T> makeCollectionForRecipient(Class<?> recipientClass) {
        if (BlockingQueue.class.isAssignableFrom(recipientClass)) {
            return new LinkedBlockingQueue();
        }
        if (Deque.class.isAssignableFrom(recipientClass)) {
            return new LinkedList();
        }
        if (List.class.isAssignableFrom(recipientClass)) {
            return new ArrayList();
        }
        if (NavigableSet.class.isAssignableFrom(recipientClass)) {
            return new TreeSet();
        }
        if (Queue.class.isAssignableFrom(recipientClass)) {
            return new LinkedList();
        }
        if (SortedSet.class.isAssignableFrom(recipientClass)) {
            return new TreeSet();
        }
        if (Set.class.isAssignableFrom(recipientClass)) {
            return new HashSet();
        }
        if (TransferQueue.class.isAssignableFrom(recipientClass)) {
            return new LinkedTransferQueue();
        }
        return new ArrayList();
    }

    public static class CategoriseFieldResult {
        private Collection<FieldUsage<?>> autoParameterConversionFields = new ArrayList();
        private Collection<FieldUsage<?>> defaultParameterConversionFields = new ArrayList();
        private Collection<FieldUsage<?>> fileFields = new ArrayList();
        private Collection<FieldUsage<?>> manualParameterConversionFields = new ArrayList();
        private Collection<FieldUsage<?>> noConversionFields = new ArrayList();
        private Collection<PairFieldUsage<?>> pairConversionFields = new ArrayList();
        private Collection<FieldUsage<?>> setOnlyFields = new ArrayList();

        public Collection<FieldUsage<?>> getAutoParameterConversionFields() {
            return this.autoParameterConversionFields;
        }

        public Collection<FieldUsage<?>> getDefaultParameterConversionFields() {
            return this.defaultParameterConversionFields;
        }

        public Collection<FieldUsage<?>> getFileFields() {
            return this.fileFields;
        }

        public Collection<FieldUsage<?>> getManualParameterConversionFields() {
            return this.manualParameterConversionFields;
        }

        public Collection<FieldUsage<?>> getNoConversionFields() {
            return this.noConversionFields;
        }

        public Collection<PairFieldUsage<?>> getPairConversionFields() {
            return this.pairConversionFields;
        }

        public Collection<FieldUsage<?>> getSetOnlyFields() {
            return this.setOnlyFields;
        }

        public void setAutoParameterConversionFields(Collection<FieldUsage<?>> autoParameterConversionFields) {
            this.autoParameterConversionFields = autoParameterConversionFields;
        }

        public void setDefaultParameterConversionFields(Collection<FieldUsage<?>> defaultParameterConversionFields) {
            this.defaultParameterConversionFields = defaultParameterConversionFields;
        }

        public void setFileFields(Collection<FieldUsage<?>> fileFields) {
            this.fileFields = fileFields;
        }

        public void setManualParameterConversionFields(Collection<FieldUsage<?>> manualParameterConversionFields) {
            this.manualParameterConversionFields = manualParameterConversionFields;
        }

        public void setNoConversionFields(Collection<FieldUsage<?>> noConversionFields) {
            this.noConversionFields = noConversionFields;
        }

        public void setPairConversionFields(Collection<PairFieldUsage<?>> pairConversionFields) {
            this.pairConversionFields = pairConversionFields;
        }

        public void setSetOnlyFields(Collection<FieldUsage<?>> setOnlyFields) {
            this.setOnlyFields = setOnlyFields;
        }

        public String toString() {
            int maxLen = 10;
            return "CategoriseFieldResult [" + (this.autoParameterConversionFields != null ? "autoParameterConversionFields=" + this.toString(this.autoParameterConversionFields, 10) + ", " : "") + (this.defaultParameterConversionFields != null ? "defaultParameterConversionFields=" + this.toString(this.defaultParameterConversionFields, 10) + ", " : "") + (this.fileFields != null ? "fileFields=" + this.toString(this.fileFields, 10) + ", " : "") + (this.manualParameterConversionFields != null ? "manualParameterConversionFields=" + this.toString(this.manualParameterConversionFields, 10) + ", " : "") + (this.noConversionFields != null ? "noConversionFields=" + this.toString(this.noConversionFields, 10) + ", " : "") + (this.pairConversionFields != null ? "pairConversionFields=" + this.toString(this.pairConversionFields, 10) + ", " : "") + (this.setOnlyFields != null ? "setOnlyFields=" + this.toString(this.setOnlyFields, 10) : "") + "]";
        }

        private String toString(Collection<?> collection, int maxLen) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            Iterator<?> iterator = collection.iterator();
            for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(iterator.next());
            }
            builder.append("]");
            return builder.toString();
        }
    }

    public static class FieldUsage<T> {
        private AnnotationEntries<T> annountationEntries;
        private Field field;
        private String name;
        private Class<T> fieldType;
        private boolean collection;
        private boolean array;

        public AnnotationEntries<T> getAnnountationEntries() {
            return this.annountationEntries;
        }

        public boolean getArray() {
            return this.array;
        }

        public boolean getCollection() {
            return this.collection;
        }

        public Field getField() {
            return this.field;
        }

        public Class<T> getFieldType() {
            return this.fieldType;
        }

        public String getName() {
            return this.name;
        }

        public void setAnnountationEntries(AnnotationEntries<T> annountationEntries) {
            this.annountationEntries = annountationEntries;
        }

        public void setArray(boolean array) {
            this.array = array;
        }

        public void setCollection(boolean collection) {
            this.collection = collection;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public void setFieldType(Class<T> fieldType) {
            this.fieldType = fieldType;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "FieldUsage [annountationEntries=" + this.annountationEntries + ", field=" + this.field + ", name=" + this.name + ", fieldType=" + this.fieldType + ", collection=" + this.collection + ", array=" + this.array + "]";
        }
    }

    public static class AnnotationEntries<T> {
        private List<ConfiguredPolicy<T>> adjusters = new ArrayList<ConfiguredPolicy<T>>();
        private ConfiguredPolicy<T> collectionConverter = null;
        private List<ConfiguredPolicy<T>> collectionPostConversionAdjusters;
        private List<ConfiguredPolicy<T>> collectionPostConversionValidators;
        private ConfiguredPolicy<T> converter = null;
        private boolean manualParameterConversion = false;
        private List<ConfiguredPolicy<T>> postConversionAdjusters;
        private List<ConfiguredPolicy<T>> postConversionValidators;
        private List<ConfiguredPolicy<T>> validators = new ArrayList<ConfiguredPolicy<T>>();

        public AnnotationEntries() {
            this.postConversionAdjusters = new ArrayList<ConfiguredPolicy<T>>();
            this.collectionPostConversionAdjusters = new ArrayList<ConfiguredPolicy<T>>();
            this.postConversionValidators = new ArrayList<ConfiguredPolicy<T>>();
            this.collectionPostConversionValidators = new ArrayList<ConfiguredPolicy<T>>();
        }

        public void addAnnotationUsageResult(ConfiguredPolicy<T> annotationUsageResult) {
            switch (annotationUsageResult.getAnnotationUsage().ordinal()) {
                case 0: {
                    this.adjusters.add(annotationUsageResult);
                    break;
                }
                case 1: {
                    this.collectionConverter = annotationUsageResult;
                    break;
                }
                case 2: {
                    this.collectionPostConversionAdjusters.add(annotationUsageResult);
                    break;
                }
                case 3: {
                    this.collectionPostConversionValidators.add(annotationUsageResult);
                    break;
                }
                case 4: {
                    this.converter = annotationUsageResult;
                    break;
                }
                case 5: {
                    this.manualParameterConversion = true;
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    this.validators.add(annotationUsageResult);
                    break;
                }
                case 8: {
                    this.postConversionAdjusters.add(annotationUsageResult);
                    break;
                }
                case 9: {
                    this.postConversionValidators.add(annotationUsageResult);
                }
            }
        }

        public List<ConfiguredPolicy<T>> getAdjusters() {
            return this.adjusters;
        }

        public ConfiguredPolicy<T> getCollectionConverter() {
            return this.collectionConverter;
        }

        public List<ConfiguredPolicy<T>> getCollectionPostConversionAdjusters() {
            return this.collectionPostConversionAdjusters;
        }

        public List<ConfiguredPolicy<T>> getCollectionPostConversionValidators() {
            return this.collectionPostConversionValidators;
        }

        public ConfiguredPolicy<T> getConverter() {
            return this.converter;
        }

        public boolean getHasNoAnnotations() {
            return this.adjusters.size() == 0 && this.collectionConverter == null && this.collectionPostConversionValidators.size() == 0 && this.converter == null && !this.manualParameterConversion && this.postConversionValidators.size() == 0 && this.validators.size() == 0;
        }

        public boolean getManualParameterConversion() {
            return this.manualParameterConversion;
        }

        public List<ConfiguredPolicy<T>> getPostConversionAdjusters() {
            return this.postConversionAdjusters;
        }

        public List<ConfiguredPolicy<T>> getPostConversionValidators() {
            return this.postConversionValidators;
        }

        public List<ConfiguredPolicy<T>> getValidators() {
            return this.validators;
        }

        public String toString() {
            int maxLen = 10;
            return "AnnotationEntries [" + (this.adjusters != null ? "adjusters=" + this.adjusters.subList(0, Math.min(this.adjusters.size(), 10)) + ", " : "") + (this.collectionConverter != null ? "collectionConverter=" + this.collectionConverter + ", " : "") + (this.collectionPostConversionAdjusters != null ? "collectionPostConversionAdjusters=" + this.collectionPostConversionAdjusters.subList(0, Math.min(this.collectionPostConversionAdjusters.size(), 10)) + ", " : "") + (this.collectionPostConversionValidators != null ? "collectionPostConversionValidators=" + this.collectionPostConversionValidators.subList(0, Math.min(this.collectionPostConversionValidators.size(), 10)) + ", " : "") + (this.converter != null ? "converter=" + this.converter + ", " : "") + "manualParameterConversion=" + this.manualParameterConversion + ", " + (this.postConversionAdjusters != null ? "postConversionAdjusters=" + this.postConversionAdjusters.subList(0, Math.min(this.postConversionAdjusters.size(), 10)) + ", " : "") + (this.postConversionValidators != null ? "postConversionValidators=" + this.postConversionValidators.subList(0, Math.min(this.postConversionValidators.size(), 10)) + ", " : "") + (this.validators != null ? "validators=" + this.validators.subList(0, Math.min(this.validators.size(), 10)) : "") + "]";
        }
    }

    public static class ConfiguredPolicy<T>
    implements Serializable {
        private static final long serialVersionUID = -3300262924248884585L;
        private AnnotationUsage annotationUsage = AnnotationUsage.NA;
        private Annotation annotation = null;
        private boolean defaultAnnotation;
        private Adjuster<?> adjuster = null;
        private CollectionConverter<?, T> collectionConverter = null;
        private CollectionPostConversionAdjuster<?, T> collectionPostConversionAdjuster = null;
        private CollectionPostConversionValidator<?, T> collectionPostConversionValidator = null;
        private Converter<?, T> converter = null;
        private NonConversionValidator<?> nonConversionValidator = null;
        private PostConversionAdjuster<?, T> postConversionAdjuster = null;
        private PostConversionValidator<?, T> postConversionValidator = null;

        public static <T> ConfiguredPolicy<T> makeAdjusterResult(Adjuster<Annotation> adjuster) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.ADJUSTER;
            result.annotation = adjuster.getAnnotation();
            result.adjuster = adjuster;
            return result;
        }

        public static <T> ConfiguredPolicy<T> makeCollectionConverterResult(CollectionConverter<?, T> collectionConverter, boolean defaultAnnotation) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.COLLECTION_CONVERT;
            result.annotation = collectionConverter.getAnnotation();
            result.defaultAnnotation = defaultAnnotation;
            result.collectionConverter = collectionConverter;
            return result;
        }

        public static <T> ConfiguredPolicy<T> makeCollectionPostConversionAdjusterResult(CollectionPostConversionAdjuster<?, T> collectionPostConversionAdjuster) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.COLLECTION_POST_ADJUSTER;
            result.annotation = collectionPostConversionAdjuster.getAnnotation();
            result.collectionPostConversionAdjuster = collectionPostConversionAdjuster;
            return result;
        }

        public static <T> ConfiguredPolicy<T> makeCollectionPostConversionValidatorResult(CollectionPostConversionValidator<?, T> collectionPostConversionValidator) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.COLLECTION_POST_VALIDATION;
            result.annotation = collectionPostConversionValidator.getAnnotation();
            result.collectionPostConversionValidator = collectionPostConversionValidator;
            return result;
        }

        public static <T> ConfiguredPolicy<T> makeConverterResult(Converter<?, T> converter, boolean defaultAnnotation) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.CONVERT;
            result.annotation = converter.getAnnotation();
            result.defaultAnnotation = defaultAnnotation;
            result.converter = converter;
            return result;
        }

        public static <T> ConfiguredPolicy<T> makeManualParameterConversionResult(Annotation annotation) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.MANUAL_PARAMETER_CONVERSION;
            result.annotation = annotation;
            return result;
        }

        public static <T> ConfiguredPolicy<T> makeNAResult(Annotation annotation) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.NA;
            result.annotation = annotation;
            return result;
        }

        public static <T> ConfiguredPolicy<T> makeNonConversionValidatorResult(NonConversionValidator<?> nonConversionValidator) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.NON_CONVERT_VALIDATION;
            result.annotation = nonConversionValidator.getAnnotation();
            result.nonConversionValidator = nonConversionValidator;
            return result;
        }

        public static <T> ConfiguredPolicy<T> makePostConversionAdjusterResult(PostConversionAdjuster<?, T> postConversionAdjuster) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.POST_ADJUSTER;
            result.annotation = postConversionAdjuster.getAnnotation();
            result.postConversionAdjuster = postConversionAdjuster;
            return result;
        }

        public static <T> ConfiguredPolicy<T> makePostConversionValidatorResult(PostConversionValidator<?, T> postConversionValidator) {
            ConfiguredPolicy<T> result = new ConfiguredPolicy<T>();
            result.annotationUsage = AnnotationUsage.POST_VALIDATION;
            result.annotation = postConversionValidator.getAnnotation();
            result.postConversionValidator = postConversionValidator;
            return result;
        }

        private ConfiguredPolicy() {
        }

        public Adjuster<?> getAdjuster() {
            return this.adjuster;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public AnnotationUsage getAnnotationUsage() {
            return this.annotationUsage;
        }

        public CollectionConverter<?, T> getCollectionConverter() {
            return this.collectionConverter;
        }

        public CollectionPostConversionAdjuster<?, T> getCollectionPostConversionAdjuster() {
            return this.collectionPostConversionAdjuster;
        }

        public CollectionPostConversionValidator<?, T> getCollectionPostConversionValidator() {
            return this.collectionPostConversionValidator;
        }

        public Converter<?, T> getConverter() {
            return this.converter;
        }

        public boolean getDefaultAnnotation() {
            return this.defaultAnnotation;
        }

        public NonConversionValidator<?> getNonConversionValidator() {
            return this.nonConversionValidator;
        }

        public PostConversionAdjuster<?, T> getPostConversionAdjuster() {
            return this.postConversionAdjuster;
        }

        public PostConversionValidator<?, T> getPostConversionValidator() {
            return this.postConversionValidator;
        }

        public String toString() {
            return "ConfiguredPolicy [" + (this.annotationUsage != null ? "annotationUsage=" + (Object)((Object)this.annotationUsage) + ", " : "") + (this.annotation != null ? "annotation=" + this.annotation + ", " : "") + "defaultAnnotation=" + this.defaultAnnotation + ", " + (this.adjuster != null ? "adjuster=" + this.adjuster + ", " : "") + (this.collectionConverter != null ? "collectionConverter=" + this.collectionConverter + ", " : "") + (this.collectionPostConversionAdjuster != null ? "collectionPostConversionAdjuster=" + this.collectionPostConversionAdjuster + ", " : "") + (this.collectionPostConversionValidator != null ? "collectionPostConversionValidator=" + this.collectionPostConversionValidator + ", " : "") + (this.converter != null ? "converter=" + this.converter + ", " : "") + (this.nonConversionValidator != null ? "nonConversionValidator=" + this.nonConversionValidator + ", " : "") + (this.postConversionAdjuster != null ? "postConversionAdjuster=" + this.postConversionAdjuster + ", " : "") + (this.postConversionValidator != null ? "postConversionValidator=" + this.postConversionValidator : "") + "]";
        }
    }

    public static enum FormFieldCategory {
        FILE,
        NON_STRING,
        NON_STRING_ARRAY,
        NON_STRING_COLLECTION,
        STRING,
        STRING_ARRAY,
        STRING_COLLECTION;

    }

    public static class PairFieldUsage<T> {
        private AnnotationEntries<T> annountationEntries;
        private Field formattedField;
        private String formattedName;
        private Field unformattedField;
        private String unformattedName;

        public AnnotationEntries<T> getAnnountationEntries() {
            return this.annountationEntries;
        }

        public Field getFormattedField() {
            return this.formattedField;
        }

        public String getFormattedName() {
            return this.formattedName;
        }

        public Field getUnformattedField() {
            return this.unformattedField;
        }

        public String getUnformattedName() {
            return this.unformattedName;
        }

        public void setAnnountationEntries(AnnotationEntries<T> annountationEntries) {
            this.annountationEntries = annountationEntries;
        }

        public void setFormattedField(Field formattedField) {
            this.formattedField = formattedField;
        }

        public void setFormattedName(String formattedName) {
            this.formattedName = formattedName;
        }

        public void setUnformattedField(Field unformattedField) {
            this.unformattedField = unformattedField;
        }

        public void setUnformattedName(String unformattedName) {
            this.unformattedName = unformattedName;
        }

        public String toString() {
            return "PairFieldUsage [annountationEntries=" + this.annountationEntries + ", formattedField=" + this.formattedField + ", formattedName=" + this.formattedName + ", unformattedField=" + this.unformattedField + ", unformattedName=" + this.unformattedName + "]";
        }
    }

    public static enum AnnotationUsage {
        ADJUSTER(Adjuster.class, 0, null, AbstractAdjusterSupport.class, 0, null),
        COLLECTION_CONVERT(CollectionConverter.class, 0, 1, AbstractCollectionConverterSupport.class, 0, 1),
        COLLECTION_POST_ADJUSTER(CollectionPostConversionAdjuster.class, 0, 1, AbstractCollectionPostConversionAdjusterSupport.class, 0, 1),
        COLLECTION_POST_VALIDATION(CollectionPostConversionValidator.class, 0, 1, CollectionPostConversionValidator.class, 0, 1),
        CONVERT(Converter.class, 0, 1, AbstractConverterSupport.class, 0, 1),
        MANUAL_PARAMETER_CONVERSION(null, 0, null, null, 0, null),
        NA(null, 0, null, null, 0, null),
        NON_CONVERT_VALIDATION(NonConversionValidator.class, 0, null, AbstractNonConversionValidatorSupport.class, 0, null),
        POST_ADJUSTER(PostConversionAdjuster.class, 0, 1, AbstractPostConversionAdjusterSupport.class, 0, 1),
        POST_VALIDATION(PostConversionValidator.class, 0, 1, AbstractPostConversionValidatorSupport.class, 0, 1);

        private Class<?> directInterface;
        private int directInterfaceAnnotationIndex;
        private Integer directInterfaceRecipientTypeIndex;
        private Class<?> supportClass;
        private int supportClassAnnotationIndex;
        private Integer supportClassRecipientTypeIndex;

        private AnnotationUsage(Class<?> directInterface, int directInterfaceAnnotationIndex, Integer directInterfaceRecipientTypeIndex, Class<?> supportClass, int supportClassAnnotationIndex, Integer supportClassRecipientTypeIndex) {
            this.directInterface = directInterface;
            this.directInterfaceAnnotationIndex = directInterfaceAnnotationIndex;
            this.directInterfaceRecipientTypeIndex = directInterfaceRecipientTypeIndex;
            this.supportClass = supportClass;
            this.supportClassAnnotationIndex = supportClassAnnotationIndex;
            this.supportClassRecipientTypeIndex = supportClassRecipientTypeIndex;
        }

        public Class<?> getDirectInterface() {
            return this.directInterface;
        }

        public int getDirectInterfaceAnnotationIndex() {
            return this.directInterfaceAnnotationIndex;
        }

        public Integer getDirectInterfaceRecipientTypeIndex() {
            return this.directInterfaceRecipientTypeIndex;
        }

        public Class<?> getSupportClass() {
            return this.supportClass;
        }

        public int getSupportClassAnnotationIndex() {
            return this.supportClassAnnotationIndex;
        }

        public Integer getSupportClassRecipientTypeIndex() {
            return this.supportClassRecipientTypeIndex;
        }
    }

    public static class DefaultCollectionConverterEntry<T, C extends CollectionConverter<?, T>> {
        private Class<T> itemClass;
        private Class<C> collectionConverterClass;
        private boolean builtIn;

        public DefaultCollectionConverterEntry(Class<T> itemClass, Class<C> collectionConverterClass, boolean builtIn) {
            this.itemClass = itemClass;
            this.collectionConverterClass = collectionConverterClass;
            this.builtIn = builtIn;
        }

        public boolean getBuiltIn() {
            return this.builtIn;
        }

        public Class<C> getCollectionConverterClass() {
            return this.collectionConverterClass;
        }

        public Class<T> getItemClass() {
            return this.itemClass;
        }

        public String toString() {
            return "DefaultCollectionConverterEntry [" + (this.itemClass != null ? "itemClass=" + this.itemClass + ", " : "") + (this.collectionConverterClass != null ? "collectionConverterClass=" + this.collectionConverterClass + ", " : "") + "builtIn=" + this.builtIn + "]";
        }

        public int hashCode() {
            return Objects.hash(this.builtIn, this.collectionConverterClass, this.itemClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultCollectionConverterEntry other = (DefaultCollectionConverterEntry)obj;
            return this.builtIn == other.builtIn && Objects.equals(this.collectionConverterClass, other.collectionConverterClass) && Objects.equals(this.itemClass, other.itemClass);
        }
    }

    public static class DefaultConverterEntry<T, C extends Converter<?, T>> {
        private Class<T> fieldClass;
        private Class<C> converterClass;
        private boolean builtIn;

        public DefaultConverterEntry(Class<T> fieldClass, Class<C> converterClass, boolean builtIn) {
            this.fieldClass = fieldClass;
            this.converterClass = converterClass;
            this.builtIn = builtIn;
        }

        public boolean getBuiltIn() {
            return this.builtIn;
        }

        public Class<C> getConverterClass() {
            return this.converterClass;
        }

        public Class<T> getFieldClass() {
            return this.fieldClass;
        }

        public String toString() {
            return "DefaultConverterEntry [" + (this.fieldClass != null ? "fieldClass=" + this.fieldClass + ", " : "") + (this.converterClass != null ? "converterClass=" + this.converterClass + ", " : "") + "builtIn=" + this.builtIn + "]";
        }

        public int hashCode() {
            return Objects.hash(this.builtIn, this.converterClass, this.fieldClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultConverterEntry other = (DefaultConverterEntry)obj;
            return this.builtIn == other.builtIn && Objects.equals(this.converterClass, other.converterClass) && Objects.equals(this.fieldClass, other.fieldClass);
        }
    }

    public static class PolicyEntry<A extends Annotation, P extends Policy<A>, T> {
        private Class<A> annotationClass;
        private Class<P> policyClass;
        private Class<T> recipientType;
        private AnnotationUsage annotationUsage;
        private boolean builtIn;
        private boolean defaultPolicy;

        public PolicyEntry(Class<A> annotationClass, Class<P> policyClass, Class<T> recipientType, AnnotationUsage annotationUsage, boolean builtIn, boolean defaultPolicy) {
            this.annotationClass = annotationClass;
            this.policyClass = policyClass;
            this.recipientType = recipientType;
            this.annotationUsage = annotationUsage;
            this.builtIn = builtIn;
            this.defaultPolicy = defaultPolicy;
        }

        public Class<A> getAnnotationClass() {
            return this.annotationClass;
        }

        public Class<P> getPolicyClass() {
            return this.policyClass;
        }

        public Class<T> getRecipientType() {
            return this.recipientType;
        }

        public AnnotationUsage getAnnotationUsage() {
            return this.annotationUsage;
        }

        public boolean getBuiltIn() {
            return this.builtIn;
        }

        public boolean getDefaultPolicy() {
            return this.defaultPolicy;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.annotationClass, this.annotationUsage, this.builtIn, this.defaultPolicy, this.policyClass, this.recipientType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PolicyEntry other = (PolicyEntry)obj;
            return Objects.equals(this.annotationClass, other.annotationClass) && this.annotationUsage == other.annotationUsage && this.builtIn == other.builtIn && this.defaultPolicy == other.defaultPolicy && Objects.equals(this.policyClass, other.policyClass) && Objects.equals(this.recipientType, other.recipientType);
        }

        public String toString() {
            return "PolicyEntry [" + (this.annotationClass != null ? "annotationClass=" + this.annotationClass + ", " : "") + (this.policyClass != null ? "policyClass=" + this.policyClass + ", " : "") + (this.recipientType != null ? "recipientType=" + this.recipientType + ", " : "") + (this.annotationUsage != null ? "annotationUsage=" + (Object)((Object)this.annotationUsage) + ", " : "") + "builtIn=" + this.builtIn + ", defaultPolicy=" + this.defaultPolicy + "]";
        }
    }
}

