
function deleteOldTabIdCookie() {
    document.cookie = "_OldTabId=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/";
}

function deleteSetTabIdCookie() {
    document.cookie = "_SetTabId=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/";
}

function getCookie(cname) {
    var workingName;
    
    workingName = cname + "=";
    decodedCookie = decodeURIComponent(document.cookie);
    ca = decodedCookie.split(';');
    for (i = 0; i < ca.length; i++) {
        c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(workingName) == 0) {
          return c.substring(workingName.length, c.length);
        }
    }
    return "";
}

/**
 * Returns tab id from top  name, provided generateTabId has been called in the tab's lifetime. 
 */
function getTabId() {
    return window.top.name;
}

/**
 * Returns extension of URL, such as 'html' from 'http://www.myhost.com/index.html'
 */
function getUrlExtension(url) {
    return url.split(/[#?]/)[0].split('.').pop().trim();
}

/**
 * Sets cookie to identify browser tab to copy, which is read by web server.
 */
function setOldTabIdCookie(oldTabId) {
    var strCookie;
    
    strCookie = '_OldTabId=' + oldTabId + '; SameSite=Strict; path=/';
    if (window.location.protocol.toLowerCase() == 'https:') {
        strCookie += ' secure;';
    }

    document.cookie = strCookie;
}

/**
 * Sets cookie to identify browser tab, which is read by web server.  Call in BODY onfocus and onmouseover.
 */
function setTabIdCookie() {
    var strCookie, tabId;
    
    deleteOldTabIdCookie();
    tabId = getTabId();
    strCookie = '_TabId=' + tabId + '; SameSite=Strict; path=/';
    if (window.location.protocol.toLowerCase() == 'https:') {
        strCookie += ' secure;';
    }

    document.cookie = strCookie;
}

/**
 * Sets top window name to a unique id to distinguish tabs of the same browser and calls setTabIdCookie.
 * 
 * This was inspired by Mike A's answer at {@link http://stackoverflow.com/questions/368653/how-to-differ-sessions-in-browser-tabs}.
 */
function tabStartup() {
    var cookieValue;
    
    deleteOldTabIdCookie();
    cookieValue = getCookie("_SetTabId");
    if (cookieValue != "") {
        window.top.name = cookieValue;
        deleteSetTabIdCookie();
    }
    if (window.top.name == "") {
        window.top.name = "" + (new Date()).getTime();
        cookieValue = getCookie("_TabId");
        setTabIdCookie();
        if (cookieValue != "" && !urlHasNoServerState(location.toString())) {
            setOldTabIdCookie(cookieValue);
            location.reload();
        }
    }
    window.addEventListener("focus", setTabIdCookie);
    document.body.addEventListener("focus", setTabIdCookie);
    document.body.addEventListener("mouseover", setTabIdCookie);
}

/**
 * Returns URL does not use server side tab id.
 */
function urlHasNoServerState(url) {
    var extension;
    
    extension = getUrlExtension(url);
    return extension == 'html' || extension == 'jsp';
}

window.addEventListener("load", tabStartup);
