package name.matthewgreet.strutscommons.action;

import java.util.Collection;

import com.opensymphony.xwork2.interceptor.ValidationAware;

/**
 * Interface that indicates Action can accept warning messages as well as standard messages, error messages and field 
 * errors. 
 */
public interface ValidationAware2 extends ValidationAware {

    /**
     * Returns warning messages to display to the user.  New messages should not be added to the result, use 
     * {@link #addActionWarning #addActionWarning} instead.
     */
    public Collection<String> getActionWarnings();

    /**
     * Sets warning messages to display to the user.
     */
    public void setActionWarnings(Collection<String> errorMessages);

    /**
     * Adds warning message to display to the user.
     */
    public void addActionWarning(String message);

    /**
     * Returns whether there are any warning messages.
     */
    public boolean hasActionWarnings();

}
