package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.policy.AbstractCustomPostConversionAdjusterSupport;
import name.matthewgreet.strutscommons.policy.PostConversionAdjuster;




/**
 * <P>Defines how a single value form field value (whether on a Struts Action or model of ModelDriven Struts Action) 
 * that should be modified after conversion but before post conversion validation using a client supplied adjuster.  The 
 * custom adjuster must implement {@link PostConversionAdjuster}, preferably extending 
 * {@link AbstractCustomPostConversionAdjusterSupport}, and have a default public constructor.</P>
 * 
 * <P>Other parameters</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Other Parameters</CAPTION>
 *   <TR CLASS="row_odd">
 *     <TD>adjusterClass</TD>
 *     <TD>Class of client supplied adjuster.  See notes above.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>param1</TD>
 *     <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>param2</TD>
 *     <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>param3</TD>
 *     <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>param4</TD>
 *     <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *      <TD>param5</TD>
 *      <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>processNoValue</TD>
 *     <TD>If true, can adjust null value.  Defaults to false.</TD>
 *   </TR>
 * </TABLE>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface CustomPostConversionAdjuster {
    public Class<? extends PostConversionAdjuster<CustomPostConversionAdjuster,?>> adjusterClass();
    public String param1() default "";
    public String param2() default "";
    public String param3() default "";
    public String param4() default "";
    public String param5() default "";
    public boolean processNoValue() default false;
}
