package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.action.LoggingAware;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.policy.AbstractCustomNonConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.NonConversionValidator;

/**
 * <P>Defines a single value form field (whether on a Struts Action or model of ModelDriven Struts Action) to be 
 * validated using a client supplied validator and error message to display if this fails.  The custom validator must 
 * implement{@link NonConversionValidator}, preferably extending {@link AbstractCustomNonConversionValidatorSupport}, 
 * and have a default public constructor.</P>
 * 
 * <P>By default, messages are written as Action error messages for form processing Actions and logged as warnings for 
 *    viewer Actions but this can be overridden by <CODE>messageType</CODE>.  For viewer Actions, it's recommended they 
 *    implement {@link LoggingAware} and set a logging message type.</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Message Types</CAPTION>
 *   <TR CLASS="row_odd">
 *     <TD>DEFAULT</TD>
 *     <TD>Uses default setting of controlling interceptor or library, which is usually Action error messages for form 
 *         processing Actions and logged as warnings for view ActionsMessage.  Default.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>ERROR</TD>
 *     <TD>Message added to Action level error messages.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>FIELD</TD>
 *     <TD>Message added to field error messages using same name as field.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>IGNORE</TD>
 *     <TD>Message is not shown to user or logged.  This is not recommended.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>LOG_DEBUG</TD>
 *     <TD>Logged to Action's Log4j2 logger (or controlling interceptor's if not available) at DEBUG level.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>LOG_ERROR</TD>
 *     <TD>Logged to Action's Log4j2 logger (or controlling interceptor's if not available) at ERROR level.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>LOG_INFO</TD>
 *     <TD>Logged to Action's Log4j2 logger (or controlling interceptor's if not available) at INFO level.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>LOG_TRACE</TD>
 *     <TD>Logged to Action's Log4j2 logger (or controlling interceptor's if not available) at TRACE level.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>LOG_WARN</TD>
 *     <TD>Logged to Action's Log4j2 logger (or controlling interceptor's if not available) at WARN level.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>MESSAGE</TD>
 *     <TD>Message added to Action level info messages.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>WARNING</TD>
 *     <TD>Message added to Action level warning messages.</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>Other parameters</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Other Parameters</CAPTION>
 *   <TR CLASS="row_odd">
 *     <TD>message</TD>
 *     <TD>If not empty string, text message to display.  Used if <CODE>messageKey</CODE> is empty string or finds no 
 *         message.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>messageKey</TD>
 *     <TD>If not empty string, message key to retrieve from Action's TextProvider.  Uses <CODE>message</CODE> if no key 
 *         provided or no message found.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>param1</TD>
 *     <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>param2</TD>
 *     <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>param3</TD>
 *     <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>param4</TD>
 *     <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>param5</TD>
 *     <TD>Parameter recognised by custom validator.  Defaults to empty string.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>shortCircuit</TD>
 *     <TD>If true and this validation fails, skips further validation.  Defaults to false.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>processNoValue</TD>
 *     <TD>If true, can validate empty string.  Defaults to false.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>validatorClass</TD>
 *     <TD>Class of client supplied validator.  See notes above.</TD>
 *   </TR>
 * </TABLE>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface CustomValidation {
    public String message() default "";
    public String messageKey() default "";
    public MessageType messageType() default MessageType.DEFAULT;
    public String param1() default "";
    public String param2() default "";
    public String param3() default "";
    public String param4() default "";
    public String param5() default "";
    public boolean shortCircuit() default false;
    public boolean processNoValue() default false;
    public Class<? extends NonConversionValidator<CustomValidation>> validatorClass();
}
